/*
 * Decompiled with CFR 0.152.
 */
package alfio.model.subscription;

import alfio.model.support.JSONData;
import alfio.util.Json;
import alfio.util.MonetaryUtil;
import ch.digitalfondue.npjt.ConstructorAnnotationRowMapper;
import com.fasterxml.jackson.core.type.TypeReference;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import lombok.Generated;

public class EventSubscriptionLink {
    private final UUID subscriptionDescriptorId;
    private final Map<String, String> subscriptionDescriptorTitle;
    private final int eventId;
    private final String eventShortName;
    private final String eventDisplayName;
    private final int pricePerTicket;
    private final String eventCurrency;
    private final List<Integer> compatibleCategories;

    public EventSubscriptionLink(@ConstructorAnnotationRowMapper.Column(value="subscription_descriptor_id") UUID subscriptionDescriptorId, @ConstructorAnnotationRowMapper.Column(value="subscription_descriptor_title") @JSONData Map<String, String> subscriptionDescriptorTitle, @ConstructorAnnotationRowMapper.Column(value="event_id") int eventId, @ConstructorAnnotationRowMapper.Column(value="event_short_name") String eventShortName, @ConstructorAnnotationRowMapper.Column(value="event_display_name") String eventDisplayName, @ConstructorAnnotationRowMapper.Column(value="event_currency") String eventCurrency, @ConstructorAnnotationRowMapper.Column(value="price_per_ticket") int pricePerTicket, @ConstructorAnnotationRowMapper.Column(value="compatible_categories") String compatibleCategories) {
        this.subscriptionDescriptorId = subscriptionDescriptorId;
        this.subscriptionDescriptorTitle = subscriptionDescriptorTitle;
        this.eventId = eventId;
        this.eventShortName = eventShortName;
        this.eventCurrency = eventCurrency;
        this.eventDisplayName = eventDisplayName;
        this.pricePerTicket = pricePerTicket;
        this.compatibleCategories = (List)Json.fromJson((String)Objects.requireNonNullElse(compatibleCategories, "[]"), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
    }

    public BigDecimal getFormattedPricePerTicket() {
        return MonetaryUtil.centsToUnit((int)this.pricePerTicket, (String)this.eventCurrency);
    }

    @Generated
    public UUID getSubscriptionDescriptorId() {
        return this.subscriptionDescriptorId;
    }

    @Generated
    public Map<String, String> getSubscriptionDescriptorTitle() {
        return this.subscriptionDescriptorTitle;
    }

    @Generated
    public int getEventId() {
        return this.eventId;
    }

    @Generated
    public String getEventShortName() {
        return this.eventShortName;
    }

    @Generated
    public String getEventDisplayName() {
        return this.eventDisplayName;
    }

    @Generated
    public int getPricePerTicket() {
        return this.pricePerTicket;
    }

    @Generated
    public String getEventCurrency() {
        return this.eventCurrency;
    }

    @Generated
    public List<Integer> getCompatibleCategories() {
        return this.compatibleCategories;
    }
}

