/*
 * Decompiled with CFR 0.152.
 */
package alfio.model.subscription;

import alfio.model.AllocationStatus;
import alfio.model.TimeZoneInfo;
import alfio.util.ClockProvider;
import alfio.util.LocaleUtil;
import alfio.util.PinGenerator;
import ch.digitalfondue.npjt.ConstructorAnnotationRowMapper;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.springframework.validation.BindingResult;

/*
 * Exception performing whole class analysis ignored.
 */
public class Subscription
implements TimeZoneInfo {
    private static final DateTimeFormatter VALIDITY_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
    private final UUID id;
    private final String firstName;
    private final String lastName;
    private final String email;
    private final UUID subscriptionDescriptorId;
    private final String reservationId;
    private final int organizationId;
    private final ZonedDateTime creationTime;
    private final ZonedDateTime updateTime;
    private final int srcPriceCts;
    private final int discountCts;
    private final String currency;
    private final AllocationStatus status;
    private final int maxEntries;
    private final ZonedDateTime validityFrom;
    private final ZonedDateTime validityTo;
    private final ZonedDateTime confirmationTimestamp;
    private final ZoneId zoneId;
    public static final int PIN_LENGTH = 8;

    public Subscription(@ConstructorAnnotationRowMapper.Column(value="id") UUID id, @ConstructorAnnotationRowMapper.Column(value="first_name") String firstName, @ConstructorAnnotationRowMapper.Column(value="last_name") String lastName, @ConstructorAnnotationRowMapper.Column(value="email_address") String email, @ConstructorAnnotationRowMapper.Column(value="subscription_descriptor_fk") UUID subscriptionDescriptorId, @ConstructorAnnotationRowMapper.Column(value="reservation_id_fk") String reservationId, @ConstructorAnnotationRowMapper.Column(value="organization_id_fk") int organizationId, @ConstructorAnnotationRowMapper.Column(value="creation_ts") ZonedDateTime creationTime, @ConstructorAnnotationRowMapper.Column(value="update_ts") ZonedDateTime updateTime, @ConstructorAnnotationRowMapper.Column(value="src_price_cts") int srcPriceCts, @ConstructorAnnotationRowMapper.Column(value="discount_cts") int discountCts, @ConstructorAnnotationRowMapper.Column(value="currency") String currency, @ConstructorAnnotationRowMapper.Column(value="status") AllocationStatus status, @ConstructorAnnotationRowMapper.Column(value="max_entries") int maxEntries, @ConstructorAnnotationRowMapper.Column(value="validity_from") ZonedDateTime validityFrom, @ConstructorAnnotationRowMapper.Column(value="validity_to") ZonedDateTime validityTo, @ConstructorAnnotationRowMapper.Column(value="confirmation_ts") ZonedDateTime confirmationTimestamp, @ConstructorAnnotationRowMapper.Column(value="time_zone") String timeZone) {
        ZoneId zone;
        this.id = id;
        this.firstName = firstName;
        this.lastName = lastName;
        this.email = email;
        this.subscriptionDescriptorId = subscriptionDescriptorId;
        this.reservationId = reservationId;
        this.organizationId = organizationId;
        this.creationTime = creationTime;
        this.updateTime = updateTime;
        this.srcPriceCts = srcPriceCts;
        this.discountCts = discountCts;
        this.currency = currency;
        this.status = status;
        this.maxEntries = maxEntries;
        this.zoneId = zone = ZoneId.of(timeZone);
        this.validityFrom = LocaleUtil.atZone((ZonedDateTime)validityFrom, (ZoneId)zone);
        this.validityTo = LocaleUtil.atZone((ZonedDateTime)validityTo, (ZoneId)zone);
        this.confirmationTimestamp = LocaleUtil.atZone((ZonedDateTime)confirmationTimestamp, (ZoneId)zone);
    }

    public boolean isValid(Optional<BindingResult> bindingResult) {
        if (this.status != AllocationStatus.ACQUIRED) {
            Subscription.reject(bindingResult, (String)"subscription.not.acquired");
            return false;
        }
        ZonedDateTime now = this.now(ClockProvider.clock());
        if (this.validityFrom != null && this.validityFrom.isAfter(now)) {
            Subscription.reject(bindingResult, (String)"subscription.not.valid");
            return false;
        }
        if (this.validityTo != null && this.validityTo.isBefore(now)) {
            Subscription.reject(bindingResult, (String)"subscription.expired");
            return false;
        }
        return true;
    }

    private static void reject(Optional<BindingResult> bindingResult, String errorCode) {
        bindingResult.ifPresent(b -> b.reject(errorCode));
    }

    public boolean isValid() {
        return this.isValid(Optional.empty());
    }

    public String getPin() {
        return PinGenerator.uuidToPin((String)this.id.toString(), (int)8);
    }

    @JsonIgnore
    public ZoneId getZoneId() {
        return this.zoneId;
    }

    public String getFormattedValidityTo() {
        if (this.validityTo == null) {
            return null;
        }
        return this.validityTo.format(VALIDITY_FORMATTER);
    }

    public String getFormattedValidityFrom() {
        if (this.validityFrom == null) {
            return null;
        }
        return this.validityFrom.format(VALIDITY_FORMATTER);
    }

    @Generated
    public UUID getId() {
        return this.id;
    }

    @Generated
    public String getFirstName() {
        return this.firstName;
    }

    @Generated
    public String getLastName() {
        return this.lastName;
    }

    @Generated
    public String getEmail() {
        return this.email;
    }

    @Generated
    public UUID getSubscriptionDescriptorId() {
        return this.subscriptionDescriptorId;
    }

    @Generated
    public String getReservationId() {
        return this.reservationId;
    }

    @Generated
    public int getOrganizationId() {
        return this.organizationId;
    }

    @Generated
    public ZonedDateTime getCreationTime() {
        return this.creationTime;
    }

    @Generated
    public ZonedDateTime getUpdateTime() {
        return this.updateTime;
    }

    @Generated
    public int getSrcPriceCts() {
        return this.srcPriceCts;
    }

    @Generated
    public int getDiscountCts() {
        return this.discountCts;
    }

    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Generated
    public AllocationStatus getStatus() {
        return this.status;
    }

    @Generated
    public int getMaxEntries() {
        return this.maxEntries;
    }

    @Generated
    public ZonedDateTime getValidityFrom() {
        return this.validityFrom;
    }

    @Generated
    public ZonedDateTime getValidityTo() {
        return this.validityTo;
    }

    @Generated
    public ZonedDateTime getConfirmationTimestamp() {
        return this.confirmationTimestamp;
    }
}

