/*
 * Decompiled with CFR 0.152.
 */
package alfio.model.subscription;

import alfio.manager.system.ConfigurationLevel;
import alfio.model.ContentLanguage;
import alfio.model.Event;
import alfio.model.PriceContainer;
import alfio.model.PurchaseContext;
import alfio.model.subscription.SubscriptionDescriptor;
import alfio.model.support.Array;
import alfio.model.support.JSONData;
import alfio.model.transaction.PaymentProxy;
import alfio.util.ClockProvider;
import alfio.util.LocaleUtil;
import alfio.util.MonetaryUtil;
import alfio.util.MustacheCustomTag;
import ch.digitalfondue.npjt.ConstructorAnnotationRowMapper;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.math.BigDecimal;
import java.time.Clock;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class SubscriptionDescriptor
implements PurchaseContext {
    private final UUID id;
    private final Map<String, String> title;
    private final Map<String, String> description;
    private final int maxAvailable;
    private final ZonedDateTime creation;
    private final ZonedDateTime onSaleFrom;
    private final ZonedDateTime onSaleTo;
    private final int price;
    private final BigDecimal vat;
    private final PriceContainer.VatStatus vatStatus;
    private final String currency;
    private final boolean isPublic;
    private final int organizationId;
    private final int maxEntries;
    private final SubscriptionValidityType validityType;
    private final SubscriptionTimeUnit validityTimeUnit;
    private final Integer validityUnits;
    private final ZonedDateTime validityFrom;
    private final ZonedDateTime validityTo;
    private final SubscriptionUsageType usageType;
    private final String termsAndConditionsUrl;
    private final String privacyPolicyUrl;
    private final String fileBlobId;
    private final List<PaymentProxy> paymentProxies;
    private final String privateKey;
    private final String timeZone;
    private final boolean supportsTicketsGeneration;

    public SubscriptionDescriptor(@ConstructorAnnotationRowMapper.Column(value="id") UUID id, @ConstructorAnnotationRowMapper.Column(value="title") @JSONData Map<String, String> title, @ConstructorAnnotationRowMapper.Column(value="description") @JSONData Map<String, String> description, @ConstructorAnnotationRowMapper.Column(value="max_available") int maxAvailable, @ConstructorAnnotationRowMapper.Column(value="creation_ts") ZonedDateTime creation, @ConstructorAnnotationRowMapper.Column(value="on_sale_from") ZonedDateTime onSaleFrom, @ConstructorAnnotationRowMapper.Column(value="on_sale_to") ZonedDateTime onSaleTo, @ConstructorAnnotationRowMapper.Column(value="price_cts") int price, @ConstructorAnnotationRowMapper.Column(value="vat") BigDecimal vat, @ConstructorAnnotationRowMapper.Column(value="vat_status") PriceContainer.VatStatus vatStatus, @ConstructorAnnotationRowMapper.Column(value="currency") String currency, @ConstructorAnnotationRowMapper.Column(value="is_public") boolean isPublic, @ConstructorAnnotationRowMapper.Column(value="organization_id_fk") int organizationId, @ConstructorAnnotationRowMapper.Column(value="max_entries") int maxEntries, @ConstructorAnnotationRowMapper.Column(value="validity_type") SubscriptionValidityType validityType, @ConstructorAnnotationRowMapper.Column(value="validity_time_unit") SubscriptionTimeUnit validityTimeUnit, @ConstructorAnnotationRowMapper.Column(value="validity_units") Integer validityUnits, @ConstructorAnnotationRowMapper.Column(value="validity_from") ZonedDateTime validityFrom, @ConstructorAnnotationRowMapper.Column(value="validity_to") ZonedDateTime validityTo, @ConstructorAnnotationRowMapper.Column(value="usage_type") SubscriptionUsageType usageType, @ConstructorAnnotationRowMapper.Column(value="terms_conditions_url") String termsAndConditionsUrl, @ConstructorAnnotationRowMapper.Column(value="privacy_policy_url") String privacyPolicyUrl, @ConstructorAnnotationRowMapper.Column(value="file_blob_id_fk") String fileBlobId, @ConstructorAnnotationRowMapper.Column(value="allowed_payment_proxies") @Array List<String> paymentProxies, @ConstructorAnnotationRowMapper.Column(value="private_key") String privateKey, @ConstructorAnnotationRowMapper.Column(value="time_zone") String timeZone, @ConstructorAnnotationRowMapper.Column(value="supports_tickets_generation") Boolean supportsTicketsGeneration) {
        ZoneId zoneId = ZoneId.of(timeZone);
        this.id = id;
        this.title = title;
        this.description = description;
        this.maxAvailable = maxAvailable;
        this.creation = creation;
        this.timeZone = timeZone;
        this.onSaleFrom = LocaleUtil.atZone((ZonedDateTime)onSaleFrom, (ZoneId)zoneId);
        this.onSaleTo = LocaleUtil.atZone((ZonedDateTime)onSaleTo, (ZoneId)zoneId);
        this.price = price;
        this.vat = vat;
        this.vatStatus = vatStatus;
        this.currency = currency;
        this.isPublic = isPublic;
        this.organizationId = organizationId;
        this.maxEntries = maxEntries;
        this.validityType = validityType;
        this.validityTimeUnit = validityTimeUnit;
        this.validityUnits = validityUnits;
        this.validityFrom = LocaleUtil.atZone((ZonedDateTime)validityFrom, (ZoneId)zoneId);
        this.validityTo = LocaleUtil.atZone((ZonedDateTime)validityTo, (ZoneId)zoneId);
        this.usageType = usageType;
        this.termsAndConditionsUrl = termsAndConditionsUrl;
        this.privacyPolicyUrl = privacyPolicyUrl;
        this.fileBlobId = fileBlobId;
        this.paymentProxies = paymentProxies.stream().map(PaymentProxy::valueOf).collect(Collectors.toList());
        this.privateKey = privateKey;
        this.supportsTicketsGeneration = Boolean.TRUE.equals(supportsTicketsGeneration);
    }

    public List<ContentLanguage> getContentLanguages() {
        Set languages = this.title.keySet();
        return ContentLanguage.ALL_LANGUAGES.stream().filter(l -> languages.contains(l.getLanguage())).collect(Collectors.toList());
    }

    @JsonIgnore
    public ConfigurationLevel getConfigurationLevel() {
        return ConfigurationLevel.subscriptionDescriptor((SubscriptionDescriptor)this);
    }

    public List<PaymentProxy> getAllowedPaymentProxies() {
        return this.getPaymentProxies();
    }

    public String getPrivacyPolicyLinkOrNull() {
        return StringUtils.trimToNull((String)this.privacyPolicyUrl);
    }

    public String getPublicIdentifier() {
        return this.getId().toString();
    }

    @JsonIgnore
    public PurchaseContext.PurchaseContextType getType() {
        return PurchaseContext.PurchaseContextType.subscription;
    }

    @JsonIgnore
    public ZoneId getZoneId() {
        return ZoneId.of(this.timeZone);
    }

    public String getDisplayName() {
        return this.title.keySet().stream().findFirst().map(this.title::get).orElse("Subscription");
    }

    @JsonIgnore
    public Optional<Event> event() {
        return Optional.empty();
    }

    @JsonIgnore
    public String getPrivateKey() {
        return this.privateKey;
    }

    public ZonedDateTime getBegin() {
        return this.validityFrom != null ? this.validityFrom : ZonedDateTime.now(ClockProvider.clock()).plusMonths(2L);
    }

    @JsonIgnore
    public boolean isUnlimitedAccess() {
        return this.maxEntries == -1;
    }

    public boolean isFreeOfCharge() {
        return false;
    }

    public String getLocalizedTitle(Locale locale) {
        String fallbackLocale = this.title.keySet().stream().findFirst().orElse("en");
        return MustacheCustomTag.renderToTextCommonmark((String)this.title.getOrDefault(locale.toLanguageTag(), fallbackLocale));
    }

    public Map<String, String> getTitleAsText() {
        return this.renderTextCommonMark(this.title);
    }

    public Map<String, String> getDescriptionAsText() {
        return this.renderTextCommonMark(this.description);
    }

    public boolean withinSalePeriod(Clock clock) {
        ZonedDateTime now = this.now(clock);
        return Objects.requireNonNullElseGet(this.onSaleFrom, () -> now.minusHours(1L)).isBefore(now) && Objects.requireNonNullElseGet(this.onSaleTo, () -> now.plusHours(1L)).isAfter(now);
    }

    private Map<String, String> renderTextCommonMark(Map<String, String> original) {
        return original.entrySet().stream().map(entry -> Map.entry((String)entry.getKey(), MustacheCustomTag.renderToTextCommonmark((String)((String)entry.getValue())))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public String getFormattedPrice() {
        return MonetaryUtil.formatCents((int)this.price, (String)this.currency);
    }

    @Generated
    public UUID getId() {
        return this.id;
    }

    @Generated
    public Map<String, String> getTitle() {
        return this.title;
    }

    @Generated
    public Map<String, String> getDescription() {
        return this.description;
    }

    @Generated
    public int getMaxAvailable() {
        return this.maxAvailable;
    }

    @Generated
    public ZonedDateTime getCreation() {
        return this.creation;
    }

    @Generated
    public ZonedDateTime getOnSaleFrom() {
        return this.onSaleFrom;
    }

    @Generated
    public ZonedDateTime getOnSaleTo() {
        return this.onSaleTo;
    }

    @Generated
    public int getPrice() {
        return this.price;
    }

    @Generated
    public BigDecimal getVat() {
        return this.vat;
    }

    @Generated
    public PriceContainer.VatStatus getVatStatus() {
        return this.vatStatus;
    }

    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Generated
    public boolean isPublic() {
        return this.isPublic;
    }

    @Generated
    public int getOrganizationId() {
        return this.organizationId;
    }

    @Generated
    public int getMaxEntries() {
        return this.maxEntries;
    }

    @Generated
    public SubscriptionValidityType getValidityType() {
        return this.validityType;
    }

    @Generated
    public SubscriptionTimeUnit getValidityTimeUnit() {
        return this.validityTimeUnit;
    }

    @Generated
    public Integer getValidityUnits() {
        return this.validityUnits;
    }

    @Generated
    public ZonedDateTime getValidityFrom() {
        return this.validityFrom;
    }

    @Generated
    public ZonedDateTime getValidityTo() {
        return this.validityTo;
    }

    @Generated
    public SubscriptionUsageType getUsageType() {
        return this.usageType;
    }

    @Generated
    public String getTermsAndConditionsUrl() {
        return this.termsAndConditionsUrl;
    }

    @Generated
    public String getPrivacyPolicyUrl() {
        return this.privacyPolicyUrl;
    }

    @Generated
    public String getFileBlobId() {
        return this.fileBlobId;
    }

    @Generated
    public List<PaymentProxy> getPaymentProxies() {
        return this.paymentProxies;
    }

    @Generated
    public String getTimeZone() {
        return this.timeZone;
    }

    @Generated
    public boolean isSupportsTicketsGeneration() {
        return this.supportsTicketsGeneration;
    }
}

