/*
 * Decompiled with CFR 0.152.
 */
package alfio.model.subscription;

import alfio.model.PriceContainer;
import alfio.model.subscription.SubscriptionDescriptor;
import alfio.model.support.Array;
import alfio.model.support.JSONData;
import alfio.util.MonetaryUtil;
import ch.digitalfondue.npjt.ConstructorAnnotationRowMapper;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;

public class SubscriptionDescriptorWithStatistics {
    private final int soldCount;
    private final int pendingCount;
    private final int linkedEventsCount;
    private final int reservationsCount;
    private final SubscriptionDescriptor descriptor;

    public SubscriptionDescriptorWithStatistics(@ConstructorAnnotationRowMapper.Column(value="sd_id") UUID id, @ConstructorAnnotationRowMapper.Column(value="sd_title") @JSONData Map<String, String> title, @ConstructorAnnotationRowMapper.Column(value="sd_description") @JSONData Map<String, String> description, @ConstructorAnnotationRowMapper.Column(value="sd_max_available") int maxAvailable, @ConstructorAnnotationRowMapper.Column(value="sd_creation_ts") ZonedDateTime creation, @ConstructorAnnotationRowMapper.Column(value="sd_on_sale_from") ZonedDateTime onSaleFrom, @ConstructorAnnotationRowMapper.Column(value="sd_on_sale_to") ZonedDateTime onSaleTo, @ConstructorAnnotationRowMapper.Column(value="sd_price_cts") int price, @ConstructorAnnotationRowMapper.Column(value="sd_vat") BigDecimal vat, @ConstructorAnnotationRowMapper.Column(value="sd_vat_status") PriceContainer.VatStatus vatStatus, @ConstructorAnnotationRowMapper.Column(value="sd_currency") String currency, @ConstructorAnnotationRowMapper.Column(value="sd_is_public") boolean isPublic, @ConstructorAnnotationRowMapper.Column(value="sd_organization_id_fk") int organizationId, @ConstructorAnnotationRowMapper.Column(value="sd_max_entries") int maxEntries, @ConstructorAnnotationRowMapper.Column(value="sd_validity_type") SubscriptionDescriptor.SubscriptionValidityType validityType, @ConstructorAnnotationRowMapper.Column(value="sd_validity_time_unit") SubscriptionDescriptor.SubscriptionTimeUnit validityTimeUnit, @ConstructorAnnotationRowMapper.Column(value="sd_validity_units") Integer validityUnits, @ConstructorAnnotationRowMapper.Column(value="sd_validity_from") ZonedDateTime validityFrom, @ConstructorAnnotationRowMapper.Column(value="sd_validity_to") ZonedDateTime validityTo, @ConstructorAnnotationRowMapper.Column(value="sd_usage_type") SubscriptionDescriptor.SubscriptionUsageType usageType, @ConstructorAnnotationRowMapper.Column(value="sd_terms_conditions_url") String termsAndConditionsUrl, @ConstructorAnnotationRowMapper.Column(value="sd_privacy_policy_url") String privacyPolicyUrl, @ConstructorAnnotationRowMapper.Column(value="sd_file_blob_id_fk") String fileBlobId, @ConstructorAnnotationRowMapper.Column(value="sd_allowed_payment_proxies") @Array List<String> paymentProxies, @ConstructorAnnotationRowMapper.Column(value="sd_private_key") String privateKey, @ConstructorAnnotationRowMapper.Column(value="sd_time_zone") String timeZone, @ConstructorAnnotationRowMapper.Column(value="sd_supports_tickets_generation") Boolean supportsTicketsGeneration, @ConstructorAnnotationRowMapper.Column(value="s_pending_count") int pendingCount, @ConstructorAnnotationRowMapper.Column(value="s_sold_count") int soldCount, @ConstructorAnnotationRowMapper.Column(value="s_reservations_count") int reservationsCount, @ConstructorAnnotationRowMapper.Column(value="s_events_count") int linkedEventsCount) {
        this.pendingCount = pendingCount;
        this.soldCount = soldCount;
        this.linkedEventsCount = linkedEventsCount;
        this.reservationsCount = reservationsCount;
        this.descriptor = new SubscriptionDescriptor(id, title, description, maxAvailable, creation, onSaleFrom, onSaleTo, price, vat, vatStatus, currency, isPublic, organizationId, maxEntries, validityType, validityTimeUnit, validityUnits, validityFrom, validityTo, usageType, termsAndConditionsUrl, privacyPolicyUrl, fileBlobId, paymentProxies, privateKey, timeZone, supportsTicketsGeneration);
    }

    public BigDecimal getUnitPrice() {
        return MonetaryUtil.centsToUnit((int)this.descriptor.getPrice(), (String)this.descriptor.getCurrency());
    }

    public int getAvailableCount() {
        if (this.descriptor.getMaxAvailable() > 0) {
            return Math.max(0, this.descriptor.getMaxAvailable() - this.soldCount - this.pendingCount);
        }
        return 0;
    }

    @Generated
    public int getSoldCount() {
        return this.soldCount;
    }

    @Generated
    public int getPendingCount() {
        return this.pendingCount;
    }

    @Generated
    public int getLinkedEventsCount() {
        return this.linkedEventsCount;
    }

    @Generated
    public int getReservationsCount() {
        return this.reservationsCount;
    }

    @Generated
    public SubscriptionDescriptor getDescriptor() {
        return this.descriptor;
    }
}

