/*
 * Decompiled with CFR 0.152.
 */
package alfio.model.subscription;

import alfio.model.PriceContainer;
import alfio.model.PromoCodeDiscount;
import alfio.model.subscription.Subscription;
import alfio.model.subscription.SubscriptionDescriptor;
import alfio.util.MonetaryUtil;
import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.util.Optional;
import lombok.Generated;

public class SubscriptionPriceContainer
implements PriceContainer {
    private final Subscription subscription;
    private final PromoCodeDiscount promoCodeDiscount;
    private final SubscriptionDescriptor descriptor;

    public int getSrcPriceCts() {
        return this.subscription.getSrcPriceCts();
    }

    public String getCurrencyCode() {
        return this.subscription.getCurrency();
    }

    public Optional<BigDecimal> getOptionalVatPercentage() {
        return Optional.ofNullable(this.descriptor.getVat());
    }

    public PriceContainer.VatStatus getVatStatus() {
        return this.descriptor.getVatStatus();
    }

    public Optional<PromoCodeDiscount> getDiscount() {
        return Optional.ofNullable(this.promoCodeDiscount);
    }

    public BigDecimal getNetPrice() {
        PriceContainer.VatStatus vatStatus = this.getVatStatus();
        String currencyCode = this.getCurrencyCode();
        if (vatStatus == PriceContainer.VatStatus.NOT_INCLUDED_EXEMPT) {
            return MonetaryUtil.centsToUnit((int)this.getSrcPriceCts(), (String)currencyCode);
        }
        if (vatStatus == PriceContainer.VatStatus.INCLUDED_EXEMPT) {
            BigDecimal rawVat = vatStatus.extractRawVAT(MonetaryUtil.centsToUnit((int)this.getSrcPriceCts(), (String)this.getCurrencyCode()), this.getVatPercentageOrZero());
            return MonetaryUtil.centsToUnit((int)this.getSrcPriceCts(), (String)currencyCode).add(rawVat);
        }
        if (vatStatus == PriceContainer.VatStatus.INCLUDED) {
            BigDecimal rawVat = vatStatus.extractRawVAT(MonetaryUtil.centsToUnit((int)this.getSrcPriceCts(), (String)this.getCurrencyCode()), this.getVatPercentageOrZero());
            return MonetaryUtil.centsToUnit((int)this.getSrcPriceCts(), (String)currencyCode).subtract(rawVat);
        }
        return MonetaryUtil.centsToUnit((int)this.getSrcPriceCts(), (String)currencyCode);
    }

    public int getSummarySrcPriceCts() {
        if (PriceContainer.VatStatus.isVatExempt((PriceContainer.VatStatus)this.getVatStatus())) {
            return MonetaryUtil.unitToCents((BigDecimal)this.getFinalPrice(), (String)this.getCurrencyCode());
        }
        return this.getSrcPriceCts();
    }

    @ConstructorProperties(value={"subscription", "promoCodeDiscount", "descriptor"})
    @Generated
    public SubscriptionPriceContainer(Subscription subscription, PromoCodeDiscount promoCodeDiscount, SubscriptionDescriptor descriptor) {
        this.subscription = subscription;
        this.promoCodeDiscount = promoCodeDiscount;
        this.descriptor = descriptor;
    }
}

