/*
 * Decompiled with CFR 0.152.
 */
package alfio.model.system;

import alfio.model.EventAndOrganizationId;
import alfio.model.subscription.SubscriptionDescriptor;
import alfio.model.system.ComponentType;
import alfio.model.system.Configuration;
import alfio.model.system.ConfigurationKeys;
import alfio.model.system.ConfigurationPathLevel;
import ch.digitalfondue.npjt.ConstructorAnnotationRowMapper;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.function.Function;
import lombok.Generated;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

/*
 * Exception performing whole class analysis ignored.
 */
public class Configuration
implements Comparable<Configuration> {
    private final int id;
    private final String key;
    private final String value;
    private final String description;
    private final ConfigurationKeys configurationKey;
    private final ConfigurationPathLevel configurationPathLevel;
    private final boolean basic;
    private final boolean internal;

    @JsonCreator
    public Configuration(@JsonProperty(value="id") @ConstructorAnnotationRowMapper.Column(value="id") int id, @JsonProperty(value="key") @ConstructorAnnotationRowMapper.Column(value="c_key") String key, @JsonProperty(value="value") @ConstructorAnnotationRowMapper.Column(value="c_value") String value, @JsonProperty(value="configurationPathLevel") @ConstructorAnnotationRowMapper.Column(value="configuration_path_level") ConfigurationPathLevel configurationPathLevel) {
        this.id = id;
        this.key = key;
        this.value = value;
        this.configurationKey = ConfigurationKeys.safeValueOf((String)key);
        this.description = this.configurationKey.getDescription();
        this.configurationPathLevel = configurationPathLevel;
        this.basic = this.configurationKey.isBasic();
        this.internal = this.configurationKey.isInternal();
    }

    public ComponentType getComponentType() {
        return this.configurationKey.getComponentType();
    }

    @Override
    public int compareTo(Configuration o) {
        return new CompareToBuilder().append(this.configurationKey.ordinal(), o.configurationKey.ordinal()).toComparison();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Configuration)) {
            return false;
        }
        Configuration o = (Configuration)obj;
        return new EqualsBuilder().append((Object)this.configurationKey, (Object)o.configurationKey).append((Object)this.configurationPathLevel, (Object)this.configurationPathLevel).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.configurationKey).append((Object)this.configurationPathLevel).toHashCode();
    }

    public static ConfigurationPath system() {
        return new SystemConfigurationPath();
    }

    private static ConfigurationPath organization(int id) {
        return new OrganizationConfigurationPath(id);
    }

    private static ConfigurationPath ticketCategory(int organizationId, int eventId, int id) {
        return new TicketCategoryConfigurationPath(organizationId, eventId, id);
    }

    private static ConfigurationPathKey getOrganizationConfiguration(int organizationId, ConfigurationKeys configurationKey) {
        return new ConfigurationPathKey(Configuration.organization((int)organizationId), configurationKey);
    }

    private static ConfigurationPathKey getEventConfiguration(int organizationId, int eventId, ConfigurationKeys configurationKey) {
        return new ConfigurationPathKey((ConfigurationPath)new EventConfigurationPath(organizationId, eventId), configurationKey);
    }

    private static ConfigurationPathKey getTicketCategoryConfiguration(int organizationId, int eventId, int ticketCategoryId, ConfigurationKeys configurationKey) {
        return new ConfigurationPathKey(Configuration.ticketCategory((int)organizationId, (int)eventId, (int)ticketCategoryId), configurationKey);
    }

    public static ConfigurationPathKey from(int organizationId, ConfigurationKeys key) {
        return Configuration.getOrganizationConfiguration((int)organizationId, (ConfigurationKeys)key);
    }

    public static ConfigurationPathKey from(EventAndOrganizationId eventAndOrganizationId, ConfigurationKeys key) {
        return Configuration.getEventConfiguration((int)eventAndOrganizationId.getOrganizationId(), (int)eventAndOrganizationId.getId(), (ConfigurationKeys)key);
    }

    public static ConfigurationPathKey from(SubscriptionDescriptor subscriptionDescriptor, ConfigurationKeys key) {
        return new ConfigurationPathKey((ConfigurationPath)new SubscriptionDescriptorConfigurationPath(subscriptionDescriptor.getOrganizationId(), subscriptionDescriptor.getId()), key);
    }

    public static Function<ConfigurationKeys, ConfigurationPathKey> from(EventAndOrganizationId e) {
        return p -> Configuration.from((EventAndOrganizationId)e, (ConfigurationKeys)p);
    }

    public static Function<ConfigurationKeys, ConfigurationPathKey> from(int organizationId) {
        return p -> Configuration.from((int)organizationId, (ConfigurationKeys)p);
    }

    public static ConfigurationPathKey from(int organizationId, int eventId, int ticketCategoryId, ConfigurationKeys key) {
        return Configuration.getTicketCategoryConfiguration((int)organizationId, (int)eventId, (int)ticketCategoryId, (ConfigurationKeys)key);
    }

    @Generated
    public int getId() {
        return this.id;
    }

    @Generated
    public String getKey() {
        return this.key;
    }

    @Generated
    public String getValue() {
        return this.value;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public ConfigurationKeys getConfigurationKey() {
        return this.configurationKey;
    }

    @Generated
    public ConfigurationPathLevel getConfigurationPathLevel() {
        return this.configurationPathLevel;
    }

    @Generated
    public boolean isBasic() {
        return this.basic;
    }

    @Generated
    public boolean isInternal() {
        return this.internal;
    }
}

