/*
 * Decompiled with CFR 0.152.
 */
package alfio.model.transaction;

import alfio.manager.system.ConfigurationLevel;
import alfio.model.Event;
import alfio.model.PurchaseContext;
import java.util.Optional;

public class PaymentContext {
    private final PurchaseContext purchaseContext;
    private final String reservationId;
    private final ConfigurationLevel configurationLevel;

    public PaymentContext() {
        this(null, ConfigurationLevel.system());
    }

    public PaymentContext(PurchaseContext purchaseContext) {
        this(purchaseContext, purchaseContext.getConfigurationLevel());
    }

    public PaymentContext(PurchaseContext purchaseContext, String reservationId) {
        this(purchaseContext, purchaseContext.getConfigurationLevel(), reservationId);
    }

    public PaymentContext(PurchaseContext purchaseContext, ConfigurationLevel configurationLevel) {
        this(purchaseContext, configurationLevel, null);
    }

    public PaymentContext(PurchaseContext purchaseContext, ConfigurationLevel configurationLevel, String reservationId) {
        this.purchaseContext = purchaseContext;
        this.configurationLevel = configurationLevel;
        this.reservationId = reservationId;
    }

    public PurchaseContext getPurchaseContext() {
        return this.purchaseContext;
    }

    public Optional<String> getReservationId() {
        return Optional.ofNullable(this.reservationId);
    }

    public ConfigurationLevel getConfigurationLevel() {
        return this.configurationLevel;
    }

    public boolean isOnline() {
        return this.purchaseContext.event().map(Event::isOnline).orElse(true);
    }
}

