/*
 * Decompiled with CFR 0.152.
 */
package alfio.model.transaction;

import alfio.manager.payment.PaymentSpecification;
import alfio.manager.support.PaymentResult;
import alfio.model.transaction.PaymentContext;
import alfio.model.transaction.PaymentMethod;
import alfio.model.transaction.PaymentProxy;
import alfio.model.transaction.Transaction;
import alfio.model.transaction.TransactionRequest;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public interface PaymentProvider {
    public Set<PaymentMethod> getSupportedPaymentMethods(PaymentContext var1, TransactionRequest var2);

    public PaymentProxy getPaymentProxy();

    public boolean accept(PaymentMethod var1, PaymentContext var2, TransactionRequest var3);

    public boolean accept(Transaction var1);

    public PaymentMethod getPaymentMethodForTransaction(Transaction var1);

    public boolean isActive(PaymentContext var1);

    default public PaymentResult getToken(PaymentSpecification spec) {
        return PaymentResult.initialized((String)UUID.randomUUID().toString());
    }

    public PaymentResult doPayment(PaymentSpecification var1);

    default public PaymentResult getTokenAndPay(PaymentSpecification spec) {
        PaymentResult tokenResult = this.getToken(spec);
        if (tokenResult.isInitialized()) {
            return this.doPayment(spec);
        }
        return tokenResult;
    }

    default public Map<String, ?> getModelOptions(PaymentContext context) {
        return Collections.emptyMap();
    }
}

