/*
 * Decompiled with CFR 0.152.
 */
package alfio.model.transaction;

import alfio.model.system.ConfigurationKeys;
import alfio.model.transaction.PaymentMethod;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public enum PaymentProxy {
    STRIPE("stripe.com", false, true, EnumSet.of(ConfigurationKeys.SettingCategory.PAYMENT_STRIPE), true, Collections.emptySet(), PaymentMethod.CREDIT_CARD),
    ON_SITE("on-site payment", true, true, Collections.emptySet(), false, Collections.emptySet(), PaymentMethod.ON_SITE),
    OFFLINE("offline payment", false, true, EnumSet.of(ConfigurationKeys.SettingCategory.PAYMENT_OFFLINE), false, Collections.emptySet(), PaymentMethod.BANK_TRANSFER),
    NONE("no payment required", false, false, Collections.emptySet(), false, Collections.emptySet(), PaymentMethod.NONE),
    ADMIN("manual", false, false, Collections.emptySet(), false, Collections.emptySet(), PaymentMethod.NONE),
    PAYPAL("paypal", false, true, EnumSet.of(ConfigurationKeys.SettingCategory.PAYMENT_PAYPAL), true, Collections.emptySet(), PaymentMethod.PAYPAL),
    MOLLIE("mollie", false, true, EnumSet.of(ConfigurationKeys.SettingCategory.PAYMENT_MOLLIE), true, Collections.emptySet(), PaymentMethod.IDEAL),
    SAFERPAY("saferpay", false, true, EnumSet.of(ConfigurationKeys.SettingCategory.PAYMENT_SAFERPAY), false, Collections.emptySet(), PaymentMethod.CREDIT_CARD);

    private final String description;
    private final boolean deskPayment;
    private final boolean visible;
    private final Set<ConfigurationKeys.SettingCategory> settingCategories;
    private final boolean supportRefund;
    private final Set<String> onlyForCurrency;
    private final PaymentMethod paymentMethod;

    private PaymentProxy(String description, boolean deskPayment, boolean visible, Set<ConfigurationKeys.SettingCategory> settingCategories, boolean supportRefund, Set<String> onlyForCurrency, PaymentMethod paymentMethod) {
        this.description = description;
        this.deskPayment = deskPayment;
        this.visible = visible;
        this.settingCategories = settingCategories;
        this.supportRefund = supportRefund;
        this.onlyForCurrency = onlyForCurrency;
        this.paymentMethod = paymentMethod;
    }

    public String getDescription() {
        return this.description;
    }

    public String getKey() {
        return this.name();
    }

    public boolean isDeskPaymentRequired() {
        return this.deskPayment;
    }

    private boolean isVisible() {
        return this.visible;
    }

    public boolean isSupportRefund() {
        return this.supportRefund;
    }

    @JsonIgnore
    public Set<ConfigurationKeys.SettingCategory> getSettingCategories() {
        return this.settingCategories;
    }

    public static Optional<PaymentProxy> safeValueOf(String name) {
        return Arrays.stream(PaymentProxy.values()).filter(p -> StringUtils.equals((CharSequence)p.name(), (CharSequence)name)).findFirst();
    }

    public static List<PaymentProxy> availableProxies() {
        return Arrays.stream(PaymentProxy.values()).filter(PaymentProxy::isVisible).collect(Collectors.toList());
    }

    public static PaymentProxy fromPaymentMethod(PaymentMethod paymentMethod) {
        return PaymentProxy.availableProxies().stream().filter(pp -> pp.getPaymentMethod() == paymentMethod).findFirst().orElse(null);
    }

    public Set<String> getOnlyForCurrency() {
        return this.onlyForCurrency;
    }

    public PaymentMethod getPaymentMethod() {
        return this.paymentMethod;
    }
}

