/*
 * Decompiled with CFR 0.152.
 */
package alfio.model.transaction;

import alfio.model.support.JSONData;
import alfio.model.transaction.PaymentProxy;
import alfio.model.transaction.Transaction;
import alfio.util.MonetaryUtil;
import ch.digitalfondue.npjt.ConstructorAnnotationRowMapper;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;

public class Transaction {
    public static final String NOTES_KEY = "transactionNotes";
    private final int id;
    private final String transactionId;
    private final String paymentId;
    private final String reservationId;
    private final ZonedDateTime timestamp;
    private final int priceInCents;
    private final String currency;
    private final String description;
    private final PaymentProxy paymentProxy;
    private final long platformFee;
    private final long gatewayFee;
    private final Status status;
    private final Map<String, String> metadata;

    public Transaction(@ConstructorAnnotationRowMapper.Column(value="id") int id, @ConstructorAnnotationRowMapper.Column(value="gtw_tx_id") String transactionId, @ConstructorAnnotationRowMapper.Column(value="gtw_payment_id") String paymentId, @ConstructorAnnotationRowMapper.Column(value="reservation_id") String reservationId, @ConstructorAnnotationRowMapper.Column(value="t_timestamp") ZonedDateTime timestamp, @ConstructorAnnotationRowMapper.Column(value="price_cts") int priceInCents, @ConstructorAnnotationRowMapper.Column(value="currency") String currency, @ConstructorAnnotationRowMapper.Column(value="description") String description, @ConstructorAnnotationRowMapper.Column(value="payment_proxy") String paymentProxy, @ConstructorAnnotationRowMapper.Column(value="plat_fee") long platformFee, @ConstructorAnnotationRowMapper.Column(value="gtw_fee") long gatewayFee, @ConstructorAnnotationRowMapper.Column(value="status") Status status, @ConstructorAnnotationRowMapper.Column(value="metadata") @JSONData Map<String, String> metadata) {
        this.id = id;
        this.transactionId = transactionId;
        this.paymentId = paymentId;
        this.reservationId = reservationId;
        this.timestamp = timestamp;
        this.priceInCents = priceInCents;
        this.currency = currency;
        this.description = description;
        this.paymentProxy = PaymentProxy.valueOf((String)paymentProxy);
        this.platformFee = platformFee;
        this.gatewayFee = gatewayFee;
        this.status = status;
        this.metadata = Optional.ofNullable(metadata).orElse(Map.of());
    }

    public boolean isComplete() {
        return this.status == Status.COMPLETE;
    }

    public boolean isPotentialMatch() {
        return this.status == Status.OFFLINE_MATCHING_PAYMENT_FOUND || this.status == Status.OFFLINE_PENDING_REVIEW;
    }

    public String getFormattedAmount() {
        return MonetaryUtil.formatCents((int)this.priceInCents, (String)this.currency);
    }

    public String getNotes() {
        return this.metadata == null ? null : (String)this.metadata.get(NOTES_KEY);
    }

    public boolean isTimestampEditable() {
        return this.paymentProxy == PaymentProxy.OFFLINE || this.paymentProxy == PaymentProxy.ON_SITE;
    }

    @Generated
    public int getId() {
        return this.id;
    }

    @Generated
    public String getTransactionId() {
        return this.transactionId;
    }

    @Generated
    public String getPaymentId() {
        return this.paymentId;
    }

    @Generated
    public String getReservationId() {
        return this.reservationId;
    }

    @Generated
    public ZonedDateTime getTimestamp() {
        return this.timestamp;
    }

    @Generated
    public int getPriceInCents() {
        return this.priceInCents;
    }

    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public PaymentProxy getPaymentProxy() {
        return this.paymentProxy;
    }

    @Generated
    public long getPlatformFee() {
        return this.platformFee;
    }

    @Generated
    public long getGatewayFee() {
        return this.gatewayFee;
    }

    @Generated
    public Status getStatus() {
        return this.status;
    }

    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }
}

