/*
 * Decompiled with CFR 0.152.
 */
package alfio.model.transaction.provider;

import alfio.model.transaction.provider.RevolutTransactionDescriptor;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;

public class RevolutTransactionDescriptor {
    private final String id;
    private final String type;
    private final String requestId;
    private final String state;
    private final ZonedDateTime createdAt;
    private final ZonedDateTime updatedAt;
    private final ZonedDateTime completedAt;
    private final String reference;
    private final List<TransactionLeg> legs;

    @JsonCreator
    public RevolutTransactionDescriptor(@JsonProperty(value="id") String id, @JsonProperty(value="type") String type, @JsonProperty(value="request_id") String requestId, @JsonProperty(value="state") String state, @JsonProperty(value="created_at") ZonedDateTime createdAt, @JsonProperty(value="updated_at") ZonedDateTime updatedAt, @JsonProperty(value="completed_at") ZonedDateTime completedAt, @JsonProperty(value="reference") String reference, @JsonProperty(value="legs") List<TransactionLeg> legs) {
        this.id = id;
        this.type = type;
        this.requestId = requestId;
        this.state = state;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.completedAt = completedAt;
        this.reference = reference;
        this.legs = legs;
    }

    public BigDecimal getTransactionBalance() {
        return this.legs.stream().map(TransactionLeg::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    public Map<String, String> getMetadata() {
        return Map.of("counterpartyAccountId", Optional.ofNullable(((TransactionLeg)this.legs.get((int)0)).counterpartyAccountId).orElse("N/A"), "counterpartyType", Optional.ofNullable(((TransactionLeg)this.legs.get((int)0)).counterpartyType).orElse("N/A"));
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getRequestId() {
        return this.requestId;
    }

    @Generated
    public String getState() {
        return this.state;
    }

    @Generated
    public ZonedDateTime getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public ZonedDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    @Generated
    public ZonedDateTime getCompletedAt() {
        return this.completedAt;
    }

    @Generated
    public String getReference() {
        return this.reference;
    }

    @Generated
    public List<TransactionLeg> getLegs() {
        return this.legs;
    }
}

