/*
 * Decompiled with CFR 0.152.
 */
package alfio.model.transaction.webhook;

import alfio.model.transaction.TransactionWebhookPayload;
import alfio.model.transaction.provider.RevolutTransactionDescriptor;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.ZonedDateTime;

public class RevolutWebhookPayload
implements TransactionWebhookPayload {
    private final String type;
    private final ZonedDateTime timestamp;
    private final RevolutTransactionDescriptor payload;
    private String reservationId;

    @JsonCreator
    public RevolutWebhookPayload(@JsonProperty(value="event") String type, @JsonProperty(value="timestamp") ZonedDateTime timestamp, @JsonProperty(value="data") RevolutTransactionDescriptor payload) {
        this.type = type;
        this.timestamp = timestamp;
        this.payload = payload;
    }

    public RevolutTransactionDescriptor getPayload() {
        return this.payload;
    }

    public String getType() {
        return this.type;
    }

    public String getReservationId() {
        return this.reservationId;
    }

    public TransactionWebhookPayload.Status getStatus() {
        return this.payload.getState().equals("completed") ? TransactionWebhookPayload.Status.SUCCESS : TransactionWebhookPayload.Status.FAILURE;
    }

    public ZonedDateTime getTimestamp() {
        return this.timestamp;
    }

    public RevolutWebhookPayload attachToReservation(String reservationId) {
        this.reservationId = reservationId;
        return this;
    }
}

