/*
 * Decompiled with CFR 0.152.
 */
package alfio.model.user;

import alfio.model.user.RoleTarget;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import lombok.Generated;

/*
 * Exception performing whole class analysis ignored.
 */
public enum Role {
    ADMIN("ROLE_ADMIN", "Administrator", EnumSet.of(RoleTarget.ADMIN)),
    OWNER("ROLE_OWNER", "Organization owner", EnumSet.of(RoleTarget.USER)),
    SUPERVISOR("ROLE_SUPERVISOR", "Check-in supervisor", EnumSet.of(RoleTarget.USER, RoleTarget.API_KEY)),
    OPERATOR("ROLE_OPERATOR", "Check-in operator", EnumSet.of(RoleTarget.API_KEY)),
    SPONSOR("ROLE_SPONSOR", "Sponsor", EnumSet.of(RoleTarget.API_KEY)),
    API_CONSUMER("ROLE_API_CLIENT", "API Client", EnumSet.of(RoleTarget.API_KEY));

    private final String roleName;
    private final String description;
    private final Set<RoleTarget> target;

    private Role(String roleName, String description, Set<RoleTarget> target) {
        this.roleName = roleName;
        this.description = description;
        this.target = target;
    }

    public static Role fromRoleName(String roleName) {
        return Arrays.stream(Role.values()).filter(r -> r.getRoleName().equals(roleName)).findFirst().orElse(OPERATOR);
    }

    public String getRoleName() {
        return this.roleName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Set<RoleTarget> getTarget() {
        return this.target;
    }
}

