/*
 * Decompiled with CFR 0.152.
 */
package alfio.repository;

import alfio.model.AdditionalServiceItem;
import alfio.model.AdditionalServiceItemExport;
import alfio.model.BookedAdditionalService;
import ch.digitalfondue.npjt.AffectedRowCountAndKey;
import ch.digitalfondue.npjt.AutoGeneratedKey;
import ch.digitalfondue.npjt.Bind;
import ch.digitalfondue.npjt.Query;
import ch.digitalfondue.npjt.QueryRepository;
import ch.digitalfondue.npjt.QueryType;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.List;

@QueryRepository
public interface AdditionalServiceItemRepository {
    public static final String SELECT_BOOKED_ADDITIONAL_SERVICES = "select asd.value as as_name, ads.id as_id, count(ads.id) as qty from additional_service_item ai  join additional_service ads on additional_service_id_fk = ads.id  join additional_service_description asd on ads.id = asd.additional_service_id_fk  where ai.event_id_fk = :eventId and ai.status in ('ACQUIRED', 'CHECKED_IN', 'TO_BE_PAID')  and ads.service_type <> 'DONATION'  and ads.supplement_policy not in ('MANDATORY_ONE_FOR_TICKET', 'MANDATORY_PERCENTAGE_RESERVATION', 'MANDATORY_PERCENTAGE_FOR_TICKET')  and asd.locale = :language  and asd.type = 'TITLE'  and ai.tickets_reservation_uuid = :reservationId";
    public static final String UPDATE_STATUS = "update additional_service_item set status = :status where event_id_fk = :eventId and tickets_reservation_uuid = :reservationUuid";
    public static final String FIND_BY_RESERVATION_ID = "select * from additional_service_item where event_id_fk = :eventId and tickets_reservation_uuid = :reservationUuid";

    @Query(value="insert into additional_service_item (uuid, creation, tickets_reservation_uuid, additional_service_id_fk, status, event_id_fk, src_price_cts, final_price_cts, vat_cts, discount_cts, currency_code) values(:uuid, :creation, :ticketsReservationUuid, :additionalServiceId, :status, :eventId, :srcPriceCts, :finalPriceCts, :vatCts, :discountCts, :currencyCode)")
    @AutoGeneratedKey(value="id")
    public AffectedRowCountAndKey<Integer> insert(@Bind(value="uuid") String var1, @Bind(value="creation") ZonedDateTime var2, @Bind(value="ticketsReservationUuid") String var3, @Bind(value="additionalServiceId") int var4, @Bind(value="status") AdditionalServiceItem.AdditionalServiceItemStatus var5, @Bind(value="eventId") int var6, @Bind(value="srcPriceCts") Integer var7, @Bind(value="finalPriceCts") Integer var8, @Bind(value="vatCts") Integer var9, @Bind(value="discountCts") Integer var10, @Bind(value="currencyCode") String var11);

    @Query(value="select * from additional_service_item where event_id_fk = :eventId and tickets_reservation_uuid = :reservationUuid")
    public List<AdditionalServiceItem> findByReservationUuid(@Bind(value="eventId") int var1, @Bind(value="reservationUuid") String var2);

    @Query(value="select * from additional_service_item where event_id_fk = :eventId and tickets_reservation_uuid = :reservationUuid and ticket_id_fk = :ticketId")
    public List<AdditionalServiceItem> findByTicketId(@Bind(value="eventId") int var1, @Bind(value="reservationUuid") String var2, @Bind(value="ticketId") int var3);

    @Query(value="update additional_service_item set status = :status where event_id_fk = :eventId and tickets_reservation_uuid = :reservationUuid")
    public int updateItemsStatusWithReservationUUID(@Bind(value="eventId") int var1, @Bind(value="reservationUuid") String var2, @Bind(value="status") AdditionalServiceItem.AdditionalServiceItemStatus var3);

    @Query(value="update additional_service_item set status = :status where event_id_fk = :eventId and tickets_reservation_uuid = :reservationUuid and ticket_id_fk = :ticketId")
    public int updateItemsStatusWithTicketId(@Bind(value="eventId") int var1, @Bind(value="reservationUuid") String var2, @Bind(value="ticketId") int var3, @Bind(value="status") AdditionalServiceItem.AdditionalServiceItemStatus var4);

    @Query(value="select count(*) > 0 from additional_service_item  inner join additional_service on additional_service_id_fk = additional_service.id  where additional_service_item.event_id_fk = :eventId and service_type = 'SUPPLEMENT' and tickets_reservation_uuid = :reservationId and final_price_cts > 0")
    public boolean hasPaidSupplements(@Bind(value="eventId") int var1, @Bind(value="reservationId") String var2);

    @Query(value="select count(*) from additional_service_item where event_id_fk = :eventId and tickets_reservation_uuid = :reservationId")
    public int countByReservationUuid(@Bind(value="eventId") int var1, @Bind(value="reservationId") String var2);

    @Query(value="select asd.value as as_name, ads.id as_id, count(ads.id) as qty from additional_service_item ai  join additional_service ads on additional_service_id_fk = ads.id  join additional_service_description asd on ads.id = asd.additional_service_id_fk  where ai.event_id_fk = :eventId and ai.status in ('ACQUIRED', 'CHECKED_IN', 'TO_BE_PAID')  and ads.service_type <> 'DONATION'  and ads.supplement_policy not in ('MANDATORY_ONE_FOR_TICKET', 'MANDATORY_PERCENTAGE_RESERVATION', 'MANDATORY_PERCENTAGE_FOR_TICKET')  and asd.locale = :language  and asd.type = 'TITLE'  and ai.tickets_reservation_uuid = :reservationId  group by ads.id, asd.value")
    public List<BookedAdditionalService> getAdditionalServicesBookedForReservation(@Bind(value="reservationId") String var1, @Bind(value="language") String var2, @Bind(value="eventId") int var3);

    @Query(value="select asd.value as as_name, ads.id as_id, count(ads.id) as qty from additional_service_item ai  join additional_service ads on additional_service_id_fk = ads.id  join additional_service_description asd on ads.id = asd.additional_service_id_fk  where ai.event_id_fk = :eventId and ai.status in ('ACQUIRED', 'CHECKED_IN', 'TO_BE_PAID')  and ads.service_type <> 'DONATION'  and ads.supplement_policy not in ('MANDATORY_ONE_FOR_TICKET', 'MANDATORY_PERCENTAGE_RESERVATION', 'MANDATORY_PERCENTAGE_FOR_TICKET')  and asd.locale = :language  and asd.type = 'TITLE'  and ai.tickets_reservation_uuid = :reservationId  and ai.ticket_id_fk = :ticketId   group by ads.id, asd.value")
    public List<BookedAdditionalService> getAdditionalServicesBookedForTicket(@Bind(value="reservationId") String var1, @Bind(value="ticketId") int var2, @Bind(value="language") String var3, @Bind(value="eventId") int var4);

    @Query(value="select    ai.uuid ai_uuid, ai.creation ai_creation, ai.last_modified ai_last_modified, ai.final_price_cts ai_final_price_cts, ai.currency_code ai_currency_code, ai.vat_cts ai_vat_cts, ai.discount_cts ai_discount_cts,    tr.id tr_uuid, tr.first_name tr_first_name, tr.last_name tr_last_name, tr.email_address tr_email_address,    asv.service_type as_type, asd.value as_title, ai.status as ai_status  from additional_service_item ai    join additional_service asv on ai.additional_service_id_fk = asv.id    join tickets_reservation tr on ai.tickets_reservation_uuid = tr.id    join additional_service_description asd on ai.additional_service_id_fk = asd.additional_service_id_fk where ai.event_id_fk = :eventId  and asv.service_type = :additionalServiceType  and asd.type = 'TITLE'  and asd.locale = :locale   and ai.status in ('ACQUIRED', 'CHECKED_IN', 'TO_BE_PAID') ")
    public List<AdditionalServiceItemExport> getAdditionalServicesOfTypeForEvent(@Bind(value="eventId") int var1, @Bind(value="additionalServiceType") String var2, @Bind(value="locale") String var3);

    @Query(value="select count(*) from additional_service_item where additional_service_id_fk = :serviceId and status <> 'INVALIDATED'")
    public int countItemsForService(@Bind(value="serviceId") int var1);

    @Query(type=QueryType.TEMPLATE, value="insert into additional_service_item (uuid, creation, tickets_reservation_uuid, additional_service_id_fk, status, event_id_fk, src_price_cts, final_price_cts, vat_cts, discount_cts, currency_code) values(:uuid, now(), :ticketsReservationUuid, :additionalServiceId, :status, :eventId, :srcPriceCts, :finalPriceCts, :vatCts, :discountCts, :currencyCode)")
    public String batchInsert();

    @Query(type=QueryType.TEMPLATE, value="update additional_service_item set tickets_reservation_uuid = :ticketsReservationUuid, status = :status, src_price_cts = :srcPriceCts, final_price_cts = :finalPriceCts, vat_cts = :vatCts, discount_cts = :discountCts, currency_code = :currencyCode where id = :id and additional_service_id_fk = :additionalServiceId")
    public String batchUpdate();

    @Query(value="update additional_service_item set status = 'INVALIDATED' where id in (select id from additional_service_item where additional_service_id_fk = :serviceId and status = 'FREE' limit :count)")
    public int invalidateItems(@Bind(value="serviceId") int var1, @Bind(value="count") int var2);

    @Query(value="select id from additional_service_item where additional_service_id_fk = :serviceId and status = 'FREE' limit :count for update skip locked")
    public List<Integer> lockExistingItems(@Bind(value="serviceId") int var1, @Bind(value="count") int var2);

    @Query(type=QueryType.TEMPLATE, value="update additional_service_item set ticket_id_fk = :ticketId where id = :itemId and tickets_reservation_uuid = :reservationId and status = 'PENDING'")
    public String batchLinkToTicket();

    @Query(value="delete from additional_service_item asi using additional_service adds where adds.id = asi.additional_service_id_fk and asi.event_id_fk = :eventId and asi.tickets_reservation_uuid = :reservationId and adds.available_qty = -1")
    public int deleteAdditionalServiceItemsByReservationId(@Bind(value="eventId") int var1, @Bind(value="reservationId") String var2);

    @Query(value="delete from additional_service_item asi\n using additional_service adds\n where adds.id = asi.additional_service_id_fk and asi.event_id_fk = :eventId\n and asi.status = 'FREE'\n")
    public int deleteByAdditionalServiceId(@Bind(value="eventId") int var1, @Bind(value="additionalServiceId") int var2);

    @Query(value="update additional_service_item asi set ticket_id_fk = null, status = 'FREE', tickets_reservation_uuid = null from additional_service adds where adds.id = asi.additional_service_id_fk and asi.event_id_fk = :eventId and asi.tickets_reservation_uuid = :reservationId and adds.available_qty > 0")
    public int revertAdditionalServiceItemsByReservationId(@Bind(value="eventId") int var1, @Bind(value="reservationId") String var2);

    @Query(value="select count(*) from additional_service_item asi join ticket t on asi.ticket_id_fk = t.id and asi.event_id_fk = t.event_id where t.uuid = :ticketUUID and asi.id in (:additionalServiceIds)")
    public int countMatchingItemsForTicket(@Bind(value="ticketUUID") String var1, @Bind(value="additionalServiceIds") Collection<Integer> var2);
}

