/*
 * Decompiled with CFR 0.152.
 */
package alfio.repository;

import alfio.model.AdditionalService;
import alfio.model.AdditionalServiceItem;
import ch.digitalfondue.npjt.AffectedRowCountAndKey;
import ch.digitalfondue.npjt.AutoGeneratedKey;
import ch.digitalfondue.npjt.Bind;
import ch.digitalfondue.npjt.Query;
import ch.digitalfondue.npjt.QueryRepository;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;

@QueryRepository
public interface AdditionalServiceRepository {
    @Query(value="select * from additional_service_with_currency where event_id_fk = :eventId order by ordinal")
    public List<AdditionalService> loadAllForEvent(@Bind(value="eventId") int var1);

    public NamedParameterJdbcTemplate getJdbcTemplate();

    default public Map<Integer, Map<AdditionalServiceItem.AdditionalServiceItemStatus, Integer>> getCount(int eventId) {
        HashMap<Integer, Map<AdditionalServiceItem.AdditionalServiceItemStatus, Integer>> res = new HashMap<Integer, Map<AdditionalServiceItem.AdditionalServiceItemStatus, Integer>>();
        this.getJdbcTemplate().query("select count(*) as cnt, additional_service_id_fk, status from additional_service_item where event_id_fk = :eventId group by additional_service_id_fk, status", Collections.singletonMap("eventId", eventId), rse -> {
            int additionalServiceId = rse.getInt("additional_service_id_fk");
            res.putIfAbsent(additionalServiceId, new EnumMap(AdditionalServiceItem.AdditionalServiceItemStatus.class));
            Map statusCount = (Map)res.get(additionalServiceId);
            AdditionalServiceItem.AdditionalServiceItemStatus status = AdditionalServiceItem.AdditionalServiceItemStatus.valueOf((String)rse.getString("status"));
            statusCount.put(status, rse.getInt("cnt"));
        });
        return res;
    }

    @Query(value="select ordinal from additional_service_with_currency where id = :id and event_id_fk = :eventId")
    public Optional<Integer> getServiceOrdinal(@Bind(value="id") int var1, @Bind(value="eventId") int var2);

    @Query(value="update additional_service set ordinal = :ordinal where id = :id")
    public int updateOrdinal(@Bind(value="id") int var1, @Bind(value="ordinal") int var2);

    @Query(value="select * from additional_service_with_currency where id = :id and event_id_fk = :eventId")
    public AdditionalService getById(@Bind(value="id") int var1, @Bind(value="eventId") int var2);

    @Query(value="select * from additional_service_with_currency where id = :id and event_id_fk = :eventId")
    public Optional<AdditionalService> getOptionalById(@Bind(value="id") int var1, @Bind(value="eventId") int var2);

    @Query(value="delete from additional_service where id = :id and event_id_fk = :eventId")
    public int delete(@Bind(value="id") int var1, @Bind(value="eventId") int var2);

    @Query(value="insert into additional_service (event_id_fk, fix_price, ordinal, available_qty, max_qty_per_order, inception_ts, expiration_ts, vat, vat_type, price_cts, src_price_cts, service_type, supplement_policy, price_min_cts, price_max_cts) values(:eventId, :fixPrice, :ordinal, :availableQty, :maxQtyPerOrder, :inceptionTs, :expirationTs, :vat, :vatType, 0, :srcPriceCts, :type, :supplementPolicy, :minPriceCts, :maxPriceCts)")
    @AutoGeneratedKey(value="id")
    public AffectedRowCountAndKey<Integer> insert(@Bind(value="eventId") int var1, @Bind(value="srcPriceCts") int var2, @Bind(value="fixPrice") boolean var3, @Bind(value="ordinal") int var4, @Bind(value="availableQty") int var5, @Bind(value="maxQtyPerOrder") int var6, @Bind(value="inceptionTs") ZonedDateTime var7, @Bind(value="expirationTs") ZonedDateTime var8, @Bind(value="vat") BigDecimal var9, @Bind(value="vatType") AdditionalService.VatType var10, @Bind(value="type") AdditionalService.AdditionalServiceType var11, @Bind(value="supplementPolicy") AdditionalService.SupplementPolicy var12, @Bind(value="minPriceCts") Integer var13, @Bind(value="maxPriceCts") Integer var14);

    @Query(value="update additional_service set fix_price = :fixPrice, ordinal = :ordinal, available_qty = :availableQty,\n max_qty_per_order = :maxQtyPerOrder, inception_ts = :inceptionTs, expiration_ts = :expirationTs,\n vat = :vat, vat_type = :vatType, src_price_cts = :srcPriceCts, price_min_cts = :minPriceCts,\n price_max_cts = :maxPriceCts, supplement_policy = :policy where id = :id\n")
    public int update(@Bind(value="id") int var1, @Bind(value="fixPrice") boolean var2, @Bind(value="ordinal") int var3, @Bind(value="availableQty") int var4, @Bind(value="maxQtyPerOrder") int var5, @Bind(value="inceptionTs") ZonedDateTime var6, @Bind(value="expirationTs") ZonedDateTime var7, @Bind(value="vat") BigDecimal var8, @Bind(value="vatType") AdditionalService.VatType var9, @Bind(value="srcPriceCts") int var10, @Bind(value="policy") String var11, @Bind(value="minPriceCts") Integer var12, @Bind(value="maxPriceCts") Integer var13);

    @Query(value="select * from additional_service_with_currency where event_id_fk = :eventId and supplement_policy = :supplementPolicy order by ordinal")
    public List<AdditionalService> findAllInEventWithPolicy(@Bind(value="eventId") int var1, @Bind(value="supplementPolicy") AdditionalService.SupplementPolicy var2);

    @Query(value="select * from additional_service_with_currency where event_id_fk = :eventId and id in (select additional_service_id_fk from additional_service_item where tickets_reservation_uuid = :reservationId) order by ordinal")
    public List<AdditionalService> loadAllForReservation(@Bind(value="reservationId") String var1, @Bind(value="eventId") int var2);

    @Query(value="select count(*) from additional_service where event_id_fk = :eventId and id in(:ids)")
    public Integer countAdditionalServicesBelongingToEvent(@Bind(value="eventId") int var1, @Bind(value="ids") Collection<Integer> var2);

    default public Map<Integer, AdditionalService.AdditionalServiceType> getTypeByIds(Collection<Integer> additionalServiceIds) {
        HashMap<Integer, AdditionalService.AdditionalServiceType> res = new HashMap<Integer, AdditionalService.AdditionalServiceType>();
        this.getJdbcTemplate().query("select id, service_type from additional_service where id in (:additionalServiceIds)", Map.of("additionalServiceIds", additionalServiceIds), row -> res.put(row.getInt("id"), AdditionalService.AdditionalServiceType.valueOf((String)row.getString("service_type"))));
        return res;
    }

    @Query(value="select exists(select id from additional_service where event_id_fk = :eventId and id = :id)")
    public boolean additionalServiceExistsForEvent(@Bind(value="id") int var1, @Bind(value="eventId") int var2);
}

