/*
 * Decompiled with CFR 0.152.
 */
package alfio.repository;

import alfio.model.AdditionalServiceText;
import ch.digitalfondue.npjt.Bind;
import ch.digitalfondue.npjt.Query;
import ch.digitalfondue.npjt.QueryRepository;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@QueryRepository
public interface AdditionalServiceTextRepository {
    @Query(value="select id, additional_service_id_fk, locale, type, value from additional_service_description where additional_service_id_fk = :additionalServiceId")
    public List<AdditionalServiceText> findAllByAdditionalServiceId(@Bind(value="additionalServiceId") int var1);

    @Query(value="delete from additional_service_description where additional_service_id_fk = :additionalServiceId")
    public int deleteAdditionalServiceTexts(@Bind(value="additionalServiceId") int var1);

    @Query(value="select id, additional_service_id_fk, locale, type, value from additional_service_description where additional_service_id_fk = :additionalServiceId and type = :type")
    public List<AdditionalServiceText> findAllByAdditionalServiceIdAndType(@Bind(value="additionalServiceId") int var1, @Bind(value="type") AdditionalServiceText.TextType var2);

    @Query(value="select id, additional_service_id_fk, locale, type, value from additional_service_description where additional_service_id_fk = :additionalServiceId and locale = :locale and type = :type")
    public Optional<AdditionalServiceText> findByLocaleAndType(@Bind(value="additionalServiceId") int var1, @Bind(value="locale") String var2, @Bind(value="type") AdditionalServiceText.TextType var3);

    @Query(value="insert into additional_service_description(additional_service_id_fk, locale, type, value) values(:additionalServiceId, :locale, :type, :value)")
    public int insert(@Bind(value="additionalServiceId") int var1, @Bind(value="locale") String var2, @Bind(value="type") AdditionalServiceText.TextType var3, @Bind(value="value") String var4);

    @Query(value="update additional_service_description set locale = :locale, type = :type, value = :value where id = :id and additional_service_id_fk = :additionalServiceId")
    public int update(@Bind(value="id") int var1, @Bind(value="locale") String var2, @Bind(value="type") AdditionalServiceText.TextType var3, @Bind(value="value") String var4, @Bind(value="additionalServiceId") int var5);

    @Query(value="select id, additional_service_id_fk, locale, type, value from additional_service_description where additional_service_id_fk in (:additionalServiceIds)")
    public List<AdditionalServiceText> findAllByAdditionalServiceIds(@Bind(value="additionalServiceIds") Collection<Integer> var1);

    default public Map<Integer, Map<AdditionalServiceText.TextType, Map<String, String>>> getDescriptionsByAdditionalServiceIds(Collection<Integer> additionalServiceIds) {
        if (additionalServiceIds.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Integer, Map<AdditionalServiceText.TextType, Map<String, String>>> res = new HashMap<Integer, Map<AdditionalServiceText.TextType, Map<String, String>>>();
        this.findAllByAdditionalServiceIds(additionalServiceIds).forEach(t -> {
            Integer id = t.getAdditionalServiceId();
            if (!res.containsKey(id)) {
                res.put(id, new EnumMap(AdditionalServiceText.TextType.class));
            }
            if (!((Map)res.get(id)).containsKey(t.getType())) {
                ((Map)res.get(id)).put(t.getType(), new HashMap());
            }
            ((Map)((Map)res.get(id)).get(t.getType())).put(t.getLocale(), t.getValue());
        });
        return res;
    }

    default public AdditionalServiceText findBestMatchByLocaleAndType(int additionalServiceId, String locale, AdditionalServiceText.TextType type) {
        return this.findByLocaleAndType(additionalServiceId, locale, type).orElseGet(() -> {
            List texts = this.findAllByAdditionalServiceIdAndType(additionalServiceId, type);
            return !texts.isEmpty() ? (AdditionalServiceText)texts.get(0) : new AdditionalServiceText(-1, Integer.valueOf(additionalServiceId), locale, type, "N/A");
        });
    }
}

