/*
 * Decompiled with CFR 0.152.
 */
package alfio.repository;

import alfio.model.AdminReservationRequest;
import alfio.model.AdminReservationRequestStats;
import alfio.model.EventAndOrganizationId;
import alfio.model.modification.AdminReservationModification;
import alfio.util.Json;
import ch.digitalfondue.npjt.Bind;
import ch.digitalfondue.npjt.Query;
import ch.digitalfondue.npjt.QueryRepository;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

@QueryRepository
public interface AdminReservationRequestRepository {
    default public void insertRequest(String requestId, long userId, EventAndOrganizationId event, Stream<AdminReservationModification> requestModifications) {
        MapSqlParameterSource[] requests = (MapSqlParameterSource[])requestModifications.map(res -> new MapSqlParameterSource("userId", (Object)userId).addValue("requestId", (Object)requestId).addValue("requestType", (Object)AdminReservationRequest.RequestType.IMPORT.name()).addValue("status", (Object)AdminReservationRequest.Status.PENDING.name()).addValue("eventId", (Object)event.getId()).addValue("body", (Object)Json.toJson((Object)res))).toArray(MapSqlParameterSource[]::new);
        this.getNamedParameterJdbcTemplate().batchUpdate("insert into admin_reservation_request(user_id, request_id, event_id, request_type, status, body) values(:userId, :requestId, :eventId, :requestType, :status, :body)", (SqlParameterSource[])requests);
    }

    @Query(value="select id from admin_reservation_request where status = 'PENDING' order by request_id limit :limit for update skip locked")
    public List<Long> findPendingForUpdate(@Bind(value="limit") int var1);

    @Query(value="select count(*) from admin_reservation_request where status = 'PENDING'")
    public Integer countPending();

    @Query(value="select * from admin_reservation_request where id = :id")
    public AdminReservationRequest fetchCompleteById(@Bind(value="id") long var1);

    default public void updateStatus(List<MapSqlParameterSource> params) {
        this.getNamedParameterJdbcTemplate().batchUpdate("update admin_reservation_request set status = :status, reservation_id = :reservationId, failure_code = :failureCode where id = :id", (SqlParameterSource[])params.toArray(new MapSqlParameterSource[0]));
    }

    @Query(value="select * from admin_reservation_request_stats where request_id = :requestId and event_id = :eventId")
    public Optional<AdminReservationRequestStats> findStatsByRequestIdAndEventId(@Bind(value="requestId") String var1, @Bind(value="eventId") long var2);

    public NamedParameterJdbcTemplate getNamedParameterJdbcTemplate();
}

