/*
 * Decompiled with CFR 0.152.
 */
package alfio.repository;

import alfio.model.Audit;
import alfio.model.EventAndOrganizationId;
import alfio.model.PurchaseContext;
import alfio.model.support.JSONData;
import alfio.util.Json;
import ch.digitalfondue.npjt.Bind;
import ch.digitalfondue.npjt.Query;
import ch.digitalfondue.npjt.QueryRepository;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

@QueryRepository
public interface AuditingRepository {
    @Query(value="insert into auditing(reservation_id, user_id, event_id, event_type, event_time, entity_type, entity_id, modifications)  values (:reservationId, :userId, :eventId, :eventType, :eventTime, :entityType, :entityId, :modifications)")
    public int insert(@Bind(value="reservationId") String var1, @Bind(value="userId") Integer var2, @Bind(value="eventId") Integer var3, @Bind(value="eventType") Audit.EventType var4, @Bind(value="eventTime") Date var5, @Bind(value="entityType") Audit.EntityType var6, @Bind(value="entityId") String var7, @Bind(value="modifications") String var8);

    default public int insert(String reservationId, Integer userId, Integer eventId, Audit.EventType eventType, Date eventTime, Audit.EntityType entityType, String entityId) {
        return this.insert(reservationId, userId, eventId, eventType, eventTime, entityType, entityId, (String)null);
    }

    default public int insert(String reservationId, Integer userId, Integer eventId, Audit.EventType eventType, Date eventTime, Audit.EntityType entityType, String entityId, List<Map<String, Object>> modifications) {
        String modificationJson = modifications == null ? null : Json.toJson(modifications);
        return this.insert(reservationId, userId, eventId, eventType, eventTime, entityType, entityId, modificationJson);
    }

    default public int insert(String reservationId, Integer userId, PurchaseContext p, Audit.EventType eventType, Date eventTime, Audit.EntityType entityType, String entityId) {
        Integer eventId = p.event().map(EventAndOrganizationId::getId).orElse(null);
        return this.insert(reservationId, userId, eventId, eventType, eventTime, entityType, entityId, (String)null);
    }

    default public int insert(String reservationId, Integer userId, PurchaseContext p, Audit.EventType eventType, Date eventTime, Audit.EntityType entityType, String entityId, List<Map<String, Object>> modifications) {
        Integer eventId = p.event().map(EventAndOrganizationId::getId).orElse(null);
        return this.insert(reservationId, userId, eventId, eventType, eventTime, entityType, entityId, modifications);
    }

    @Query(value="select * from auditing_user where reservation_id = :reservationId order by event_time asc")
    public List<Audit> findAllForReservation(@Bind(value="reservationId") String var1);

    @Query(value="select count(*) from auditing_user where reservation_id = :reservationId and event_type = :eventType")
    public Integer countAuditsOfTypeForReservation(@Bind(value="reservationId") String var1, @Bind(value="eventType") Audit.EventType var2);

    @Query(value="select count(*) from auditing_user where reservation_id = :reservationId and entity_id = :ticketId::text and event_type = :eventType")
    public Integer countAuditsOfTypeForTicket(@Bind(value="reservationId") String var1, @Bind(value="ticketId") int var2, @Bind(value="eventType") Audit.EventType var3);

    @Query(value="select count(*) from auditing_user where reservation_id = :reservationId and event_type in (:eventTypes) and date_trunc('day', :referenceDate::timestamp) = date_trunc('day', event_time)")
    public Integer countAuditsOfTypesInTheSameDay(@Bind(value="reservationId") String var1, @Bind(value="eventTypes") Collection<String> var2, @Bind(value="referenceDate") ZonedDateTime var3);

    @Query(value="insert into auditing(reservation_id, user_id, event_id, event_type, event_time, entity_type, entity_id, modifications)  select tickets_reservation_id, null, event_id, 'UPDATE_TICKET_CATEGORY', current_timestamp, 'TICKET', concat('', id), null from ticket where category_id = :ticketCategoryId and tickets_reservation_id is not null")
    public int insertUpdateTicketInCategoryId(@Bind(value="ticketCategoryId") int var1);

    @Query(value="insert into auditing(reservation_id, user_id, event_id, event_type, event_time, entity_type, entity_id, modifications)  select tickets_reservation_id, null, event_id, 'TAG_TICKET', current_timestamp, 'TICKET', concat('', id), :modifications from ticket where id in (:ticketIds)")
    public int registerTicketTag(@Bind(value="ticketIds") List<Integer> var1, @Bind(value="modifications") @JSONData List<Map<String, Object>> var2);

    @Query(value="insert into auditing(reservation_id, user_id, event_id, event_type, event_time, entity_type, entity_id, modifications)  select tickets_reservation_id, null, event_id, 'UNTAG_TICKET', current_timestamp, 'TICKET', concat('', id), :modifications from ticket where id in (:ticketIds)")
    public int registerTicketUntag(@Bind(value="ticketIds") List<Integer> var1, @Bind(value="modifications") @JSONData List<Map<String, Object>> var2);
}

