/*
 * Decompiled with CFR 0.152.
 */
package alfio.repository;

import alfio.model.BillingDocument;
import ch.digitalfondue.npjt.AffectedRowCountAndKey;
import ch.digitalfondue.npjt.AutoGeneratedKey;
import ch.digitalfondue.npjt.Bind;
import ch.digitalfondue.npjt.Query;
import ch.digitalfondue.npjt.QueryRepository;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Optional;

@QueryRepository
public interface BillingDocumentRepository {
    public static final String LOAD_ALL_BY_EVENT_ID = "select a.* from billing_document a inner join (select max(generation_ts) as time,reservation_id_fk from billing_document where status = 'VALID' and type = 'INVOICE' and event_id_fk = :eventId group by reservation_id_fk) b on a.generation_ts = b.time and a.reservation_id_fk = b.reservation_id_fk union select * from billing_document where status = 'VALID' and event_id_fk = :eventId and type <> 'INVOICE'";

    @Query(value="select * from billing_document where reservation_id_fk = :reservationId and status = 'VALID' order by generation_ts desc limit 1")
    public Optional<BillingDocument> findLatestByReservationId(@Bind(value="reservationId") String var1);

    @Query(value="select * from billing_document where reservation_id_fk = :reservationId and id = :id")
    public Optional<BillingDocument> findByIdAndReservationId(@Bind(value="id") long var1, @Bind(value="reservationId") String var3);

    @Query(value="select * from billing_document where id = :id")
    public Optional<BillingDocument> findById(@Bind(value="id") long var1);

    @Query(value="update billing_document set status = :status where reservation_id_fk = :reservationId and id = :id")
    public int updateStatus(@Bind(value="id") long var1, @Bind(value="status") BillingDocument.Status var3, @Bind(value="reservationId") String var4);

    @Query(value="update billing_document set status = 'NOT_VALID' where type = :type and id < :currentId and reservation_id_fk = :reservationId")
    public int invalidateAllPreviousDocumentsOfType(@Bind(value="type") BillingDocument.Type var1, @Bind(value="currentId") Long var2, @Bind(value="reservationId") String var3);

    @Query(value="select * from billing_document where reservation_id_fk = :reservationId order by generation_ts desc, id desc")
    public List<BillingDocument> findAllByReservationId(@Bind(value="reservationId") String var1);

    @Query(value="insert into billing_document(event_id_fk, number, reservation_id_fk, type, model, generation_ts, status, organization_id_fk) values(:eventId, :number, :reservationId, :type, :model, :generationTimestamp, 'VALID', :organizationId)")
    @AutoGeneratedKey(value="id")
    public AffectedRowCountAndKey<Long> insert(@Bind(value="eventId") Integer var1, @Bind(value="reservationId") String var2, @Bind(value="number") String var3, @Bind(value="type") BillingDocument.Type var4, @Bind(value="model") String var5, @Bind(value="generationTimestamp") ZonedDateTime var6, @Bind(value="organizationId") int var7);

    @Query(value="select * from billing_document a inner join (select max(generation_ts) as time,reservation_id_fk from billing_document where status = 'VALID' and type = :type and event_id_fk = :eventId group by reservation_id_fk) b on a.generation_ts = b.time and a.reservation_id_fk = b.reservation_id_fk")
    public List<BillingDocument> findAllOfTypeForEvent(@Bind(value="type") BillingDocument.Type var1, @Bind(value="eventId") int var2);

    @Query(value="select a.* from billing_document a inner join (select max(generation_ts) as time,reservation_id_fk from billing_document where status = 'VALID' and type = 'INVOICE' and event_id_fk = :eventId group by reservation_id_fk) b on a.generation_ts = b.time and a.reservation_id_fk = b.reservation_id_fk union select * from billing_document where status = 'VALID' and event_id_fk = :eventId and type <> 'INVOICE' order by reservation_id_fk, generation_ts")
    public List<BillingDocument> findAllForEvent(@Bind(value="eventId") int var1);

    @Query(value="select count(*) from (select a.* from billing_document a inner join (select max(generation_ts) as time,reservation_id_fk from billing_document where status = 'VALID' and type = 'INVOICE' and event_id_fk = :eventId group by reservation_id_fk) b on a.generation_ts = b.time and a.reservation_id_fk = b.reservation_id_fk union select * from billing_document where status = 'VALID' and event_id_fk = :eventId and type <> 'INVOICE') docs")
    public Integer countAllForEvent(@Bind(value="eventId") int var1);

    @Query(value="delete from billing_document where reservation_id_fk = :reservationId")
    public int deleteForReservation(@Bind(value="reservationId") String var1);

    @Query(value="delete from billing_document where reservation_id_fk in (:reservationIds) and event_id_fk = :eventId")
    public int deleteForReservations(@Bind(value="reservationIds") List<String> var1, @Bind(value="eventId") int var2);

    @Query(value="select id from billing_document a inner join(select max(generation_ts) as time,reservation_id_fk from billing_document where status = 'VALID' and type = 'INVOICE' and event_id_fk = :eventId group by reservation_id_fk) b  on a.generation_ts = b.time and a.reservation_id_fk = b.reservation_id_fk  where a.event_id_fk = :eventId and a.type = 'INVOICE' and b.time between :start and :end")
    public List<Integer> findMatchingInvoiceIds(@Bind(value="eventId") int var1, @Bind(value="start") ZonedDateTime var2, @Bind(value="end") ZonedDateTime var3);

    @Query(value="select min(generation_ts) from billing_document where event_id_fk = :eventId and type = 'INVOICE' and status = 'VALID'")
    public Optional<ZonedDateTime> findFirstInvoiceGenerationDate(@Bind(value="eventId") int var1);

    @Query(value="select exists(select id from billing_document where id = :id and reservation_id_fk = :reservationId)")
    public Boolean checkBillingDocumentExistsForReservation(@Bind(value="id") long var1, @Bind(value="reservationId") String var3);

    @Query(value="select id from billing_document where id in (:documentIds) and event_id_fk = :eventId ")
    public List<Long> findByIdsAndEvent(@Bind(value="documentIds") List<Long> var1, @Bind(value="eventId") int var2);
}

