/*
 * Decompiled with CFR 0.152.
 */
package alfio.repository;

import alfio.model.EmailMessage;
import alfio.model.Event;
import alfio.model.LightweightMailMessage;
import alfio.model.PurchaseContext;
import alfio.model.subscription.SubscriptionDescriptor;
import ch.digitalfondue.npjt.Bind;
import ch.digitalfondue.npjt.Query;
import ch.digitalfondue.npjt.QueryRepository;
import ch.digitalfondue.npjt.QueryType;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Optional;
import java.util.UUID;

@QueryRepository
public interface EmailMessageRepository {
    public static final String LIGHTWEIGHT_FIELDS = "id, event_id, subscription_descriptor_id_fk, status, recipient, subject, message, checksum, request_ts, sent_ts, attempts, email_cc, organization_id_fk ";
    public static final String FIND_MAILS_BY_EVENT = "select id, event_id, subscription_descriptor_id_fk, status, recipient, subject, message, checksum, request_ts, sent_ts, attempts, email_cc, organization_id_fk  from email_message where event_id = :eventId and  (:search is null or (recipient like :search or subject like :search or message like :search)) order by sent_ts desc, id ";
    public static final String FIND_MAILS_BY_SUBSCRIPTION = "select id, event_id, subscription_descriptor_id_fk, status, recipient, subject, message, checksum, request_ts, sent_ts, attempts, email_cc, organization_id_fk  from email_message where subscription_descriptor_id_fk = :subscriptionId and  (:search is null or (recipient like :search or subject like :search or message like :search)) order by sent_ts desc, id ";

    @Query(value="select id from email_message where event_id = :eventId and checksum = :checksum limit 1")
    public Optional<Integer> findIdByEventIdAndChecksum(@Bind(value="eventId") int var1, @Bind(value="checksum") String var2);

    @Query(value="select id from email_message where subscription_descriptor_id_fk = :subscriptionDescriptorId and checksum = :checksum limit 1")
    public Optional<Integer> findIdBySubscriptionDescriptorAndChecksum(@Bind(value="subscriptionDescriptorId") UUID var1, @Bind(value="checksum") String var2);

    default public Optional<Integer> findIdByPurchaseContextAndChecksum(PurchaseContext purchaseContext, String checksum) {
        if (purchaseContext.ofType(PurchaseContext.PurchaseContextType.event)) {
            return this.findIdByEventIdAndChecksum(((Event)purchaseContext).getId(), checksum);
        }
        return this.findIdBySubscriptionDescriptorAndChecksum(((SubscriptionDescriptor)purchaseContext).getId(), checksum);
    }

    @Query(value="insert into email_message (event_id, organization_id_fk, subscription_descriptor_id_fk, reservation_id, status, recipient, subject, message, html_message, attachments, checksum, request_ts, email_cc) values(:eventId, :organizationId, :subscriptionDescriptorId, :reservationId, 'WAITING', :recipient, :subject, :message, :htmlMessage, :attachments, :checksum, :timestamp, :emailCC)")
    public int insert(@Bind(value="eventId") Integer var1, @Bind(value="subscriptionDescriptorId") UUID var2, @Bind(value="reservationId") String var3, @Bind(value="recipient") String var4, @Bind(value="emailCC") String var5, @Bind(value="subject") String var6, @Bind(value="message") String var7, @Bind(value="htmlMessage") String var8, @Bind(value="attachments") String var9, @Bind(value="checksum") String var10, @Bind(value="timestamp") ZonedDateTime var11, @Bind(value="organizationId") int var12);

    @Query(value="update email_message set status = :status where id = :id and checksum = :checksum and status in (:expectedStatuses)")
    public int updateStatus(@Bind(value="id") int var1, @Bind(value="checksum") String var2, @Bind(value="status") String var3, @Bind(value="expectedStatuses") List<String> var4);

    @Query(value="update email_message set status = 'WAITING', html_message = :htmlMessage where id = :messageId")
    public int updateStatusToWaitingWithHtml(@Bind(value="messageId") int var1, @Bind(value="htmlMessage") String var2);

    @Query(value="update email_message set status = :status, attempts = :attempts where id = :messageId and status in (:expectedStatuses) ")
    public int updateStatusAndAttempts(@Bind(value="messageId") int var1, @Bind(value="status") String var2, @Bind(value="attempts") int var3, @Bind(value="expectedStatuses") List<String> var4);

    @Query(value="update email_message set status = :status, attempts = :attempts, request_ts = :nextDate where id = :messageId and status in (:expectedStatuses) ")
    public int updateStatusAndAttempts(@Bind(value="messageId") int var1, @Bind(value="status") String var2, @Bind(value="nextDate") ZonedDateTime var3, @Bind(value="attempts") int var4, @Bind(value="expectedStatuses") List<String> var5);

    @Query(type=QueryType.SELECT, value="select * from email_message where ( (event_id is not null and event_id in (select id from event where end_ts > now())) or  (subscription_descriptor_id_fk is not null and subscription_descriptor_id_fk in (select id from subscription_descriptor where validity_to is null or validity_to > now())) ) and (status = 'WAITING' or status = 'RETRY') limit 100 for update skip locked")
    public List<EmailMessage> loadAllWaitingForProcessing();

    @Query(value="update email_message set status = 'SENT', sent_ts = :sentTimestamp, html_message = null where id = :id and checksum = :checksum and status in (:expectedStatuses)")
    public int updateStatusToSent(@Bind(value="id") int var1, @Bind(value="checksum") String var2, @Bind(value="sentTimestamp") ZonedDateTime var3, @Bind(value="expectedStatuses") List<String> var4);

    @Query(value="select * from (select id, event_id, subscription_descriptor_id_fk, status, recipient, subject, message, checksum, request_ts, sent_ts, attempts, email_cc, organization_id_fk  from email_message where event_id = :eventId and  (:search is null or (recipient like :search or subject like :search or message like :search)) order by sent_ts desc, id  limit :pageSize offset :page) as d_tbl")
    public List<LightweightMailMessage> findByEventId(@Bind(value="eventId") int var1, @Bind(value="page") int var2, @Bind(value="pageSize") int var3, @Bind(value="search") String var4);

    @Query(value="select id, event_id, status, recipient, subject, message, checksum, request_ts, sent_ts, attempts, email_cc, subscription_descriptor_id_fk, organization_id_fk from email_message where event_id = :eventId and reservation_id = :reservationId order by sent_ts desc, id")
    public List<LightweightMailMessage> findByEventIdAndReservationId(@Bind(value="eventId") int var1, @Bind(value="reservationId") String var2);

    @Query(value="select * from (select id, event_id, subscription_descriptor_id_fk, status, recipient, subject, message, checksum, request_ts, sent_ts, attempts, email_cc, organization_id_fk  from email_message where subscription_descriptor_id_fk = :subscriptionId and  (:search is null or (recipient like :search or subject like :search or message like :search)) order by sent_ts desc, id  limit :pageSize offset :page) as d_tbl")
    public List<LightweightMailMessage> findBySubscriptionDescriptorId(@Bind(value="subscriptionId") UUID var1, @Bind(value="page") int var2, @Bind(value="pageSize") int var3, @Bind(value="search") String var4);

    @Query(value="select id, event_id, status, recipient, subject, message, checksum, request_ts, sent_ts, attempts, email_cc, subscription_descriptor_id_fk, organization_id_fk from email_message where subscription_descriptor_id_fk = :subscriptionDescriptorId and reservation_id = :reservationId order by sent_ts desc, id")
    public List<LightweightMailMessage> findBySubscriptionDescriptorAndReservationId(@Bind(value="subscriptionDescriptorId") UUID var1, @Bind(value="reservationId") String var2);

    default public List<LightweightMailMessage> findByPurchaseContextAndReservationId(PurchaseContext purchaseContext, String reservationId) {
        if (purchaseContext.ofType(PurchaseContext.PurchaseContextType.event)) {
            return this.findByEventIdAndReservationId(((Event)purchaseContext).getId(), reservationId);
        }
        return this.findBySubscriptionDescriptorAndReservationId(((SubscriptionDescriptor)purchaseContext).getId(), reservationId);
    }

    @Query(value="select count(*) from (select id, event_id, subscription_descriptor_id_fk, status, recipient, subject, message, checksum, request_ts, sent_ts, attempts, email_cc, organization_id_fk  from email_message where event_id = :eventId and  (:search is null or (recipient like :search or subject like :search or message like :search)) order by sent_ts desc, id ) as d_tbl")
    public Integer countFindByEventId(@Bind(value="eventId") int var1, @Bind(value="search") String var2);

    @Query(value="select count(*) from (select id, event_id, subscription_descriptor_id_fk, status, recipient, subject, message, checksum, request_ts, sent_ts, attempts, email_cc, organization_id_fk  from email_message where subscription_descriptor_id_fk = :subscriptionId and  (:search is null or (recipient like :search or subject like :search or message like :search)) order by sent_ts desc, id ) as d_tbl")
    public Integer countFindBySubscriptionDescriptorId(@Bind(value="subscriptionId") UUID var1, @Bind(value="search") String var2);

    @Query(value="select * from email_message where id = :id")
    public EmailMessage findById(@Bind(value="id") int var1);

    @Query(value="select id, event_id, subscription_descriptor_id_fk, status, recipient, subject, message, checksum, request_ts, sent_ts, attempts, email_cc, organization_id_fk  from email_message where id = :messageId and event_id = :eventId")
    public Optional<LightweightMailMessage> findByEventIdAndMessageId(@Bind(value="eventId") int var1, @Bind(value="messageId") int var2);

    @Query(value="select id, event_id, subscription_descriptor_id_fk, status, recipient, subject, message, checksum, request_ts, sent_ts, attempts, email_cc, organization_id_fk  from email_message where id = :messageId and subscription_descriptor_id_fk = :subscriptionId")
    public Optional<LightweightMailMessage> findBySubscriptionDescriptorIdAndMessageId(@Bind(value="subscriptionId") UUID var1, @Bind(value="messageId") int var2);

    @Query(value="update email_message set status = 'RETRY', attempts = coalesce(attempts, 0) +1 where status = 'IN_PROCESS' and request_ts < :date")
    public int setToRetryOldInProcess(@Bind(value="date") ZonedDateTime var1);
}

