/*
 * Decompiled with CFR 0.152.
 */
package alfio.repository;

import ch.digitalfondue.npjt.Bind;
import ch.digitalfondue.npjt.Query;
import ch.digitalfondue.npjt.QueryRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@QueryRepository
public interface EventDeleterRepository {
    public static final Logger LOGGER = LoggerFactory.getLogger(EventDeleterRepository.class);

    @Query(value="delete from waiting_queue where event_id = :eventId")
    public int deleteWaitingQueue(@Bind(value="eventId") int var1);

    @Query(value="delete from configuration_event where event_id_fk = :eventId")
    public int deleteConfigurationEvent(@Bind(value="eventId") int var1);

    @Query(value="delete from configuration_purchase_context where event_id_fk = :eventId")
    public int deleteConfigurationPurchaseContext(@Bind(value="eventId") int var1);

    @Query(value="delete from configuration_ticket_category where event_id_fk = :eventId")
    public int deleteConfigurationTicketCategory(@Bind(value="eventId") int var1);

    @Query(value="delete from email_message where event_id = :eventId")
    public int deleteEmailMessage(@Bind(value="eventId") int var1);

    @Query(value="delete from purchase_context_field_value fv using purchase_context_field_configuration fc where fv.field_configuration_id_fk = fc.id and fc.event_id_fk = :eventId")
    public int deleteFieldValues(@Bind(value="eventId") int var1);

    @Query(value="delete from purchase_context_field_description d using purchase_context_field_configuration c where d.field_configuration_id_fk = c.id and c.event_id_fk = :eventId")
    public int deleteFieldDescription(@Bind(value="eventId") int var1);

    @Query(value="delete from additional_service_description where additional_service_id_fk in (select id from additional_service where event_id_fk = :eventId)")
    public int deleteAdditionalServiceDescriptions(@Bind(value="eventId") int var1);

    @Query(value="delete from additional_service_item where event_id_fk = :eventId")
    public int deleteAdditionalServiceItems(@Bind(value="eventId") int var1);

    @Query(value="delete from additional_service where event_id_fk = :eventId")
    public int deleteAdditionalServices(@Bind(value="eventId") int var1);

    @Query(value="delete from purchase_context_field_configuration where event_id_fk = :eventId")
    public int deleteFieldConfigurations(@Bind(value="eventId") int var1);

    @Query(value="delete from event_migration where event_id = :eventId")
    public int deleteEventMigration(@Bind(value="eventId") int var1);

    @Query(value="delete from sponsor_scan where event_id = :eventId")
    public int deleteSponsorScan(@Bind(value="eventId") int var1);

    @Query(value="delete from ticket where event_id = :eventId")
    public int deleteTicket(@Bind(value="eventId") int var1);

    @Query(value="delete from tickets_reservation where event_id_fk = :eventId")
    public int deleteReservation(@Bind(value="eventId") int var1);

    @Query(value="delete from special_price where ticket_category_id in (select id from ticket_category where event_id = :eventId)")
    public int deleteSpecialPrice(@Bind(value="eventId") int var1);

    @Query(value="delete from promo_code where event_id_fk = :eventId")
    public int deletePromoCode(@Bind(value="eventId") int var1);

    @Query(value="delete from ticket_category_text where ticket_category_id_fk in (select id from ticket_category where event_id = :eventId)")
    public int deleteTicketCategoryText(@Bind(value="eventId") int var1);

    @Query(value="delete from ticket_category where event_id = :eventId")
    public int deleteTicketCategory(@Bind(value="eventId") int var1);

    @Query(value="delete from event_description_text where event_id_fk  = :eventId")
    public int deleteEventDescription(@Bind(value="eventId") int var1);

    @Query(value="delete from event where id = :eventId")
    public int deleteEvent(@Bind(value="eventId") int var1);

    @Query(value="delete from resource_event where event_id_fk = :eventId")
    public int deleteResources(@Bind(value="eventId") int var1);

    @Query(value="delete from scan_audit where event_id_fk = :eventId")
    public int deleteScanAudit(@Bind(value="eventId") int var1);

    @Query(value="delete from b_transaction where reservation_id in (select id from tickets_reservation where event_id_fk = :eventId)")
    public int deleteTransactions(@Bind(value="eventId") int var1);

    @Query(value="delete from group_link where event_id_fk = :eventId")
    public int deleteGroupLinks(@Bind(value="eventId") int var1);

    @Query(value="delete from whitelisted_ticket where group_link_id_fk in(select id from group_link where event_id_fk = :eventId)")
    public int deleteWhitelistedTickets(@Bind(value="eventId") int var1);

    @Query(value="delete from billing_document where event_id_fk = :eventId")
    public int deleteBillingDocuments(@Bind(value="eventId") int var1);

    @Query(value="delete from poll where event_id_fk = :eventId")
    public int deletePolls(@Bind(value="eventId") int var1);

    @Query(value="delete from subscription_event where event_id_fk = :eventId")
    public int deleteSubscriptionLinks(@Bind(value="eventId") int var1);

    @Deprecated
    @Query(value="delete from ticket_field_value where ticket_field_configuration_id_fk in (select id from ticket_field_configuration where event_id_fk = :eventId)")
    public int deleteLegacyTicketFieldValue(@Bind(value="eventId") int var1);

    @Deprecated
    @Query(value="delete from ticket_field_description where ticket_field_configuration_id_fk in (select id from ticket_field_configuration where event_id_fk = :eventId)")
    public int deleteLegacyTicketFieldDescription(@Bind(value="eventId") int var1);

    @Deprecated
    @Query(value="delete from ticket_field_configuration where event_id_fk= :eventId")
    public int deleteLegacyTicketFieldConfiguration(@Bind(value="eventId") int var1);

    default public void deleteAllForEvent(int eventId) {
        this.deletePolls(eventId);
        this.deleteWaitingQueue(eventId);
        this.deleteWhitelistedTickets(eventId);
        this.deleteGroupLinks(eventId);
        this.deleteConfigurationEvent(eventId);
        this.deleteConfigurationPurchaseContext(eventId);
        this.deleteConfigurationTicketCategory(eventId);
        this.deleteEmailMessage(eventId);
        this.deleteLegacyTicketFieldValue(eventId);
        this.deleteLegacyTicketFieldDescription(eventId);
        this.deleteLegacyTicketFieldConfiguration(eventId);
        int deletedFieldValues = this.deleteFieldValues(eventId);
        LOGGER.info("deleted {} field values", (Object)deletedFieldValues);
        int deletedDescriptions = this.deleteFieldDescription(eventId);
        LOGGER.info("deleted {} field descriptions", (Object)deletedDescriptions);
        this.deleteAdditionalServiceDescriptions(eventId);
        this.deleteAdditionalServiceItems(eventId);
        int deletedConfigurations = this.deleteFieldConfigurations(eventId);
        LOGGER.info("deleted {} field configurations", (Object)deletedConfigurations);
        this.deleteAdditionalServices(eventId);
        this.deleteEventMigration(eventId);
        this.deleteSponsorScan(eventId);
        this.deleteTicket(eventId);
        this.deleteTransactions(eventId);
        this.deleteBillingDocuments(eventId);
        this.deleteReservation(eventId);
        this.deleteSpecialPrice(eventId);
        this.deletePromoCode(eventId);
        this.deleteTicketCategoryText(eventId);
        this.deleteTicketCategory(eventId);
        this.deleteEventDescription(eventId);
        this.deleteResources(eventId);
        this.deleteScanAudit(eventId);
        this.deleteSubscriptionLinks(eventId);
        this.deleteEvent(eventId);
    }
}

