/*
 * Decompiled with CFR 0.152.
 */
package alfio.repository;

import alfio.model.EventDescription;
import ch.digitalfondue.npjt.Bind;
import ch.digitalfondue.npjt.Query;
import ch.digitalfondue.npjt.QueryRepository;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

@QueryRepository
public interface EventDescriptionRepository {
    @Query(value="select * from event_description_text where event_id_fk = :eventId")
    public List<EventDescription> findByEventId(@Bind(value="eventId") int var1);

    @Query(value="select locale, description from event_description_text where event_id_fk = :eventId and type = 'DESCRIPTION'")
    public List<EventDescription.LocaleDescription> findDescriptionByEventId(@Bind(value="eventId") int var1);

    default public Map<String, String> findByEventIdAsMap(int eventId) {
        return this.findByEventId(eventId).stream().collect(Collectors.toMap(EventDescription::getLocale, EventDescription::getDescription));
    }

    default public Map<String, String> findDescriptionByEventIdAsMap(int eventId) {
        return this.findDescriptionByEventId(eventId).stream().collect(Collectors.toMap(EventDescription.LocaleDescription::getLocale, EventDescription.LocaleDescription::getDescription));
    }

    @Query(value="select description from event_description_text where event_id_fk = :eventId and type = :type and locale = :locale")
    public Optional<String> findDescriptionByEventIdTypeAndLocale(@Bind(value="eventId") int var1, @Bind(value="type") EventDescription.EventDescriptionType var2, @Bind(value="locale") String var3);

    @Query(value="insert into event_description_text(event_id_fk, locale, type, description) values (:eventId, :locale, :type, :description)")
    public int insert(@Bind(value="eventId") int var1, @Bind(value="locale") String var2, @Bind(value="type") EventDescription.EventDescriptionType var3, @Bind(value="description") String var4);

    @Query(value="delete from event_description_text where event_id_fk = :eventId and type = :type")
    public int delete(@Bind(value="eventId") int var1, @Bind(value="type") EventDescription.EventDescriptionType var2);
}

