/*
 * Decompiled with CFR 0.152.
 */
package alfio.repository;

import alfio.manager.support.CheckInStatistics;
import alfio.model.Event;
import alfio.model.EventAndOrganizationId;
import alfio.model.EventIdShortName;
import alfio.model.EventStatisticView;
import alfio.model.PriceContainer;
import alfio.model.metadata.AlfioMetadata;
import alfio.model.support.JSONData;
import ch.digitalfondue.npjt.AffectedRowCountAndKey;
import ch.digitalfondue.npjt.AutoGeneratedKey;
import ch.digitalfondue.npjt.Bind;
import ch.digitalfondue.npjt.Query;
import ch.digitalfondue.npjt.QueryRepository;
import ch.digitalfondue.npjt.QueryType;
import java.math.BigDecimal;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;

@QueryRepository
public interface EventRepository {
    @Query(value="select * from event where id = :eventId")
    public Event findById(@Bind(value="eventId") int var1);

    @Query(value="select display_name from event where id = :eventId")
    public String getDisplayNameById(@Bind(value="eventId") int var1);

    @Query(value="select id, org_id from event where id = :eventId")
    public EventAndOrganizationId findEventAndOrganizationIdById(@Bind(value="eventId") int var1);

    @Query(value="select * from event where id = :eventId")
    public Optional<Event> findOptionalById(@Bind(value="eventId") int var1);

    @Query(value="select exists(select 1 from event where id = :eventId)")
    public boolean existsById(@Bind(value="eventId") int var1);

    @Query(value="select exists(select 1 from event where short_name = :eventName)")
    public boolean existsByShortName(@Bind(value="eventName") String var1);

    @Query(value="select id, org_id from event where id = :eventId")
    public Optional<EventAndOrganizationId> findOptionalEventAndOrganizationIdById(@Bind(value="eventId") int var1);

    @Query(value="select org_id from event where id = :eventId")
    public int findOrganizationIdByEventId(@Bind(value="eventId") int var1);

    @Query(value="select org_id from event where short_name = :shortName")
    public int findOrganizationIdByShortName(@Bind(value="shortName") String var1);

    default public ZoneId getZoneIdByEventId(int eventId) {
        return TimeZone.getTimeZone(this.getTimeZoneByEventId(eventId)).toZoneId();
    }

    @Query(value="select currency from event where id = :eventId")
    public String getEventCurrencyCode(@Bind(value="eventId") int var1);

    @Query(value="select time_zone from event where id = :eventId")
    public String getTimeZoneByEventId(@Bind(value="eventId") int var1);

    @Query(value="select * from event where short_name = :eventName")
    public Event findByShortName(@Bind(value="eventName") String var1);

    @Query(value="select * from event where short_name = :eventName")
    public Optional<Event> findOptionalByShortName(@Bind(value="eventName") String var1);

    @Query(value="select private_key from event where id = :eventId")
    public String getPrivateKey(@Bind(value="eventId") int var1);

    @Query(value="select id, org_id from event where short_name = :eventName")
    public Optional<EventAndOrganizationId> findOptionalEventAndOrganizationIdByShortName(@Bind(value="eventName") String var1);

    @Query(value="select locales from event where short_name = :eventName")
    public Optional<Integer> findLocalesByShortName(@Bind(value="eventName") String var1);

    @Query(value="select * from event order by start_ts, end_ts")
    public List<Event> findAll();

    @Query(value="select * from event where id in(:ids) order by start_ts, end_ts")
    public List<Event> findByIds(@Bind(value="ids") Collection<Integer> var1);

    @Query(value="select * from event where org_id in (:organizationIds) order by start_ts, end_ts")
    public List<Event> findByOrganizationIds(@Bind(value="organizationIds") Collection<Integer> var1);

    @Query(value="insert into event(short_name, format, display_name, website_url, external_url, website_t_c_url, website_p_p_url, image_url, file_blob_id, location, latitude, longitude, start_ts, end_ts, time_zone, regular_price_cts, currency, available_seats, vat_included, vat, allowed_payment_proxies, private_key, org_id, locales, vat_status, src_price_cts, version, status, metadata) values(:shortName, :format::event_format, :displayName, :websiteUrl, :externalUrl, :termsUrl, :privacyUrl, :imageUrl, :fileBlobId, :location, :latitude, :longitude, :start_ts, :end_ts, :time_zone, 0, :currency, :available_seats, :vat_included, :vat, :paymentProxies, :privateKey, :organizationId, :locales, :vatStatus, :srcPriceCts, :version, :status, :metadata::jsonb)")
    @AutoGeneratedKey(value="id")
    public AffectedRowCountAndKey<Integer> insert(@Bind(value="shortName") String var1, @Bind(value="format") Event.EventFormat var2, @Bind(value="displayName") String var3, @Bind(value="websiteUrl") String var4, @Bind(value="externalUrl") String var5, @Bind(value="termsUrl") String var6, @Bind(value="privacyUrl") String var7, @Bind(value="imageUrl") String var8, @Bind(value="fileBlobId") String var9, @Bind(value="location") String var10, @Bind(value="latitude") String var11, @Bind(value="longitude") String var12, @Bind(value="start_ts") ZonedDateTime var13, @Bind(value="end_ts") ZonedDateTime var14, @Bind(value="time_zone") String var15, @Bind(value="currency") String var16, @Bind(value="available_seats") int var17, @Bind(value="vat_included") boolean var18, @Bind(value="vat") BigDecimal var19, @Bind(value="paymentProxies") String var20, @Bind(value="privateKey") String var21, @Bind(value="organizationId") int var22, @Bind(value="locales") int var23, @Bind(value="vatStatus") PriceContainer.VatStatus var24, @Bind(value="srcPriceCts") int var25, @Bind(value="version") String var26, @Bind(value="status") Event.Status var27, @Bind(value="metadata") @JSONData AlfioMetadata var28);

    @Query(value="update event set status = :status where id = :id")
    public int updateEventStatus(@Bind(value="id") int var1, @Bind(value="status") Event.Status var2);

    @Query(value="update event set display_name = :displayName, website_url = :websiteUrl, external_url = :externalUrl, website_t_c_url = :termsUrl, website_p_p_url = :privacyUrl, image_url = :imageUrl, file_blob_id = :fileBlobId, location = :location, latitude = :latitude, longitude = :longitude, start_ts = :start_ts, end_ts = :end_ts, time_zone = :time_zone, org_id = :organizationId, locales = :locales, format = :format::event_format where id = :id")
    public int updateHeader(@Bind(value="id") int var1, @Bind(value="displayName") String var2, @Bind(value="websiteUrl") String var3, @Bind(value="externalUrl") String var4, @Bind(value="termsUrl") String var5, @Bind(value="privacyUrl") String var6, @Bind(value="imageUrl") String var7, @Bind(value="fileBlobId") String var8, @Bind(value="location") String var9, @Bind(value="latitude") String var10, @Bind(value="longitude") String var11, @Bind(value="start_ts") ZonedDateTime var12, @Bind(value="end_ts") ZonedDateTime var13, @Bind(value="time_zone") String var14, @Bind(value="organizationId") int var15, @Bind(value="locales") int var16, @Bind(value="format") Event.EventFormat var17);

    @Query(value="update event set currency = :currency, available_seats = :available_seats, vat_included = :vat_included, vat = :vat, allowed_payment_proxies = :paymentProxies, vat_status = :vatStatus, src_price_cts = :srcPriceCts where id = :eventId")
    public int updatePrices(@Bind(value="currency") String var1, @Bind(value="available_seats") int var2, @Bind(value="vat_included") boolean var3, @Bind(value="vat") BigDecimal var4, @Bind(value="paymentProxies") String var5, @Bind(value="eventId") int var6, @Bind(value="vatStatus") PriceContainer.VatStatus var7, @Bind(value="srcPriceCts") int var8);

    @Query(value="select a.* from event a inner join tickets_reservation on event_id_fk = a.id where tickets_reservation.id = :reservationId")
    public Event findByReservationId(@Bind(value="reservationId") String var1);

    @Query(value="update event set display_name = short_name where id = :eventId and display_name is null")
    public int fillDisplayNameIfRequired(@Bind(value="eventId") int var1);

    @Query(value="select id from event where end_ts > :now")
    public List<Integer> findAllActiveIds(@Bind(value="now") ZonedDateTime var1);

    @Query(value="select * from event where end_ts > :now order by start_ts, end_ts")
    public List<Event> findAllActives(@Bind(value="now") ZonedDateTime var1);

    @Query(value="update event set available_seats = :newValue where id = :eventId")
    public int updateAvailableSeats(@Bind(value="eventId") int var1, @Bind(value="newValue") int var2);

    @Query(value="select * from event where short_name = :name for update")
    public Optional<Event> findOptionalByShortNameForUpdate(@Bind(value="name") String var1);

    @Query(value="select * from events_statistics where id in (:ids)")
    public List<EventStatisticView> findStatisticsFor(@Bind(value="ids") Set<Integer> var1);

    @Query(value="select * from events_statistics where id = :eventId")
    public EventStatisticView findStatisticsFor(@Bind(value="eventId") int var1);

    @Query(value="select available_seats from events_statistics where id = :eventId")
    public Integer countExistingTickets(@Bind(value="eventId") int var1);

    @Query(value="select count(*) from event")
    public Integer countEvents();

    @Query(value="select count(*) from event where org_id = :organizationId and short_name in (:eventShortNames)")
    public Integer countEventsInOrganization(@Bind(value="organizationId") int var1, @Bind(value="eventShortNames") Collection<String> var2);

    @Query(value="select * from event where org_id = :organizationId and short_name in (:eventShortNames)")
    public List<Event> findEventsByShortNames(@Bind(value="organizationId") int var1, @Bind(value="eventShortNames") Collection<String> var2);

    @Query(value="update event set status = 'DISABLED' where org_id in (select org_id from j_user_organization where user_id in (:userIds)) returning id", type=QueryType.MODIFYING_WITH_RETURN)
    public List<Integer> disableEventsForUsers(@Bind(value="userIds") Collection<Integer> var1);

    @Query(value="update event set status = 'DISABLED' where org_id = :orgId returning id", type=QueryType.MODIFYING_WITH_RETURN)
    public List<Integer> disableEventsForOrganization(@Bind(value="orgId") int var1);

    @Query(value="select coalesce(sum(final_price_cts),0) from tickets_reservation where event_id_fk = :eventId and status = 'COMPLETE'")
    public long getGrossIncome(@Bind(value="eventId") int var1);

    @Query(value="select count(*) as total_attendees, COALESCE(SUM(CASE WHEN status = 'CHECKED_IN' THEN 1 ELSE 0 END), 0) as checked_in, CURRENT_TIMESTAMP as last_update from ticket where event_id = :eventId and status in('ACQUIRED', 'CHECKED_IN', 'TO_BE_PAID')")
    public CheckInStatistics retrieveCheckInStatisticsForEvent(@Bind(value="eventId") int var1);

    @Query(value="select id, short_name from event where id in (:eventIds)")
    public List<EventIdShortName> getEventNamesByIds(@Bind(value="eventIds") List<Integer> var1);

    @Query(value="select id, short_name from event where org_id = :orgId order by short_name")
    public List<EventIdShortName> getEventsNameInOrganization(@Bind(value="orgId") int var1);

    @JSONData
    @Query(value="select metadata from event where id = :eventId")
    public AlfioMetadata getMetadataForEvent(@Bind(value="eventId") int var1);

    @Query(value="update event set metadata = :metadata::jsonb where id = :eventId")
    public int updateMetadata(@Bind(value="metadata") @JSONData AlfioMetadata var1, @Bind(value="eventId") int var2);

    @Query(value="select * from event where id in (select distinct id from basic_event_with_optional_subscription where end_ts > now() and status = 'PUBLIC' and (:subscriptionId::uuid is null or subscription_id = :subscriptionId::uuid) and (:organizer::integer is null or org_id = :organizer) and (:organizerSlug::text is null or org_slug = :organizerSlug) and (:tags::text[] is null or tags @> ARRAY[ :tags ]::text[])) order by start_ts, end_ts")
    public List<Event> findVisibleBySearchOptions(@Bind(value="subscriptionId") UUID var1, @Bind(value="organizer") Integer var2, @Bind(value="organizerSlug") String var3, @Bind(value="tags") List<String> var4);

    @Query(value="select id from event where short_name in (:shortNames) and org_id = :orgId")
    public List<Integer> findIdsByShortNames(@Bind(value="shortNames") List<String> var1, @Bind(value="orgId") int var2);
}

