/*
 * Decompiled with CFR 0.152.
 */
package alfio.repository;

import alfio.extension.ExtensionMetadata;
import alfio.model.ExtensionCapabilitySummary;
import alfio.model.ExtensionSupport;
import alfio.model.support.JSONData;
import ch.digitalfondue.npjt.AffectedRowCountAndKey;
import ch.digitalfondue.npjt.AutoGeneratedKey;
import ch.digitalfondue.npjt.Bind;
import ch.digitalfondue.npjt.Query;
import ch.digitalfondue.npjt.QueryRepository;
import ch.digitalfondue.npjt.QueryType;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;

@QueryRepository
public interface ExtensionRepository {
    @Query(value="insert into extension_support(path, name, display_name, hash, enabled, async, script, metadata) values  (:path, :name, :displayName, :hash, :enabled, :async, :script, :metadata::jsonb)")
    public int insert(@Bind(value="path") String var1, @Bind(value="name") String var2, @Bind(value="displayName") String var3, @Bind(value="hash") String var4, @Bind(value="enabled") boolean var5, @Bind(value="async") boolean var6, @Bind(value="script") String var7, @Bind(value="metadata") @JSONData ExtensionMetadata var8);

    @Query(value="update extension_support set display_name = :displayName, hash = :hash, enabled = :enabled, async = :async, script = :script, metadata = :metadata::jsonb where path = :path and name = :name")
    public int update(@Bind(value="path") String var1, @Bind(value="name") String var2, @Bind(value="displayName") String var3, @Bind(value="hash") String var4, @Bind(value="enabled") boolean var5, @Bind(value="async") boolean var6, @Bind(value="script") String var7, @Bind(value="metadata") @JSONData ExtensionMetadata var8);

    @Query(value="update extension_support set enabled = :enabled where path = :path and name = :name")
    public int toggle(@Bind(value="path") String var1, @Bind(value="name") String var2, @Bind(value="enabled") boolean var3);

    @Query(value="insert into extension_event(es_id_fk, event) values  (:extensionId, :event)")
    public int insertEvent(@Bind(value="extensionId") int var1, @Bind(value="event") String var2);

    @Query(value="select es_id from extension_support where path = :path and name = :name")
    public int getExtensionIdFor(@Bind(value="path") String var1, @Bind(value="name") String var2);

    @Query(value="select script from extension_support where path = :path and name = :name")
    public String getScript(@Bind(value="path") String var1, @Bind(value="name") String var2);

    @Query(value="select * from extension_support where path = :path and name = :name")
    public Optional<ExtensionSupport> getSingle(@Bind(value="path") String var1, @Bind(value="name") String var2);

    @Query(value="select * from extension_support where path in (:paths) and name = :name limit 1")
    public Optional<ExtensionSupport> getSingle(@Bind(value="paths") Collection<String> var1, @Bind(value="name") String var2);

    @Query(value="delete from extension_event where es_id_fk = (select es_id from extension_support where path = :path and name = :name)")
    public int deleteEventsForPath(@Bind(value="path") String var1, @Bind(value="name") String var2);

    @Query(value="delete from extension_support where path = :path and name = :name")
    public int deleteScriptForPath(@Bind(value="path") String var1, @Bind(value="name") String var2);

    @Query(value="select * from extension_support order by path, name")
    public List<ExtensionSupport> listAll();

    @Query(value="select a3.es_id, a3.path, a3.name, a3.hash from  (select a1.* from  (select es_id, path, name, hash from extension_support where enabled = true and async = :async and (path in (:possiblePaths))) a1  left outer join (select es_id, path, name from extension_support where enabled = true and async = :async and (path in (:possiblePaths))) a2 on  (a1.es_id = a2.es_id) and length(a1.path) < length(a2.path) where a2.path is null) a3  inner join extension_event on es_id_fk = a3.es_id where event = :event order by a3.name, a3.path")
    public List<ExtensionSupport.ScriptPathNameHash> findActive(@Bind(value="possiblePaths") Set<String> var1, @Bind(value="async") boolean var2, @Bind(value="event") String var3);

    @Query(value="delete from extension_configuration_metadata where  ecm_es_id_fk = :extensionId")
    public int deleteExtensionParameter(@Bind(value="extensionId") int var1);

    @Query(value="select ecm_name, ecm_configuration_level, conf_path, conf_value from extension_configuration_metadata  inner join extension_configuration_metadata_value on fk_ecm_id = ecm_id  where  ecm_es_id_fk =  :extensionId ")
    public List<ExtensionSupport.ExtensionParameterKeyValue> findExtensionParameterKeyValue(@Bind(value="extensionId") int var1);

    @Query(value="insert into extension_configuration_metadata(ecm_es_id_fk, ecm_name, ecm_description, ecm_type, ecm_configuration_level, ecm_mandatory)  values (:extensionId, :name, :description, :type, :configurationLevel, :mandatory)")
    @AutoGeneratedKey(value="ecm_id")
    public AffectedRowCountAndKey<Integer> registerExtensionConfigurationMetadata(@Bind(value="extensionId") int var1, @Bind(value="name") String var2, @Bind(value="description") String var3, @Bind(value="type") String var4, @Bind(value="configurationLevel") String var5, @Bind(value="mandatory") boolean var6);

    @Query(value="select ecm_id, ecm_name, ecm_configuration_level, ecm_description, ecm_type, ecm_mandatory, path, es_id, name, display_name, conf_path, conf_value from extension_configuration_metadata  inner join extension_support on es_id = ecm_es_id_fk  left outer join extension_configuration_metadata_value on ecm_id = fk_ecm_id and (conf_path is null or (conf_path in (:possiblePaths)))  where ecm_configuration_level = :configurationLevel and (path in (:possiblePaths) or path like :pathPattern) order by es_id, name, ecm_id, ecm_name")
    public List<ExtensionSupport.ExtensionParameterMetadataAndValue> getParametersForLevelAndPath(@Bind(value="configurationLevel") String var1, @Bind(value="possiblePaths") Set<String> var2, @Bind(value="pathPattern") String var3);

    @Query(value="delete from extension_configuration_metadata_value where fk_ecm_id in (select ecm_id from extension_configuration_metadata where ECM_CONFIGURATION_LEVEL = :confLevel) and conf_path = :confPath")
    public int deleteSettingValue(@Bind(value="confLevel") String var1, @Bind(value="confPath") String var2);

    @Query(value="delete from extension_configuration_metadata_value where fk_ecm_id = :id and conf_path = :path")
    public int deleteSettingValue(@Bind(value="id") int var1, @Bind(value="path") String var2);

    @Query(value="insert into extension_configuration_metadata_value(fk_ecm_id, conf_path, conf_value) values (:ecmId, :confPath, :value)")
    public int insertSettingValue(@Bind(value="ecmId") int var1, @Bind(value="confPath") String var2, @Bind(value="value") String var3);

    @Query(type=QueryType.TEMPLATE, value="insert into extension_configuration_metadata_value(fk_ecm_id, conf_path, conf_value) values (:ecmId, :confPath, :value)")
    public String bulkInsertSettingValue();

    @Query(value="select ecm_name, conf_value from (select ecm_name, conf_value, ecm_configuration_level, conf_path, (case when ecm_configuration_level = 'EVENT' then 0 when ecm_configuration_level = 'ORGANIZATION' then 1 else 2 end) as priority from extension_configuration_metadata inner join extension_configuration_metadata_value on ecm_id = fk_ecm_id where ecm_es_id_fk = (SELECT es_id from extension_support where path = :path and name = :name) and conf_path in (:allPaths)) a1 where (ecm_name, priority) in (select ecm_name, min(priority) selected_priority from ( select ecm_name, conf_value, ecm_configuration_level, conf_path, (case when ecm_configuration_level = 'EVENT' then 0 when ecm_configuration_level = 'ORGANIZATION' then 1 else 2 end) as priority from extension_configuration_metadata inner join extension_configuration_metadata_value on ecm_id = fk_ecm_id where ecm_es_id_fk = (SELECT es_id from extension_support where path = :path and name = :name) and conf_path in (:allPaths)) a2 group by ecm_name)")
    public List<ExtensionSupport.NameAndValue> findParametersForScript(@Bind(value="name") String var1, @Bind(value="path") String var2, @Bind(value="allPaths") Set<String> var3);

    @Query(value="select distinct ecm_name from extension_configuration_metadata where ecm_es_id_fk = (SELECT es_id from extension_support where path = :path and name = :name) and ecm_mandatory is true")
    public List<String> findMandatoryParametersForScript(@Bind(value="name") String var1, @Bind(value="path") String var2);

    @Query(value="select ecm_id, ecm_name from extension_configuration_metadata where ecm_es_id_fk = :extensionId")
    public List<ExtensionSupport.ExtensionMetadataIdAndName> findAllParametersForExtension(@Bind(value="extensionId") int var1);

    @Query(value="select count(a3.*) from  (select a1.es_id from  (select es_id, path from extension_capabilities where (path in (:possiblePaths)) and capability in(:capabilities)) a1  left outer join (select es_id, path from extension_capabilities where (path in (:possiblePaths)) and capability in(:capabilities)) a2 on  (a1.es_id = a2.es_id) and length(a1.path) < length(a2.path) where a2.path is null) a3 ")
    public int countScriptsSupportingCapability(@Bind(value="possiblePaths") Set<String> var1, @Bind(value="capabilities") List<String> var2);

    @Query(value="select distinct a3.capability, a3.capability_detail from  (select a1.es_id, a1.capability, a1.capability_detail from  (select es_id, path, capability, capability_detail from extension_capabilities where (path in (:possiblePaths)) and capability in(:capabilities)) a1  left outer join (select es_id, path, capability, capability_detail from extension_capabilities where (path in (:possiblePaths)) and capability in(:capabilities)) a2 on  (a1.es_id = a2.es_id) and length(a1.path) < length(a2.path) where a2.path is null) a3 ")
    public List<ExtensionCapabilitySummary> getSupportedCapabilities(@Bind(value="possiblePaths") Set<String> var1, @Bind(value="capabilities") Collection<String> var2);

    @Query(value="select a3.es_id, a3.path, a3.name, a3.hash from  (select a1.es_id, a1.path, a1.name, a1.hash from  (select es_id, path, name, hash from extension_capabilities where (path in (:possiblePaths)) and capability = :capability) a1  left outer join (select es_id, path, name, hash from extension_capabilities where (path in (:possiblePaths)) and capability = :capability) a2 on  (a1.es_id = a2.es_id) and length(a1.path) < length(a2.path) where a2.path is null) a3 limit 1")
    public Optional<ExtensionSupport.ScriptPathNameHash> getFirstScriptForCapability(@Bind(value="possiblePaths") Set<String> var1, @Bind(value="capability") String var2);
}

