/*
 * Decompiled with CFR 0.152.
 */
package alfio.repository;

import alfio.model.FileBlobMetadata;
import alfio.model.modification.UploadBase64FileModification;
import ch.digitalfondue.npjt.Bind;
import ch.digitalfondue.npjt.Query;
import ch.digitalfondue.npjt.QueryRepository;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.support.lob.DefaultLobHandler;

@QueryRepository
public interface FileUploadRepository {
    @Query(value="select exists (select 1 from file_blob where id = :id)")
    public boolean isPresent(@Bind(value="id") String var1);

    @Query(value="select id, name, content_size, content_type, attributes from file_blob where id = :id")
    public Optional<FileBlobMetadata> findById(@Bind(value="id") String var1);

    @Query(value="delete from file_blob where creation_time <= :date and id not in (select file_blob_id from event where file_blob_id is not null union select file_blob_id_fk as file_blob_id from subscription_descriptor where file_blob_id_fk is not null)")
    public int cleanupUnreferencedBlobFiles(@Bind(value="date") Date var1);

    default public void upload(UploadBase64FileModification file, String digest, Map<String, String> attributes) {
        DefaultLobHandler lobHandler = new DefaultLobHandler();
        NamedParameterJdbcTemplate jdbc = this.getNamedParameterJdbcTemplate();
        jdbc.getJdbcOperations().execute("insert into file_blob (id, name, content_size, content, content_type, attributes) values(?, ?, ?, ?, ?, ?)", (PreparedStatementCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public NamedParameterJdbcTemplate getNamedParameterJdbcTemplate();

    default public File file(String id) {
        try {
            File cachedFile = File.createTempFile("fileupload-cache", ".tmp");
            MapSqlParameterSource param = new MapSqlParameterSource("id", (Object)id);
            this.getNamedParameterJdbcTemplate().query("select content from file_blob where id = :id", (SqlParameterSource)param, rs -> {
                try (InputStream is = rs.getBinaryStream("content");
                     FileOutputStream os = new FileOutputStream(cachedFile);){
                    is.transferTo(os);
                }
                catch (IOException e) {
                    throw new IllegalStateException("Error while copying data", e);
                }
            });
            return cachedFile;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

