/*
 * Decompiled with CFR 0.152.
 */
package alfio.repository;

import alfio.model.group.Group;
import alfio.model.group.GroupMember;
import alfio.model.group.LinkedGroup;
import alfio.model.modification.GroupMemberModification;
import ch.digitalfondue.npjt.AffectedRowCountAndKey;
import ch.digitalfondue.npjt.AutoGeneratedKey;
import ch.digitalfondue.npjt.Bind;
import ch.digitalfondue.npjt.Query;
import ch.digitalfondue.npjt.QueryRepository;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.text.StringEscapeUtils;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

@QueryRepository
public interface GroupRepository {
    public static final String BY_EVENT_ID = "select * from group_link_active where event_id_fk = :eventId";

    @Query(value="insert into a_group(name, description, organization_id_fk) values(:name, :description, :orgId)")
    @AutoGeneratedKey(value="id")
    public AffectedRowCountAndKey<Integer> insert(@Bind(value="name") String var1, @Bind(value="description") String var2, @Bind(value="orgId") int var3);

    @Query(value="select * from group_active where id = :id")
    public Group getById(@Bind(value="id") int var1);

    @Query(value="select exists (select id from group_active where id = :id and organization_id_fk = :organizationId)")
    public Boolean checkGroupExists(@Bind(value="id") int var1, @Bind(value="organizationId") int var2);

    @Query(value="select exists (select id from group_link where id = :id and organization_id_fk = :organizationId and event_id_fk = :eventId and (:categoryId is null or ticket_category_id_fk = :categoryId))")
    public Boolean checkGroupLinkExists(@Bind(value="id") int var1, @Bind(value="organizationId") int var2, @Bind(value="eventId") int var3, @Bind(value="categoryId") Integer var4);

    @Query(value="update a_group set name = :name, description = :description where id = :id")
    public int update(@Bind(value="id") int var1, @Bind(value="name") String var2, @Bind(value="description") String var3);

    @Query(value="select * from group_active where id = :id")
    public Optional<Group> getOptionalById(@Bind(value="id") int var1);

    @Query(value="select * from group_active where organization_id_fk = :organizationId order by name, description")
    public List<Group> getAllActiveForOrganization(@Bind(value="organizationId") int var1);

    @Query(value="select * from a_group where organization_id_fk = :organizationId order by name, description")
    public List<Group> getAllForOrganization(@Bind(value="organizationId") int var1);

    @Query(value="insert into group_link(a_group_id_fk, event_id_fk, ticket_category_id_fk, type, match_type, max_allocation) values(:groupId, :eventId, :ticketCategoryId, :type, :matchType, :maxAllocation)")
    @AutoGeneratedKey(value="id")
    public AffectedRowCountAndKey<Integer> createConfiguration(@Bind(value="groupId") int var1, @Bind(value="eventId") int var2, @Bind(value="ticketCategoryId") Integer var3, @Bind(value="type") LinkedGroup.Type var4, @Bind(value="matchType") LinkedGroup.MatchType var5, @Bind(value="maxAllocation") Integer var6);

    default public int[] insert(int groupId, List<GroupMemberModification> members) {
        MapSqlParameterSource[] params = (MapSqlParameterSource[])members.stream().map(i -> new MapSqlParameterSource("groupId", (Object)groupId).addValue("value", (Object)i.getValue().toLowerCase()).addValue("description", (Object)StringEscapeUtils.escapeHtml4((String)i.getDescription()))).toArray(MapSqlParameterSource[]::new);
        return this.getNamedParameterJdbcTemplate().batchUpdate("insert into group_member(a_group_id_fk, value, description) values(:groupId, :value, :description)", (SqlParameterSource[])params);
    }

    public NamedParameterJdbcTemplate getNamedParameterJdbcTemplate();

    @Query(value="select * from group_member_active where a_group_id_fk = :groupId order by value")
    public List<GroupMember> getItems(@Bind(value="groupId") int var1);

    @Query(value="select value from group_member where a_group_id_fk = :groupId order by value")
    public List<String> getAllValuesIncludingNotActive(@Bind(value="groupId") int var1);

    @Query(value="insert into whitelisted_ticket(group_member_id_fk, group_link_id_fk, ticket_id_fk, requires_unique_value) values(:itemId, :configurationId, :ticketId, :requiresUniqueValue)")
    public int insertWhitelistedTicket(@Bind(value="itemId") int var1, @Bind(value="configurationId") int var2, @Bind(value="ticketId") int var3, @Bind(value="requiresUniqueValue") Boolean var4);

    @Query(value="select * from group_link_active where event_id_fk = :eventId and ticket_category_id_fk = :categoryId union all select * from group_link_active where event_id_fk = :eventId and ticket_category_id_fk is null")
    public List<LinkedGroup> findActiveConfigurationsFor(@Bind(value="eventId") int var1, @Bind(value="categoryId") int var2);

    @Query(value="select * from group_link_active where event_id_fk = :eventId")
    public List<LinkedGroup> findActiveConfigurationsForEvent(@Bind(value="eventId") int var1);

    @Query(value="select count(*) from group_link_active where event_id_fk = :eventId")
    public Integer countByEventId(@Bind(value="eventId") int var1);

    @Query(value="select * from group_link_active where id = :configurationId")
    public LinkedGroup getConfiguration(@Bind(value="configurationId") int var1);

    @Query(value="select * from group_link where id = :configurationId for update")
    public LinkedGroup getConfigurationForUpdate(@Bind(value="configurationId") int var1);

    @Query(value="select count(*) from whitelisted_ticket where group_link_id_fk = :configurationId")
    public int countWhitelistedTicketsForConfiguration(@Bind(value="configurationId") int var1);

    @Query(value="update group_link set a_group_id_fk = :groupId, ticket_category_id_fk = :categoryId, type = :type, match_type = :matchType, max_allocation = :maxAllocation where id = :id and event_id_fk = :eventId")
    public int updateConfiguration(@Bind(value="id") int var1, @Bind(value="groupId") int var2, @Bind(value="eventId") int var3, @Bind(value="categoryId") Integer var4, @Bind(value="type") LinkedGroup.Type var5, @Bind(value="matchType") LinkedGroup.MatchType var6, @Bind(value="maxAllocation") Integer var7);

    @Query(value="update group_link set active = false where id = :id")
    public int disableLink(@Bind(value="id") int var1);

    @Query(value="update group_link set active = false where a_group_id_fk = :groupId")
    public int disableAllLinks(@Bind(value="groupId") int var1);

    @Query(value="select * from group_member_active wi where wi.a_group_id_fk = :groupId and lower(wi.value) = lower(:value)")
    public Optional<GroupMember> findItemByValueExactMatch(@Bind(value="groupId") int var1, @Bind(value="value") String var2);

    @Query(value="select * from group_member_active wi where wi.a_group_id_fk = :groupId and lower(wi.value) like lower(:value) limit 1")
    public Optional<GroupMember> findItemEndsWith(@Bind(value="configurationId") int var1, @Bind(value="groupId") int var2, @Bind(value="value") String var3);

    @Query(value="select count(*) from whitelisted_ticket where group_member_id_fk = :itemId and group_link_id_fk = :configurationId")
    public int countExistingWhitelistedTickets(@Bind(value="itemId") int var1, @Bind(value="configurationId") int var2);

    @Query(value="delete from whitelisted_ticket where ticket_id_fk in (:ticketIds)")
    public int deleteExistingWhitelistedTickets(@Bind(value="ticketIds") List<Integer> var1);

    default public void deactivateGroupMember(List<Integer> memberIds, int groupId) {
        MapSqlParameterSource[] params = (MapSqlParameterSource[])memberIds.stream().map(memberId -> new MapSqlParameterSource("groupId", (Object)groupId).addValue("memberId", memberId).addValue("disabledPlaceholder", (Object)UUID.randomUUID().toString())).toArray(MapSqlParameterSource[]::new);
        this.getNamedParameterJdbcTemplate().batchUpdate("update group_member set active = false, value = 'DISABLED-' || :disabledPlaceholder where id = :memberId and a_group_id_fk = :groupId", (SqlParameterSource[])params);
    }

    @Query(value="update a_group set active = false where id = :groupId")
    public int deactivateGroup(@Bind(value="groupId") int var1);
}

