/*
 * Decompiled with CFR 0.152.
 */
package alfio.repository;

import ch.digitalfondue.npjt.Bind;
import ch.digitalfondue.npjt.Query;
import ch.digitalfondue.npjt.QueryRepository;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@QueryRepository
public interface OrganizationDeleterRepository {
    public static final Logger LOGGER = LoggerFactory.getLogger(OrganizationDeleterRepository.class);
    public static final String SELECT_EMPTY_ORGANIZATIONS = "select distinct(org_id) from j_user_organization where org_id in(:organizationIds)";

    @Query(value="delete from auditing where organization_id_fk in(:organizationIds) and organization_id_fk not in (select distinct(org_id) from j_user_organization where org_id in(:organizationIds))")
    public int deleteAuditingForEmptyOrganizations(@Bind(value="organizationIds") List<Integer> var1);

    @Query(value="delete from invoice_sequences where organization_id_fk in(:organizationIds) and organization_id_fk not in (select distinct(org_id) from j_user_organization where org_id in(:organizationIds))")
    public int deleteInvoiceSequencesForEmptyOrganizations(@Bind(value="organizationIds") List<Integer> var1);

    @Query(value="delete from a_group where organization_id_fk in(:organizationIds) and organization_id_fk not in (select distinct(org_id) from j_user_organization where org_id in(:organizationIds))")
    public int deleteGroupsForEmptyOrganizations(@Bind(value="organizationIds") List<Integer> var1);

    @Query(value="delete from group_member where organization_id_fk in(:organizationIds) and organization_id_fk not in (select distinct(org_id) from j_user_organization where org_id in(:organizationIds))")
    public int deleteGroupMembersForEmptyOrganizations(@Bind(value="organizationIds") List<Integer> var1);

    @Query(value="delete from configuration_organization where organization_id_fk in(:organizationIds) and organization_id_fk not in (select distinct(org_id) from j_user_organization where org_id in(:organizationIds))")
    public int deleteConfigurationForEmptyOrganizations(@Bind(value="organizationIds") List<Integer> var1);

    @Query(value="delete from configuration_purchase_context where organization_id_fk in(:organizationIds) and organization_id_fk not in (select distinct(org_id) from j_user_organization where org_id in(:organizationIds))")
    public int deleteConfigurationForPurchaseContexts(@Bind(value="organizationIds") List<Integer> var1);

    @Query(value="delete from resource_organizer where organization_id_fk in(:organizationIds) and organization_id_fk not in (select distinct(org_id) from j_user_organization where org_id in(:organizationIds))")
    public int deleteResourcesForEmptyOrganizations(@Bind(value="organizationIds") List<Integer> var1);

    @Query(value="delete from subscription where organization_id_fk in (:organizationIds)")
    public int deleteSubscriptions(@Bind(value="organizationIds") List<Integer> var1);

    @Query(value="delete from subscription_descriptor where organization_id_fk in (:organizationIds)")
    public int deleteSubscriptionDescriptors(@Bind(value="organizationIds") List<Integer> var1);

    @Query(value="delete from promo_code where organization_id_fk in (:organizationIds)")
    public int deletePromoCodes(@Bind(value="organizationIds") List<Integer> var1);

    @Query(value="delete from organization where id in(:organizationIds) and id not in (select distinct(org_id) from j_user_organization where org_id in(:organizationIds))")
    public int deleteOrganizationsIfEmpty(@Bind(value="organizationIds") List<Integer> var1);

    @Query(value="delete from tickets_reservation where organization_id_fk in (:organizationIds)")
    public int deleteReservations(@Bind(value="organizationIds") List<Integer> var1);

    @Query(value="delete from admin_reservation_request where organization_id_fk in (:organizationIds)")
    public int deleteAdminReservationRequests(@Bind(value="organizationIds") List<Integer> var1);

    @Query(value="delete from email_message where organization_id_fk in (:organizationIds)")
    public int deleteEmailMessages(@Bind(value="organizationIds") List<Integer> var1);

    @Query(value="delete from b_transaction where organization_id_fk in (:organizationIds)")
    public int deleteAllTransactions(@Bind(value="organizationIds") List<Integer> var1);

    @Query(value="delete from purchase_context_field_value where organization_id_fk in (:organizationIds)")
    public int deleteFieldValues(@Bind(value="organizationIds") List<Integer> var1);

    @Query(value="delete from purchase_context_field_description where organization_id_fk in (:organizationIds)")
    public int deleteFieldDescription(@Bind(value="organizationIds") List<Integer> var1);

    @Query(value="delete from purchase_context_field_configuration where organization_id_fk in (:organizationIds)")
    public int deleteFieldConfiguration(@Bind(value="organizationIds") List<Integer> var1);

    @Query(value="delete from billing_document where organization_id_fk in (:organizationIds)")
    public int deleteBillingDocuments(@Bind(value="organizationIds") List<Integer> var1);

    default public void deleteEmptyOrganizations(List<Integer> organizationIds) {
        int deletedSequences = this.deleteInvoiceSequencesForEmptyOrganizations(organizationIds);
        LOGGER.info("deleted {} invoice sequences", (Object)deletedSequences);
        int deletedAuditing = this.deleteAuditingForEmptyOrganizations(organizationIds);
        LOGGER.info("deleted {} auditing rows", (Object)deletedAuditing);
        int deletedGroupMembers = this.deleteGroupMembersForEmptyOrganizations(organizationIds);
        int deletedGroups = this.deleteGroupsForEmptyOrganizations(organizationIds);
        LOGGER.info("deleted {} groups and {} members", (Object)deletedGroups, (Object)deletedGroupMembers);
        int deletedConfigurations = this.deleteConfigurationForEmptyOrganizations(organizationIds);
        LOGGER.info("deleted {} configurations", (Object)deletedConfigurations);
        deletedConfigurations = this.deleteConfigurationForPurchaseContexts(organizationIds);
        LOGGER.info("deleted {} configurations for purchase_contexts", (Object)deletedConfigurations);
        int deletedResources = this.deleteResourcesForEmptyOrganizations(organizationIds);
        LOGGER.info("deleted {} resources", (Object)deletedResources);
        int deletedEmails = this.deleteEmailMessages(organizationIds);
        LOGGER.info("deleted {} email messages", (Object)deletedEmails);
        int deletedSubscriptions = this.deleteSubscriptions(organizationIds);
        int deletedDescriptors = this.deleteSubscriptionDescriptors(organizationIds);
        LOGGER.info("deleted {} subscription descriptors and {} subscriptions", (Object)deletedDescriptors, (Object)deletedSubscriptions);
        int deletedTransactions = this.deleteAllTransactions(organizationIds);
        LOGGER.info("deleted {} transactions", (Object)deletedTransactions);
        int deletedBillingDocuments = this.deleteBillingDocuments(organizationIds);
        LOGGER.info("deleted {} billing documents", (Object)deletedBillingDocuments);
        int deletedReservations = this.deleteReservations(organizationIds);
        LOGGER.info("deleted {} reservations", (Object)deletedReservations);
        int deletedAdminReservationRequests = this.deleteAdminReservationRequests(organizationIds);
        LOGGER.info("deleted {} adminReservationRequests", (Object)deletedAdminReservationRequests);
        int deletedPromoCodes = this.deletePromoCodes(organizationIds);
        LOGGER.info("deleted {} promo codes", (Object)deletedPromoCodes);
        int deletedOrganizations = this.deleteOrganizationsIfEmpty(organizationIds);
        LOGGER.info("deleted {} empty organizations", (Object)deletedOrganizations);
    }
}

