/*
 * Decompiled with CFR 0.152.
 */
package alfio.repository;

import alfio.model.poll.Poll;
import alfio.model.poll.PollOption;
import alfio.model.poll.PollOptionStatistics;
import alfio.model.support.Array;
import alfio.model.support.JSONData;
import ch.digitalfondue.npjt.AffectedRowCountAndKey;
import ch.digitalfondue.npjt.AutoGeneratedKey;
import ch.digitalfondue.npjt.Bind;
import ch.digitalfondue.npjt.Query;
import ch.digitalfondue.npjt.QueryRepository;
import ch.digitalfondue.npjt.QueryType;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@QueryRepository
public interface PollRepository {
    public static final String INSERT_OPTION = "insert into poll_option(poll_id_fk, title, description, organization_id_fk)  values(:pollId, (:title)::jsonb, (:description)::jsonb, :organizationId)";

    @Query(value="insert into poll (title, description, allowed_tags, poll_order, event_id_fk, organization_id_fk) values(:title::jsonb, :description::jsonb, :allowedTags::text[], :pollOrder, :eventId, :orgId)")
    @AutoGeneratedKey(value="id")
    public AffectedRowCountAndKey<Long> insert(@Bind(value="title") @JSONData Map<String, String> var1, @Bind(value="description") @JSONData Map<String, String> var2, @Bind(value="allowedTags") @Array List<String> var3, @Bind(value="pollOrder") int var4, @Bind(value="eventId") int var5, @Bind(value="orgId") int var6);

    @Query(value="update poll set title = :title::jsonb, description = :description::jsonb, allowed_tags = :allowedTags::text[], poll_order = :pollOrder where id = :id and event_id_fk = :eventId")
    public int update(@Bind(value="title") @JSONData Map<String, String> var1, @Bind(value="description") @JSONData Map<String, String> var2, @Bind(value="allowedTags") @Array List<String> var3, @Bind(value="pollOrder") int var4, @Bind(value="id") long var5, @Bind(value="eventId") int var7);

    @Query(value="update poll set status = :status::POLL_STATUS where id = :id and event_id_fk = :eventId")
    public int updateStatus(@Bind(value="status") Poll.PollStatus var1, @Bind(value="id") Long var2, @Bind(value="eventId") int var3);

    @Query(value="select * from poll where event_id_fk = :eventId order by poll_order asc")
    public List<Poll> findAllForEvent(@Bind(value="eventId") int var1);

    @Query(value="select * from poll where event_id_fk = :eventId and status = 'OPEN' order by poll_order asc")
    public List<Poll> findActiveForEvent(@Bind(value="eventId") int var1);

    @Query(value="select * from poll where event_id_fk = :eventId and status = 'OPEN' and id = :id")
    public Optional<Poll> findSingleActiveForEvent(@Bind(value="eventId") int var1, @Bind(value="id") Long var2);

    @Query(value="select * from poll where event_id_fk = :eventId and id = :id")
    public Optional<Poll> findSingleForEvent(@Bind(value="eventId") int var1, @Bind(value="id") Long var2);

    @Query(value="insert into poll_option(poll_id_fk, title, description, organization_id_fk)  values(:pollId, (:title)::jsonb, (:description)::jsonb, :organizationId)")
    @AutoGeneratedKey(value="id")
    public AffectedRowCountAndKey<Long> insertOption(@Bind(value="pollId") Long var1, @Bind(value="title") @JSONData Map<String, String> var2, @Bind(value="description") @JSONData Map<String, String> var3, @Bind(value="organizationId") Integer var4);

    @Query(type=QueryType.TEMPLATE, value="insert into poll_option(poll_id_fk, title, description, organization_id_fk)  values(:pollId, (:title)::jsonb, (:description)::jsonb, :organizationId)")
    public String bulkInsertOptions();

    @Query(type=QueryType.TEMPLATE, value="update poll_option set title = :title::jsonb, description = :description::jsonb where id = :id and poll_id_fk = :pollId")
    public String bulkUpdateOptions();

    @Query(value="select * from poll_option where poll_id_fk = :pollId order by id")
    public List<PollOption> getOptionsForPoll(@Bind(value="pollId") long var1);

    @Query(value="select count(*) from poll_option  join poll on poll_option.poll_id_fk = poll.id where poll_option.id = :optionId and poll.id = :pollId and poll.event_id_fk = :eventId")
    public Integer checkPollOption(@Bind(value="optionId") long var1, @Bind(value="pollId") long var3, @Bind(value="eventId") int var5);

    @Query(value="insert into poll_answer(poll_id_fk, poll_option_id_fk, ticket_id_fk, organization_id_fk) values(:pollId, :optionId, :ticketId, :orgId) on conflict(poll_id_fk, ticket_id_fk) do update set poll_option_id_fk = excluded.poll_option_id_fk")
    public int registerAnswer(@Bind(value="pollId") long var1, @Bind(value="optionId") long var3, @Bind(value="ticketId") int var5, @Bind(value="orgId") int var6);

    @Query(value="select pa.poll_option_id_fk, count(*) as votes from poll_answer pa    join poll p on p.id = pa.poll_id_fk  where p.id = :pollId and p.event_id_fk = :eventId group by 1")
    public List<PollOptionStatistics> getStatisticsFor(@Bind(value="pollId") Long var1, @Bind(value="eventId") int var2);

    @Query(value="delete from poll where id = :pollId and event_id_fk = :eventId and organization_id_fk = :orgId")
    public int deletePoll(@Bind(value="pollId") long var1, @Bind(value="eventId") int var3, @Bind(value="orgId") int var4);

    @Query(value="delete from poll_option where id = :optionId and poll_id_fk = :pollId")
    public int deleteOption(@Bind(value="pollId") long var1, @Bind(value="optionId") long var3);
}

