/*
 * Decompiled with CFR 0.152.
 */
package alfio.repository;

import alfio.model.PromoCodeDiscount;
import alfio.model.PromoCodeUsageResult;
import ch.digitalfondue.npjt.Bind;
import ch.digitalfondue.npjt.Query;
import ch.digitalfondue.npjt.QueryRepository;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Optional;

@QueryRepository
public interface PromoCodeDiscountRepository {
    @Query(value="select * from promo_code where event_id_fk = :eventId order by promo_code asc")
    public List<PromoCodeDiscount> findAllInEvent(@Bind(value="eventId") int var1);

    @Query(value="select * from promo_code where organization_id_fk = :organizationId and event_id_fk is null order by promo_code asc")
    public List<PromoCodeDiscount> findAllInOrganization(@Bind(value="organizationId") int var1);

    @Query(value="delete from promo_code where id = :id")
    public int deletePromoCode(@Bind(value="id") int var1);

    @Query(value="select * from promo_code where id = :id")
    public PromoCodeDiscount findById(@Bind(value="id") int var1);

    @Query(value="select * from promo_code where id = :id")
    public Optional<PromoCodeDiscount> findOptionalById(@Bind(value="id") int var1);

    @Query(value="select exists (select 1 from promo_code where id = :id and organization_id_fk = :orgId and (:eventId is null or event_id_fk = :eventId)")
    public Boolean checkPromoCodeExists(@Bind(value="id") int var1, @Bind(value="orgId") int var2, @Bind(value="eventId") Integer var3);

    @Query(value="insert into promo_code(promo_code, event_id_fk, organization_id_fk, valid_from, valid_to, discount_amount, discount_type, categories, max_usage, description, email_reference, code_type, hidden_category_id, currency_code)  values (:promoCode, :eventId, :organizationId, :start, :end, :discountAmount, :discountType, :categories, :maxUsage, :description, :emailReference, :codeType, :hiddenCategoryId, :currencyCode)")
    public int addPromoCode(@Bind(value="promoCode") String var1, @Bind(value="eventId") Integer var2, @Bind(value="organizationId") int var3, @Bind(value="start") ZonedDateTime var4, @Bind(value="end") ZonedDateTime var5, @Bind(value="discountAmount") int var6, @Bind(value="discountType") PromoCodeDiscount.DiscountType var7, @Bind(value="categories") String var8, @Bind(value="maxUsage") Integer var9, @Bind(value="description") String var10, @Bind(value="emailReference") String var11, @Bind(value="codeType") PromoCodeDiscount.CodeType var12, @Bind(value="hiddenCategoryId") Integer var13, @Bind(value="currencyCode") String var14);

    @Query(value="insert into promo_code(promo_code, event_id_fk, organization_id_fk, valid_from, valid_to, discount_amount, discount_type, categories, max_usage, description, email_reference, code_type, hidden_category_id)  values (:promoCode, :eventId, :organizationId, :start, :end, :discountAmount, :discountType, :categories, :maxUsage, :description, :emailReference, :codeType, :hiddenCategoryId)  ON CONFLICT (promo_code, event_id_fk) where event_id_fk is not null do nothing")
    public int addPromoCodeIfNotExists(@Bind(value="promoCode") String var1, @Bind(value="eventId") Integer var2, @Bind(value="organizationId") int var3, @Bind(value="start") ZonedDateTime var4, @Bind(value="end") ZonedDateTime var5, @Bind(value="discountAmount") int var6, @Bind(value="discountType") PromoCodeDiscount.DiscountType var7, @Bind(value="categories") String var8, @Bind(value="maxUsage") Integer var9, @Bind(value="description") String var10, @Bind(value="emailReference") String var11, @Bind(value="codeType") PromoCodeDiscount.CodeType var12, @Bind(value="hiddenCategoryId") Integer var13);

    @Query(value="select * from promo_code where promo_code = :promoCode and ( event_id_fk = :eventId or  (event_id_fk is null and organization_id_fk = (select org_id from event where id = :eventId)))  order by event_id_fk is null limit 1")
    public Optional<PromoCodeDiscount> findPromoCodeInEventOrOrganization(@Bind(value="eventId") int var1, @Bind(value="promoCode") String var2);

    @Query(value="select * from promo_code where promo_code = :promoCode and code_type <> 'DYNAMIC' and ( event_id_fk = :eventId or  (event_id_fk is null and organization_id_fk = (select org_id from event where id = :eventId)))  order by event_id_fk is null limit 1")
    public Optional<PromoCodeDiscount> findPublicPromoCodeInEventOrOrganization(@Bind(value="eventId") int var1, @Bind(value="promoCode") String var2);

    @Query(value="select count(*) from promo_code where event_id_fk = :eventId or (event_id_fk is null and organization_id_fk = :organizationId)")
    public Integer countByEventAndOrganizationId(@Bind(value="eventId") int var1, @Bind(value="organizationId") int var2);

    @Query(value="select promo_code_use from promocode_count where promo_code_id = :id")
    public Integer countConfirmedPromoCode(@Bind(value="id") int var1);

    @Query(value="select promo_code_use from promocode_count_all where promo_code_id = :id")
    public Integer countUsedPromoCode(@Bind(value="id") int var1);

    @Query(value="update promo_code set valid_to = :end where id = :id")
    public int updateEventPromoCodeEnd(@Bind(value="id") int var1, @Bind(value="end") ZonedDateTime var2);

    @Query(value="update promo_code set valid_from = :start, valid_to = :end, max_usage = :maxUsage, categories = :categories, description = :description, email_reference = :emailReference, hidden_category_id = :hiddenCategoryId where id = :id")
    public int updateEventPromoCode(@Bind(value="id") int var1, @Bind(value="start") ZonedDateTime var2, @Bind(value="end") ZonedDateTime var3, @Bind(value="maxUsage") Integer var4, @Bind(value="categories") String var5, @Bind(value="description") String var6, @Bind(value="emailReference") String var7, @Bind(value="hiddenCategoryId") Integer var8);

    @Query(value="select id from promo_code where code_type = 'ACCESS' and id = :id for update")
    public Integer lockAccessCodeForUpdate(@Bind(value="id") int var1);

    @Query(value="select * from promocode_usage_details where promo_code = :promoCode and (:eventId is null or :eventId = event_id)")
    public List<PromoCodeUsageResult> findDetailedUsage(@Bind(value="promoCode") String var1, @Bind(value="eventId") Integer var2);

    @Query(value="select id from promo_code where id = :id for update")
    public Integer lockForCount(@Bind(value="id") int var1);
}

