/*
 * Decompiled with CFR 0.152.
 */
package alfio.repository;

import alfio.model.AdditionalServiceFieldValue;
import alfio.model.Event;
import alfio.model.FieldNameAndValue;
import alfio.model.FieldValueAndDescription;
import alfio.model.PurchaseContext;
import alfio.model.PurchaseContextFieldConfiguration;
import alfio.model.PurchaseContextFieldDescription;
import alfio.model.PurchaseContextFieldValue;
import alfio.model.RestrictedValueStats;
import alfio.model.subscription.SubscriptionDescriptor;
import alfio.repository.FieldRepository;
import alfio.util.Json;
import alfio.util.MonetaryUtil;
import ch.digitalfondue.npjt.Bind;
import ch.digitalfondue.npjt.Query;
import ch.digitalfondue.npjt.QueryRepository;
import ch.digitalfondue.npjt.QueryType;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

@QueryRepository
public interface PurchaseContextFieldRepository
extends FieldRepository {
    public static final String INSERT_VALUE = "insert into purchase_context_field_value(ticket_id_fk, subscription_id_fk, organization_id_fk, field_configuration_id_fk, field_value, context) values (:ticketId, :subscriptionId::uuid, :organizationId, :fieldConfigurationId, :value, :context::ADDITIONAL_FIELD_CONTEXT)";
    public static final String ADDITIONAL_SERVICE_FIELD_VALUE_COLS = "field_name, field_value, additional_service_id_fk, ticket_id_fk, field_configuration_id_fk, additional_service_item_id_fk";
    public static final String FIELD_VALUE_COLUMNS = "ticket_id_fk, subscription_id_fk, additional_service_item_id_fk, field_configuration_id_fk, field_name, field_value, context";
    public static final String FIND_ALL = "select ticket_id_fk, subscription_id_fk, additional_service_item_id_fk, field_configuration_id_fk, field_name, field_value, context from field_value_w_additional";
    public static final String FIND_ALL_BY_TICKET_ID = "select ticket_id_fk, subscription_id_fk, additional_service_item_id_fk, field_configuration_id_fk, field_name, field_value, context from field_value_w_additional where ticket_id_fk = :ticketId";
    public static final String PURCHASE_CONTEXT_MATCHER = "(:eventId is null or event_id_fk = :eventId) and (:subscriptionId::uuid is null or subscription_descriptor_id_fk = :subscriptionId::uuid)";
    public static final String TICKET_ID_OR_SUBSCRIPTION_ID = "((:ticketId::integer is not null or :subscriptionId::uuid is not null) and (:ticketId::integer is null or ticket_id_fk = :ticketId) and (:subscriptionId::uuid is null or subscription_id_fk = :subscriptionId::uuid))";

    @Query(value="select count(*) from field_value_w_additional where ticket_id_fk = :ticketId and field_value is not null and field_value <> ''")
    public Integer countFilledOptionalData(@Bind(value="ticketId") int var1);

    @Query(value="select ticket_id_fk, subscription_id_fk, additional_service_item_id_fk, field_configuration_id_fk, field_name, field_value, context from field_value_w_additional where ticket_id_fk = :ticketId")
    public List<PurchaseContextFieldValue> findAllByTicketId(@Bind(value="ticketId") int var1);

    @Query(value="select ticket_id_fk, subscription_id_fk, additional_service_item_id_fk, field_configuration_id_fk, field_name, field_value, context from field_value_w_additional where ticket_id_fk = :ticketId and context = :context::ADDITIONAL_FIELD_CONTEXT")
    public List<PurchaseContextFieldValue> findAllForContextByTicketId(@Bind(value="ticketId") int var1, @Bind(value="context") PurchaseContextFieldConfiguration.Context var2);

    @Query(value="select ticket_id_fk, subscription_id_fk, additional_service_item_id_fk, field_configuration_id_fk, field_name, field_value, context, description from all_ticket_field_values  where ticket_id_fk = :ticketId and field_name in (:fieldNames)")
    public List<FieldValueAndDescription> findValueForTicketId(@Bind(value="ticketId") int var1, @Bind(value="fieldNames") Set<String> var2);

    @Query(value="update purchase_context_field_value set field_value = :value where ((:ticketId::integer is not null or :subscriptionId::uuid is not null) and (:ticketId::integer is null or ticket_id_fk = :ticketId) and (:subscriptionId::uuid is null or subscription_id_fk = :subscriptionId::uuid)) and field_configuration_id_fk = :fieldConfigurationId")
    public int updateValue(@Bind(value="ticketId") Integer var1, @Bind(value="subscriptionId") UUID var2, @Bind(value="fieldConfigurationId") long var3, @Bind(value="value") String var5);

    @Query(value="insert into purchase_context_field_value(ticket_id_fk, subscription_id_fk, organization_id_fk, field_configuration_id_fk, field_value, context) values (:ticketId, :subscriptionId::uuid, :organizationId, :fieldConfigurationId, :value, :context::ADDITIONAL_FIELD_CONTEXT)")
    public int insertValue(@Bind(value="ticketId") Integer var1, @Bind(value="subscriptionId") UUID var2, @Bind(value="organizationId") int var3, @Bind(value="fieldConfigurationId") long var4, @Bind(value="value") String var6, @Bind(value="context") PurchaseContextFieldConfiguration.Context var7);

    @Query(type=QueryType.TEMPLATE, value="insert into purchase_context_field_value(context, additional_service_item_id_fk, field_configuration_id_fk, field_value, organization_id_fk) values ('ADDITIONAL_SERVICE'::ADDITIONAL_FIELD_CONTEXT, :additionalServiceItemId, :fieldConfigurationId, :value, :organizationId)")
    public String batchInsertAdditionalItemsFields();

    @Query(value="delete from purchase_context_field_value where ((:ticketId::integer is not null or :subscriptionId::uuid is not null) and (:ticketId::integer is null or ticket_id_fk = :ticketId) and (:subscriptionId::uuid is null or subscription_id_fk = :subscriptionId::uuid)) and field_configuration_id_fk = :fieldConfigurationId")
    public int deleteValue(@Bind(value="ticketId") Integer var1, @Bind(value="subscriptionId") UUID var2, @Bind(value="fieldConfigurationId") long var3);

    @Query(value="delete from purchase_context_field_value where ticket_id_fk = :ticketId")
    public int deleteAllValuesForTicket(@Bind(value="ticketId") int var1);

    @Query(value="delete from purchase_context_field_value where ticket_id_fk in (:ticketIds)")
    public int deleteAllValuesForTicketIds(@Bind(value="ticketIds") List<Integer> var1);

    @Query(value="delete from purchase_context_field_value where subscription_id_fk = :subscriptionId")
    public int deleteAllValuesForSubscriptionId(@Bind(value="subscriptionId") UUID var1);

    @Query(value="delete from purchase_context_field_value fv using ticket t, additional_service_item ai where fv.context = 'ADDITIONAL_SERVICE' and fv.additional_service_item_id_fk = ai.id and ai.ticket_id_fk = t.id and t.id in (:ticketIds) and t.event_id = :eventId")
    public int deleteAllValuesForAdditionalItems(@Bind(value="ticketIds") Collection<Integer> var1, @Bind(value="eventId") int var2);

    @Query(value="delete from purchase_context_field_value fv using ticket t where t.id = fv.ticket_id_fk and t.tickets_reservation_id in(:reservationIds)")
    public int deleteAllTicketValuesForReservations(@Bind(value="reservationIds") List<String> var1);

    @Query(value="delete from purchase_context_field_value fv using additional_service_item asi where asi.id = fv.additional_service_item_id_fk and asi.tickets_reservation_uuid in(:reservationIds)")
    public int deleteAllAdditionalItemsValuesForReservations(@Bind(value="reservationIds") List<String> var1);

    @Query(value="delete from purchase_context_field_value fv using subscription s where s.id = fv.subscription_id_fk and s.reservation_id_fk in(:reservationIds)")
    public int deleteAllSubscriptionValuesForReservations(@Bind(value="reservationIds") List<String> var1);

    default public int deleteAllValuesForReservations(List<String> reservationIds) {
        return this.deleteAllTicketValuesForReservations(reservationIds) + this.deleteAllAdditionalItemsValuesForReservations(reservationIds) + this.deleteAllSubscriptionValuesForReservations(reservationIds);
    }

    @Query(value="select field_configuration_id_fk, field_locale, description, purchase_context_field_configuration.field_name as field_name from purchase_context_field_description inner join purchase_context_field_configuration on field_configuration_id_fk = id where field_locale = :locale and event_id_fk = :eventId")
    public List<PurchaseContextFieldDescription> findDescriptionsForLocale(@Bind(value="eventId") int var1, @Bind(value="locale") String var2);

    @Query(value="select field_configuration_id_fk, field_locale, description, purchase_context_field_configuration.field_name as field_name from purchase_context_field_description inner join purchase_context_field_configuration on field_configuration_id_fk = id where (:eventId is null or event_id_fk = :eventId) and (:subscriptionId::uuid is null or subscription_descriptor_id_fk = :subscriptionId::uuid)")
    public List<PurchaseContextFieldDescription> findAllDescriptions(@Bind(value="eventId") Integer var1, @Bind(value="subscriptionId") UUID var2);

    @Query(value="SELECT field_name FROM purchase_context_field_configuration inner join event on event.id = event_id_fk where short_name = :eventShortName order by field_order asc ")
    public List<String> findFieldsForEvent(@Bind(value="eventShortName") String var1);

    @Query(value="select field_name, field_value from field_value_w_additional where ticket_id_fk = :ticketId")
    public List<FieldNameAndValue> findNameAndValue(@Bind(value="ticketId") int var1);

    @Query(value="select field_name, field_value from field_value_w_additional where subscription_id_fk = :subscriptionId")
    public List<FieldNameAndValue> findNameAndValue(@Bind(value="subscriptionId") UUID var1);

    @Query(value="select ticket_id_fk, subscription_id_fk, additional_service_item_id_fk, field_configuration_id_fk, field_name, field_value, context from field_value_w_additional where ticket_id_fk in (:ticketIds)")
    public List<PurchaseContextFieldValue> findAllValuesByTicketIds(@Bind(value="ticketIds") Collection<Integer> var1);

    @Query(value="select ticket_id_fk, subscription_id_fk, additional_service_item_id_fk, field_configuration_id_fk, field_name, field_value, context from field_value_w_additional where subscription_id_fk in (:subscriptionIds)")
    public List<PurchaseContextFieldValue> findAllValuesBySubscriptionIds(@Bind(value="subscriptionIds") Collection<UUID> var1);

    default public void updateOrInsert(Map<String, List<String>> values, PurchaseContext purchaseContext, Integer ticketId, UUID subscriptionId) {
        Map toUpdate;
        List additionalFields;
        values = Optional.ofNullable(values).orElseGet(Collections::emptyMap);
        if (purchaseContext instanceof Event) {
            Event event = (Event)purchaseContext;
            additionalFields = this.findAdditionalFieldsForEvent(event.getId());
            toUpdate = this.findAllByTicketIdGroupedByName(ticketId, event.supportsLinkedAdditionalServices());
        } else {
            additionalFields = this.findAdditionalFieldsForSubscriptionDescriptor(((SubscriptionDescriptor)purchaseContext).getId());
            toUpdate = this.collectByName(this.findAllValuesBySubscriptionIds(List.of(subscriptionId)));
        }
        Set readOnlyFields = additionalFields.stream().filter(PurchaseContextFieldConfiguration::isReadOnly).map(PurchaseContextFieldConfiguration::getName).collect(Collectors.toSet());
        Map<String, Long> fieldNameToId = additionalFields.stream().collect(Collectors.toMap(PurchaseContextFieldConfiguration::getName, PurchaseContextFieldConfiguration::getId));
        values.forEach((fieldName, fieldValues) -> {
            String fieldValue = this.getFieldValueJson(fieldValues);
            boolean isNotBlank = StringUtils.isNotBlank((CharSequence)fieldValue);
            if (toUpdate.containsKey(fieldName)) {
                if (!readOnlyFields.contains(fieldName)) {
                    PurchaseContextFieldValue field = (PurchaseContextFieldValue)toUpdate.get(fieldName);
                    if (isNotBlank) {
                        this.updateValue(field.getTicketId(), field.getSubscriptionId(), field.getFieldConfigurationId(), fieldValue);
                    } else {
                        this.deleteValue(field.getTicketId(), field.getSubscriptionId(), field.getFieldConfigurationId());
                    }
                }
            } else if (fieldNameToId.containsKey(fieldName) && isNotBlank) {
                PurchaseContextFieldConfiguration.Context context = ticketId != null ? PurchaseContextFieldConfiguration.Context.ATTENDEE : PurchaseContextFieldConfiguration.Context.SUBSCRIPTION;
                this.insertValue(ticketId, subscriptionId, purchaseContext.getOrganizationId(), ((Long)fieldNameToId.get(fieldName)).longValue(), fieldValue, context);
            }
        });
    }

    default public String getFieldValueJson(List<String> fieldValues) {
        String fieldValue = fieldValues.size() == 1 ? fieldValues.get(0) : (fieldValues.stream().anyMatch(StringUtils::isNotBlank) ? Json.toJson(fieldValues) : "");
        return fieldValue;
    }

    default public Map<String, PurchaseContextFieldValue> findAllByTicketIdGroupedByName(Integer id, boolean eventSupportsLink) {
        List values = eventSupportsLink ? this.findAllForContextByTicketId(id.intValue(), PurchaseContextFieldConfiguration.Context.ATTENDEE) : this.findAllByTicketId(id.intValue());
        return this.collectByName(values);
    }

    private Map<String, PurchaseContextFieldValue> collectByName(List<PurchaseContextFieldValue> values) {
        return values.stream().collect(Collectors.toMap(PurchaseContextFieldValue::getName, Function.identity()));
    }

    default public boolean hasOptionalData(int ticketId) {
        return this.countFilledOptionalData(ticketId) > 0;
    }

    @Query(value="select * from purchase_context_field_configuration where event_id_fk = :eventId order by field_order asc")
    public List<PurchaseContextFieldConfiguration> findAdditionalFieldsForEvent(@Bind(value="eventId") int var1);

    default public Map<Integer, Set<String>> findAdditionalFieldNamesForEvents(Collection<Integer> eventIds) {
        return (Map)this.getJdbcTemplate().query("select event_id_fk, field_name from purchase_context_field_configuration where event_id_fk = :eventIds", (SqlParameterSource)new MapSqlParameterSource("eventIds", eventIds), rs -> {
            HashMap result = new HashMap();
            while (rs.next()) {
                Integer eventId = rs.getInt(1);
                if (!result.containsKey(eventId)) {
                    result.put(eventId, new HashSet());
                }
                ((Set)result.get(eventId)).add(rs.getString(2));
            }
            return result;
        });
    }

    @Query(value="select * from purchase_context_field_configuration where subscription_descriptor_id_fk = :subscriptionId::uuid order by field_order asc")
    public List<PurchaseContextFieldConfiguration> findAdditionalFieldsForSubscriptionDescriptor(@Bind(value="subscriptionId") UUID var1);

    @Query(value="select * from purchase_context_field_configuration where event_id_fk = :eventId and field_type = :type order by field_order asc")
    public List<PurchaseContextFieldConfiguration> findAdditionalFieldsOfTypeForEvent(@Bind(value="eventId") int var1, @Bind(value="type") String var2);

    @Query(value="select * from purchase_context_field_configuration where id = :id")
    public PurchaseContextFieldConfiguration findById(@Bind(value="id") long var1);

    @Query(value="update purchase_context_field_configuration set field_order = :order where id = :id")
    public int updateFieldOrder(@Bind(value="id") long var1, @Bind(value="order") int var3);

    @Query(value="select purchase_context_field_configuration.* from purchase_context_field_configuration inner join event on event.id = event_id_fk where short_name = :eventShortName order by field_order asc")
    public List<PurchaseContextFieldConfiguration> findAdditionalFieldsForEvent(@Bind(value="eventShortName") String var1);

    @Query(value="select count(*) from purchase_context_field_configuration where event_id_fk = :eventId")
    public Integer countAdditionalFieldsForEvent(@Bind(value="eventId") int var1);

    @Query(value="select max(field_order) from purchase_context_field_configuration where (:eventId is null or event_id_fk = :eventId) and (:subscriptionId::uuid is null or subscription_descriptor_id_fk = :subscriptionId::uuid)")
    public Integer findMaxOrderValue(@Bind(value="eventId") Integer var1, @Bind(value="subscriptionId") UUID var2);

    default public Map<Long, PurchaseContextFieldDescription> findTranslationsFor(Locale locale, int eventId) {
        return this.findDescriptionsForLocale(eventId, locale.getLanguage()).stream().collect(Collectors.toMap(PurchaseContextFieldDescription::getFieldConfigurationId, Function.identity()));
    }

    default public Map<String, String> findAllValuesForTicketId(int ticketId) {
        return this.findNameAndValue(ticketId).stream().filter(t -> t.getName() != null && t.getValue() != null).collect(Collectors.toMap(FieldNameAndValue::getName, FieldNameAndValue::getValue));
    }

    @Query(value="delete from purchase_context_field_value where field_configuration_id_fk = :fieldConfigurationId")
    public int deleteValues(@Bind(value="fieldConfigurationId") long var1);

    @Query(value="delete from purchase_context_field_description where field_configuration_id_fk = :fieldConfigurationId")
    public int deleteDescription(@Bind(value="fieldConfigurationId") long var1);

    @Query(value="delete from purchase_context_field_configuration where id = :fieldConfigurationId")
    public int deleteField(@Bind(value="fieldConfigurationId") long var1);

    @Query(value="select field_value as name, count(*) as count from field_value_w_additional where field_configuration_id_fk = :configurationId group by field_value")
    public List<RestrictedValueStats.RestrictedValueCount> getValueStats(@Bind(value="configurationId") long var1);

    default public List<RestrictedValueStats> retrieveStats(long configurationId) {
        PurchaseContextFieldConfiguration configuration = this.findById(configurationId);
        Map<String, Integer> valueStats = this.getValueStats(configurationId).stream().collect(Collectors.toMap(RestrictedValueStats.RestrictedValueCount::getName, RestrictedValueStats.RestrictedValueCount::getCount));
        int total = valueStats.values().stream().mapToInt(i -> i).sum();
        if (configuration.isCountryField()) {
            Comparator descComparator = Map.Entry.comparingByValue().reversed();
            return valueStats.entrySet().stream().sorted(descComparator).map(entry -> {
                int count = (Integer)entry.getValue();
                return new RestrictedValueStats((String)entry.getKey(), count, new BigDecimal(count).divide(new BigDecimal(total), 2, RoundingMode.HALF_UP).multiply(MonetaryUtil.HUNDRED).intValue());
            }).collect(Collectors.toList());
        }
        return configuration.getRestrictedValues().stream().map(name -> {
            int count = valueStats.getOrDefault(name, 0);
            return new RestrictedValueStats(name, count, total == 0 ? 0 : new BigDecimal(count).divide(new BigDecimal(total), 2, RoundingMode.HALF_UP).multiply(MonetaryUtil.HUNDRED).intValue());
        }).collect(Collectors.toList());
    }

    @Query(value="select field_name, field_value, additional_service_id_fk, ticket_id_fk, field_configuration_id_fk, additional_service_item_id_fk from additional_item_field_value_with_ticket_id  where ticket_id_fk = :ticketId  and additional_service_id_fk in (:additionalServiceIds)")
    public List<AdditionalServiceFieldValue> loadTicketFieldsForAdditionalService(@Bind(value="ticketId") int var1, @Bind(value="additionalServiceIds") List<Integer> var2);

    @Query(value="select field_name, field_value, additional_service_id_fk, ticket_id_fk, field_configuration_id_fk, additional_service_item_id_fk from additional_item_field_value_with_ticket_id where ticket_id_fk in(:ticketIds)")
    public List<AdditionalServiceFieldValue> findAdditionalServicesValueByTicketIds(@Bind(value="ticketIds") List<Integer> var1);

    @Query(value="select field_name, field_value, additional_service_id_fk, ticket_id_fk, field_configuration_id_fk, additional_service_item_id_fk from additional_item_field_value_with_ticket_id where additional_service_item_id_fk in (:itemIds)")
    public List<AdditionalServiceFieldValue> findAdditionalServicesValueByItemIds(@Bind(value="itemIds") List<Integer> var1);

    @Query(value="select count(*) from purchase_context_field_configuration where id in (:additionalFieldIds) and (:eventId is null or event_id_fk = :eventId) and (:subscriptionId::uuid is null or subscription_descriptor_id_fk = :subscriptionId::uuid)")
    public int countMatchingAdditionalFieldsForPurchaseContext(@Bind(value="eventId") Integer var1, @Bind(value="subscriptionId") UUID var2, @Bind(value="additionalFieldIds") Set<Long> var3);

    public NamedParameterJdbcTemplate getJdbcTemplate();
}

