/*
 * Decompiled with CFR 0.152.
 */
package alfio.repository;

import alfio.model.SpecialPrice;
import alfio.model.TicketCategory;
import ch.digitalfondue.npjt.Bind;
import ch.digitalfondue.npjt.Query;
import ch.digitalfondue.npjt.QueryRepository;
import ch.digitalfondue.npjt.QueryType;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

@QueryRepository
public interface SpecialPriceRepository {
    public static final String IS_FREE = " status = 'FREE' and recipient_name is null and recipient_email is null and access_code_id_fk is null";
    public static final String SELECT_FREE = "select * from special_price where ticket_category_id = :ticketCategoryId and  status = 'FREE' and recipient_name is null and recipient_email is null and access_code_id_fk is null";

    @Query(value="select * from special_price where ticket_category_id = :ticketCategoryId")
    public List<SpecialPrice> findAllByCategoryId(@Bind(value="ticketCategoryId") int var1);

    @Query(value="select * from special_price where ticket_category_id in (:ticketCategoryIds)")
    public List<SpecialPrice> findAllByCategoriesIds(@Bind(value="ticketCategoryIds") Collection<Integer> var1);

    @Query(value="select * from special_price where ticket_category_id = :ticketCategoryId and  status = 'FREE' and recipient_name is null and recipient_email is null and access_code_id_fk is null for update skip locked limit :limitTo")
    public List<SpecialPrice> findActiveByCategoryIdForUpdate(@Bind(value="ticketCategoryId") int var1, @Bind(value="limitTo") int var2);

    @Query(value="select * from special_price where ticket_category_id = :ticketCategoryId and  status = 'FREE' and recipient_name is null and recipient_email is null and access_code_id_fk is null limit :limitTo for update skip locked")
    public List<SpecialPrice> findActiveNotAssignedByCategoryId(@Bind(value="ticketCategoryId") int var1, @Bind(value="limitTo") int var2);

    @Query(value="select count(*) from special_price where ticket_category_id = :ticketCategoryId and  status = 'FREE' and recipient_name is null and recipient_email is null and access_code_id_fk is null")
    public Integer countFreeTokens(@Bind(value="ticketCategoryId") int var1);

    @Query(type=QueryType.MODIFYING_WITH_RETURN, value="update special_price set access_code_id_fk = :accessCodeId where id in (select id from special_price where ticket_category_id = :ticketCategoryId and  status = 'FREE' and recipient_name is null and recipient_email is null and access_code_id_fk is null and access_code_id_fk is null limit :limitTo) returning *")
    public List<SpecialPrice> bindToAccessCode(@Bind(value="ticketCategoryId") int var1, @Bind(value="accessCodeId") int var2, @Bind(value="limitTo") int var3);

    @Query(value="update special_price set sent_ts = :timestamp, recipient_name = :recipientName, recipient_email = :recipientAddress where code = :code")
    public int markAsSent(@Bind(value="timestamp") ZonedDateTime var1, @Bind(value="recipientName") String var2, @Bind(value="recipientAddress") String var3, @Bind(value="code") String var4);

    @Query(value="update special_price set sent_ts = null, recipient_name = null, recipient_email = null where id = :id and ticket_category_id = :ticketCategoryId")
    public int clearRecipientData(@Bind(value="id") int var1, @Bind(value="ticketCategoryId") int var2);

    @Query(value="select * from special_price where code = :code")
    public Optional<SpecialPrice> getByCode(@Bind(value="code") String var1);

    @Query(value="select * from special_price where code = :code for update skip locked")
    public Optional<SpecialPrice> getForUpdateByCode(@Bind(value="code") String var1);

    @Query(value="select count(*) from special_price where code = :code")
    public Integer countByCode(@Bind(value="code") String var1);

    @Query(value="update special_price set status = :status, session_id = null, access_code_id_fk = :accessCodeId where id in (:ids)")
    public int batchUpdateStatus(@Bind(value="ids") List<Integer> var1, @Bind(value="status") SpecialPrice.Status var2, @Bind(value="accessCodeId") Integer var3);

    @Query(value="update special_price set status = :status, session_id = :sessionId, access_code_id_fk = :accessCodeId where id = :id")
    public int updateStatus(@Bind(value="id") int var1, @Bind(value="status") String var2, @Bind(value="sessionId") String var3, @Bind(value="accessCodeId") Integer var4);

    @Query(value="update special_price set status = :status where id in (select special_price_id_fk from ticket where tickets_reservation_id in (:reservationIds) and special_price_id_fk is not null)")
    public int updateStatusForReservation(@Bind(value="reservationIds") List<String> var1, @Bind(value="status") String var2);

    @Query(value="update special_price set status = 'FREE', session_id = null, sent_ts = null, recipient_name = null, recipient_email = null, access_code_id_fk = null where id in (select special_price_id_fk from ticket where tickets_reservation_id in (:reservationIds) and special_price_id_fk is not null)")
    public int resetToFreeAndCleanupForReservation(@Bind(value="reservationIds") List<String> var1);

    @Query(value="update special_price set status = 'FREE', session_id = null, sent_ts = null, recipient_name = null, recipient_email = null, access_code_id_fk = null  where id in (select special_price_id_fk from ticket where ticket.id in (:ticketIds) and special_price_id_fk is not null) ")
    public int resetToFreeAndCleanupForTickets(@Bind(value="ticketIds") List<Integer> var1);

    @Query(value="update special_price set code = :code, status = 'FREE', sent_ts = null where id = :id")
    public int updateCode(@Bind(value="code") String var1, @Bind(value="id") int var2);

    public NamedParameterJdbcTemplate getNamedParameterJdbcTemplate();

    default public void bulkInsert(TicketCategory ticketCategory, int requiredTokens) {
        MapSqlParameterSource[] params = (MapSqlParameterSource[])Stream.generate(MapSqlParameterSource::new).limit(requiredTokens).peek(ps -> {
            ps.addValue("code", (Object)UUID.randomUUID().toString());
            ps.addValue("priceInCents", (Object)ticketCategory.getSrcPriceCts());
            ps.addValue("ticketCategoryId", (Object)ticketCategory.getId());
            ps.addValue("status", (Object)SpecialPrice.Status.WAITING.name());
        }).toArray(MapSqlParameterSource[]::new);
        this.getNamedParameterJdbcTemplate().batchUpdate("insert into special_price (code, price_cts, ticket_category_id, status, sent_ts) values(:code, :priceInCents, :ticketCategoryId, :status, null)", (SqlParameterSource[])params);
    }

    @Query(value="update special_price set status = 'CANCELLED' where ticket_category_id = :categoryId and status in ('FREE', 'WAITING')")
    public int cancelExpiredTokens(@Bind(value="categoryId") int var1);

    @Query(value="select id from special_price where ticket_category_id = :categoryId and status in ('FREE', 'WAITING') and sent_ts is null limit :limit for update")
    public List<Integer> lockNotSentTokens(@Bind(value="categoryId") int var1, @Bind(value="limit") int var2);

    @Query(value="select count(id) from special_price where ticket_category_id = :categoryId and status in ('FREE', 'WAITING') and sent_ts is null")
    public Integer countNotSentToken(@Bind(value="categoryId") int var1);

    @Query(value="update special_price set status = 'CANCELLED' where id in (:ids)")
    public int cancelTokens(@Bind(value="ids") List<Integer> var1);

    @Query(value="select id, ticket_category_id from special_price where status = 'WAITING' for update skip locked")
    public List<SpecialPrice.SpecialPriceTicketCategoryId> findWaitingElements();

    @Query(value="select id, ticket_category_id from special_price where status = 'WAITING' and ticket_category_id = :categoryId for update skip locked")
    public List<SpecialPrice.SpecialPriceTicketCategoryId> findWaitingElementsForCategory(@Bind(value="categoryId") int var1);

    default public Map<Integer, List<SpecialPrice>> findAllByCategoriesIdsMapped(Collection<Integer> ticketCategoriesIds) {
        if (ticketCategoriesIds.isEmpty()) {
            return Collections.emptyMap();
        }
        return this.findAllByCategoriesIds(ticketCategoriesIds).stream().collect(Collectors.groupingBy(SpecialPrice::getTicketCategoryId));
    }
}

