/*
 * Decompiled with CFR 0.152.
 */
package alfio.repository;

import alfio.model.DetailedScanData;
import alfio.model.SponsorScan;
import ch.digitalfondue.npjt.Bind;
import ch.digitalfondue.npjt.Query;
import ch.digitalfondue.npjt.QueryRepository;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Optional;

@QueryRepository
public interface SponsorScanRepository {
    public static final ZonedDateTime DEFAULT_TIMESTAMP = ZonedDateTime.ofInstant(Instant.EPOCH, ZoneOffset.UTC);

    @Query(value="select creation from sponsor_scan where user_id = :userId and event_id = :eventId and ticket_id = :ticketId and operator = :operator")
    public Optional<ZonedDateTime> getRegistrationTimestamp(@Bind(value="userId") int var1, @Bind(value="eventId") int var2, @Bind(value="ticketId") int var3, @Bind(value="operator") String var4);

    @Query(value="insert into sponsor_scan (user_id, creation, event_id, ticket_id, notes, lead_status, operator) values(:userId, :creation, :eventId, :ticketId, :notes, :leadStatus, :operator)")
    public int insert(@Bind(value="userId") int var1, @Bind(value="creation") ZonedDateTime var2, @Bind(value="eventId") int var3, @Bind(value="ticketId") int var4, @Bind(value="notes") String var5, @Bind(value="leadStatus") SponsorScan.LeadStatus var6, @Bind(value="operator") String var7);

    @Query(value="update sponsor_scan set notes = :notes, lead_status = :leadStatus where user_id = :userId and event_id = :eventId and ticket_id = :ticketId and operator = :operator")
    public int updateNotesAndLeadStatus(@Bind(value="userId") int var1, @Bind(value="eventId") int var2, @Bind(value="ticketId") int var3, @Bind(value="notes") String var4, @Bind(value="leadStatus") SponsorScan.LeadStatus var5, @Bind(value="operator") String var6);

    @Query(value="select t.id t_id, t.uuid t_uuid, t.public_uuid t_public_uuid, t.creation t_creation, t.category_id t_category_id, t.status t_status, t.event_id t_event_id, t.src_price_cts t_src_price_cts, t.final_price_cts t_final_price_cts, t.vat_cts t_vat_cts, t.discount_cts t_discount_cts, t.tickets_reservation_id t_tickets_reservation_id, t.full_name t_full_name, t.first_name t_first_name, t.last_name t_last_name, t.email_address t_email_address, t.locked_assignment t_locked_assignment, t.user_language t_user_language, t.ext_reference t_ext_reference, t.currency_code t_currency_code, t.tags t_tags, t.subscription_id_fk t_subscription_id, t.vat_status t_vat_status, s.user_id s_user_id, s.creation s_creation, s.event_id s_event_id, s.ticket_id s_ticket_id, s.notes s_notes, s.lead_status s_lead_status, s.operator s_operator,  (case when s.lead_status = 'HOT' then 2 when s.lead_status = 'WARM' then 1 else 0 end) as priority from sponsor_scan s, ticket t where s.event_id = :eventId and s.user_id = :userId and s.creation > :start and s.ticket_id = t.id order by priority desc, s.creation")
    public List<DetailedScanData> loadSponsorData(@Bind(value="eventId") int var1, @Bind(value="userId") int var2, @Bind(value="start") ZonedDateTime var3);
}

