/*
 * Decompiled with CFR 0.152.
 */
package alfio.repository;

import alfio.model.AllocationStatus;
import alfio.model.DescriptorIdAndReservationId;
import alfio.model.PriceContainer;
import alfio.model.metadata.SubscriptionMetadata;
import alfio.model.modification.SubscriptionDescriptorModification;
import alfio.model.subscription.AvailableSubscriptionsByEvent;
import alfio.model.subscription.EventSubscriptionLink;
import alfio.model.subscription.Subscription;
import alfio.model.subscription.SubscriptionDescriptor;
import alfio.model.subscription.SubscriptionDescriptorWithStatistics;
import alfio.model.support.Array;
import alfio.model.support.JSONData;
import alfio.model.transaction.PaymentProxy;
import ch.digitalfondue.npjt.Bind;
import ch.digitalfondue.npjt.Query;
import ch.digitalfondue.npjt.QueryRepository;
import ch.digitalfondue.npjt.QueryType;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

/*
 * Exception performing whole class analysis ignored.
 */
@QueryRepository
public interface SubscriptionRepository {
    public static final Logger log = LoggerFactory.getLogger(SubscriptionRepository.class);
    public static final String FETCH_SUBSCRIPTION_LINK = "select sd.id subscription_descriptor_id, sd.title subscription_descriptor_title, e.id event_id, e.short_name event_short_name, e.display_name event_display_name, e.currency event_currency, se.price_per_ticket price_per_ticket, se.compatible_categories compatible_categories from subscription_event se join event e on e.id = se.event_id_fk and e.org_id = :organizationId join subscription_descriptor sd on sd.id = se.subscription_descriptor_id_fk and sd.organization_id_fk = :organizationId";
    public static final String INSERT_SUBSCRIPTION_LINK = "insert into subscription_event(event_id_fk, subscription_descriptor_id_fk, price_per_ticket, organization_id_fk, compatible_categories) values(:eventId, :subscriptionId, :pricePerTicket, :organizationId, :compatibleCategories::json) on conflict(subscription_descriptor_id_fk, event_id_fk) do update set price_per_ticket = excluded.price_per_ticket, compatible_categories = excluded.compatible_categories\n";
    public static final String INSERT_SUBSCRIPTION = "insert into subscription(id, subscription_descriptor_fk, reservation_id_fk, max_usage,  valid_from, valid_to,  organization_id_fk, status, src_price_cts, currency, max_entries, time_zone)  values (:id, :subscriptionDescriptorId, :reservationId, :maxUsage, :validFrom, :validTo, :organizationId, :status::ALLOCATION_STATUS,  :srcPriceCts, :currency, :maxEntries, :timeZone)";

    @Query(value="insert into subscription_descriptor (id, title, description, max_available, on_sale_from, on_sale_to, price_cts, vat, vat_status, currency, is_public, organization_id_fk,  max_entries, validity_type, validity_time_unit, validity_units, validity_from, validity_to, usage_type, terms_conditions_url, privacy_policy_url, file_blob_id_fk, allowed_payment_proxies, private_key, time_zone, supports_tickets_generation, status)  values(:id, :title::jsonb, :description::jsonb, :maxAvailable, :onSaleFrom, :onSaleTo, :priceCts, :vat, :vatStatus::VAT_STATUS, :currency,  :isPublic, :organizationId, :maxEntries, :validityType::SUBSCRIPTION_VALIDITY_TYPE, :validityTimeUnit::SUBSCRIPTION_TIME_UNIT,  :validityUnits, :validityFrom, :validityTo, :usageType::SUBSCRIPTION_USAGE_TYPE, :tcUrl, :privacyPolicyUrl, :fileBlobId, :allowedPaymentProxies::text[], :privateKey, :timeZone, :supportsTicketsGeneration, 'ACTIVE')")
    public int createSubscriptionDescriptor(@Bind(value="id") UUID var1, @Bind(value="title") @JSONData Map<String, String> var2, @Bind(value="description") @JSONData Map<String, String> var3, @Bind(value="maxAvailable") int var4, @Bind(value="onSaleFrom") ZonedDateTime var5, @Bind(value="onSaleTo") ZonedDateTime var6, @Bind(value="priceCts") int var7, @Bind(value="vat") BigDecimal var8, @Bind(value="vatStatus") PriceContainer.VatStatus var9, @Bind(value="currency") String var10, @Bind(value="isPublic") boolean var11, @Bind(value="organizationId") int var12, @Bind(value="maxEntries") int var13, @Bind(value="validityType") SubscriptionDescriptor.SubscriptionValidityType var14, @Bind(value="validityTimeUnit") SubscriptionDescriptor.SubscriptionTimeUnit var15, @Bind(value="validityUnits") Integer var16, @Bind(value="validityFrom") ZonedDateTime var17, @Bind(value="validityTo") ZonedDateTime var18, @Bind(value="usageType") SubscriptionDescriptor.SubscriptionUsageType var19, @Bind(value="tcUrl") String var20, @Bind(value="privacyPolicyUrl") String var21, @Bind(value="fileBlobId") String var22, @Bind(value="allowedPaymentProxies") @Array List<PaymentProxy> var23, @Bind(value="privateKey") String var24, @Bind(value="timeZone") String var25, @Bind(value="supportsTicketsGeneration") boolean var26);

    @Query(value="update subscription_descriptor set title = :title::jsonb, description = :description::jsonb, max_available = :maxAvailable, on_sale_from = :onSaleFrom, on_sale_to = :onSaleTo, price_cts = :priceCts, vat = :vat, vat_status = :vatStatus::VAT_STATUS,  currency = :currency, is_public = :isPublic, max_entries = :maxEntries, validity_type = :validityType::SUBSCRIPTION_VALIDITY_TYPE, validity_time_unit = :validityTimeUnit::SUBSCRIPTION_TIME_UNIT, validity_units = :validityUnits, validity_from = :validityFrom, validity_to = :validityTo, usage_type = :usageType::SUBSCRIPTION_USAGE_TYPE, terms_conditions_url = :tcUrl, privacy_policy_url = :privacyPolicyUrl, file_blob_id_fk = :fileBlobId, allowed_payment_proxies = :allowedPaymentProxies::text[], time_zone = :timeZone, supports_tickets_generation = :supportsTicketsGeneration  where id = :id and organization_id_fk = :organizationId")
    public int updateSubscriptionDescriptor(@Bind(value="title") @JSONData Map<String, String> var1, @Bind(value="description") @JSONData Map<String, String> var2, @Bind(value="maxAvailable") int var3, @Bind(value="onSaleFrom") ZonedDateTime var4, @Bind(value="onSaleTo") ZonedDateTime var5, @Bind(value="priceCts") int var6, @Bind(value="vat") BigDecimal var7, @Bind(value="vatStatus") PriceContainer.VatStatus var8, @Bind(value="currency") String var9, @Bind(value="isPublic") boolean var10, @Bind(value="maxEntries") int var11, @Bind(value="validityType") SubscriptionDescriptor.SubscriptionValidityType var12, @Bind(value="validityTimeUnit") SubscriptionDescriptor.SubscriptionTimeUnit var13, @Bind(value="validityUnits") Integer var14, @Bind(value="validityFrom") ZonedDateTime var15, @Bind(value="validityTo") ZonedDateTime var16, @Bind(value="usageType") SubscriptionDescriptor.SubscriptionUsageType var17, @Bind(value="tcUrl") String var18, @Bind(value="privacyPolicyUrl") String var19, @Bind(value="fileBlobId") String var20, @Bind(value="allowedPaymentProxies") @Array List<PaymentProxy> var21, @Bind(value="id") UUID var22, @Bind(value="organizationId") int var23, @Bind(value="timeZone") String var24, @Bind(value="supportsTicketsGeneration") boolean var25);

    @Query(value="update subscription_descriptor set is_public = :isPublic where id = :id and organization_id_fk = :organizationId")
    public int setPublicStatus(@Bind(value="id") UUID var1, @Bind(value="organizationId") int var2, @Bind(value="isPublic") boolean var3);

    @Query(value="update subscription_descriptor set status = 'NOT_ACTIVE' where id = :id and organization_id_fk = :organizationId")
    public int deactivateDescriptor(@Bind(value="id") UUID var1, @Bind(value="organizationId") int var2);

    @Query(value="select * from subscription_descriptor where organization_id_fk = :organizationId and status = 'ACTIVE' order by on_sale_from, on_sale_to nulls last")
    public List<SubscriptionDescriptor> findAllByOrganizationIds(@Bind(value="organizationId") int var1);

    @Query(value="select subscription_descriptor.* from subscription_descriptor join organization org on subscription_descriptor.organization_id_fk = org.id  where status = 'ACTIVE' and is_public = true and (max_entries > 0 or max_entries = -1) and (on_sale_from is null or :from >= on_sale_from)  and (on_sale_to is null or :from <= on_sale_to) and (:orgSlug is null or org.slug = :orgSlug) order by on_sale_from, on_sale_to nulls last")
    public List<SubscriptionDescriptor> findAllActiveAndPublic(@Bind(value="from") ZonedDateTime var1, @Bind(value="orgSlug") String var2);

    @Query(value="select * from subscription_descriptor where status = 'ACTIVE' and id = :id and organization_id_fk = :organizationId")
    public Optional<SubscriptionDescriptor> findOne(@Bind(value="id") UUID var1, @Bind(value="organizationId") int var2);

    @Query(value="select * from subscription_descriptor where id = :id and status = 'ACTIVE'")
    public Optional<SubscriptionDescriptor> findOne(@Bind(value="id") UUID var1);

    @Query(value="select organization_id_fk from subscription_descriptor where status = 'ACTIVE' and id = :id")
    public Optional<Integer> findOrganizationIdForDescriptor(@Bind(value="id") UUID var1);

    @Query(value="select count(*) from subscription_descriptor where status = 'ACTIVE' and id in(:ids) and organization_id_fk = :organizationId")
    public Integer countDescriptorsBelongingToOrganization(@Bind(value="ids") Collection<UUID> var1, @Bind(value="organizationId") int var2);

    @Query(value="select * from subscription_descriptor where id = (select subscription_descriptor_fk from subscription where reservation_id_fk = :reservationId) and status = 'ACTIVE'")
    public Optional<SubscriptionDescriptor> findDescriptorByReservationId(@Bind(value="reservationId") String var1);

    @Query(value="select tr.id as reservation_id, sd.id as descriptor_id, sd.max_available as max_available\n    from tickets_reservation tr\n    join subscription s on s.reservation_id_fk = tr.id\n    join subscription_descriptor sd on s.subscription_descriptor_fk = sd.id\nwhere tr.id in (:ids)\n")
    public List<DescriptorIdAndReservationId> findDescriptorsByReservationIds(@Bind(value="ids") Collection<String> var1);

    @Query(value="select * from subscription_descriptor where id in (:ids)")
    public List<SubscriptionDescriptor> findByIds(@Bind(value="ids") Set<UUID> var1);

    @Query(value="select * from subscription_descriptor where id = (select subscription_descriptor_fk from subscription where id = :id) and status = 'ACTIVE'")
    public SubscriptionDescriptor findDescriptorBySubscriptionId(@Bind(value="id") UUID var1);

    @Query(value="select organization_id_fk from subscription_descriptor where id = (select subscription_descriptor_fk from subscription where id = :id) and status = 'ACTIVE'")
    public Optional<Integer> findOrganizationIdForSubscription(@Bind(value="id") UUID var1);

    @Query(value="select * from subscription_descriptor_statistics where sd_organization_id_fk = :organizationId")
    public List<SubscriptionDescriptorWithStatistics> findAllWithStatistics(@Bind(value="organizationId") int var1);

    @Query(value="select * from subscription_descriptor_statistics where sd_organization_id_fk = :organizationId and sd_id = :subscriptionDescriptorId")
    public Optional<SubscriptionDescriptorWithStatistics> findOneWithStatistics(@Bind(value="subscriptionDescriptorId") UUID var1, @Bind(value="organizationId") int var2);

    @Query(value="select exists (select 1 from subscription_event where event_id_fk = :eventId and subscription_descriptor_id_fk = :subscriptionDescriptorId::uuid and organization_id_fk = :organizationId)")
    public boolean isSubscriptionLinkedToEvent(@Bind(value="eventId") int var1, @Bind(value="subscriptionDescriptorId") UUID var2, @Bind(value="organizationId") int var3);

    @Query(value="insert into subscription_event(event_id_fk, subscription_descriptor_id_fk, price_per_ticket, organization_id_fk, compatible_categories) values(:eventId, :subscriptionId, :pricePerTicket, :organizationId, :compatibleCategories::json) on conflict(subscription_descriptor_id_fk, event_id_fk) do update set price_per_ticket = excluded.price_per_ticket, compatible_categories = excluded.compatible_categories\n")
    public int linkSubscriptionAndEvent(@Bind(value="subscriptionId") UUID var1, @Bind(value="eventId") int var2, @Bind(value="pricePerTicket") int var3, @Bind(value="organizationId") int var4, @Bind(value="compatibleCategories") @JSONData List<Integer> var5);

    @Query(type=QueryType.TEMPLATE, value="insert into subscription_event(event_id_fk, subscription_descriptor_id_fk, price_per_ticket, organization_id_fk, compatible_categories) values(:eventId, :subscriptionId, :pricePerTicket, :organizationId, :compatibleCategories::json) on conflict(subscription_descriptor_id_fk, event_id_fk) do update set price_per_ticket = excluded.price_per_ticket, compatible_categories = excluded.compatible_categories\n")
    public String insertSubscriptionEventLink();

    @Query(value="select sd.id subscription_descriptor_id, sd.title subscription_descriptor_title, e.id event_id, e.short_name event_short_name, e.display_name event_display_name, e.currency event_currency, se.price_per_ticket price_per_ticket, se.compatible_categories compatible_categories from subscription_event se join event e on e.id = se.event_id_fk and e.org_id = :organizationId join subscription_descriptor sd on sd.id = se.subscription_descriptor_id_fk and sd.organization_id_fk = :organizationId where se.subscription_descriptor_id_fk = :subscriptionId")
    public List<EventSubscriptionLink> findLinkedEvents(@Bind(value="organizationId") int var1, @Bind(value="subscriptionId") UUID var2);

    @Query(value="select sd.id subscription_descriptor_id, sd.title subscription_descriptor_title, e.id event_id, e.short_name event_short_name, e.display_name event_display_name, e.currency event_currency, se.price_per_ticket price_per_ticket, se.compatible_categories compatible_categories from subscription_event se join event e on e.id = se.event_id_fk and e.org_id = :organizationId join subscription_descriptor sd on sd.id = se.subscription_descriptor_id_fk and sd.organization_id_fk = :organizationId where se.event_id_fk = :eventId")
    public List<EventSubscriptionLink> findLinkedSubscriptions(@Bind(value="organizationId") int var1, @Bind(value="eventId") int var2);

    @Query(value="select sd.id subscription_descriptor_id, sd.title subscription_descriptor_title, e.id event_id, e.short_name event_short_name, e.display_name event_display_name, e.currency event_currency, se.price_per_ticket price_per_ticket, se.compatible_categories compatible_categories from subscription_event se join event e on e.id = se.event_id_fk and e.org_id = :organizationId join subscription_descriptor sd on sd.id = se.subscription_descriptor_id_fk and sd.organization_id_fk = :organizationId where se.event_id_fk = :eventId and se.subscription_descriptor_id_fk = :subscriptionId")
    public Optional<EventSubscriptionLink> findLink(@Bind(value="organizationId") int var1, @Bind(value="subscriptionId") UUID var2, @Bind(value="eventId") int var3);

    @Query(value="select subscription_descriptor_id_fk from subscription_event where event_id_fk = :eventId and organization_id_fk = :organizationId")
    public List<UUID> findLinkedSubscriptionIds(@Bind(value="eventId") int var1, @Bind(value="organizationId") int var2);

    @Query(value="select * from subscription_descriptor where status = 'ACTIVE' and organization_id_fk = :organizationId and (on_sale_to is null or on_sale_to > now()) order by on_sale_from, on_sale_to nulls last")
    public List<SubscriptionDescriptor> findActiveSubscriptionsForOrganization(@Bind(value="organizationId") int var1);

    @Query(value="delete from subscription_event where event_id_fk = :eventId and organization_id_fk = :organizationId and subscription_descriptor_id_fk not in (:descriptorIds)")
    public int removeStaleSubscriptions(@Bind(value="eventId") int var1, @Bind(value="organizationId") int var2, @Bind(value="descriptorIds") List<UUID> var3);

    @Query(value="delete from subscription_event where event_id_fk = :eventId and organization_id_fk = :organizationId")
    public int removeAllSubscriptionsForEvent(@Bind(value="eventId") int var1, @Bind(value="organizationId") int var2);

    @Query(value="delete from subscription_event where subscription_descriptor_id_fk = :subscriptionId and organization_id_fk = :organizationId")
    public int removeAllLinksForSubscription(@Bind(value="subscriptionId") UUID var1, @Bind(value="organizationId") int var2);

    default public void preGenerateSubscriptions(SubscriptionDescriptorModification subscriptionDescriptor, UUID subscriptionDescriptorId, int quantity) {
        int[] results = this.getJdbcTemplate().batchUpdate("insert into subscription(id, subscription_descriptor_fk, reservation_id_fk, max_usage,  valid_from, valid_to,  organization_id_fk, status, src_price_cts, currency, max_entries, time_zone)  values (:id, :subscriptionDescriptorId, :reservationId, :maxUsage, :validFrom, :validTo, :organizationId, :status::ALLOCATION_STATUS,  :srcPriceCts, :currency, :maxEntries, :timeZone)", (SqlParameterSource[])Stream.generate(UUID::randomUUID).limit(quantity).map(subscriptionId -> new MapSqlParameterSource("id", subscriptionId).addValue("subscriptionDescriptorId", (Object)subscriptionDescriptorId).addValue("maxUsage", (Object)subscriptionDescriptor.getMaxEntries()).addValue("validFrom", (Object)SubscriptionRepository.toOffsetDateTime((ZonedDateTime)subscriptionDescriptor.getValidityFrom())).addValue("validTo", (Object)SubscriptionRepository.toOffsetDateTime((ZonedDateTime)subscriptionDescriptor.getValidityTo())).addValue("srcPriceCts", (Object)subscriptionDescriptor.getPriceCts()).addValue("currency", (Object)subscriptionDescriptor.getCurrency()).addValue("organizationId", (Object)subscriptionDescriptor.getOrganizationId()).addValue("status", (Object)AllocationStatus.FREE.name()).addValue("maxEntries", (Object)subscriptionDescriptor.getMaxEntries()).addValue("reservationId", null).addValue("timeZone", (Object)subscriptionDescriptor.getTimeZone().toString())).toArray(MapSqlParameterSource[]::new));
        int added = Arrays.stream(results).sum();
        if (added != quantity) {
            log.warn("wanted to generate {} subscriptions, got {} instead", (Object)quantity, (Object)added);
            throw new IllegalStateException("Cannot set max availability");
        }
    }

    private static OffsetDateTime toOffsetDateTime(ZonedDateTime in) {
        if (in == null) {
            return null;
        }
        return in.withZoneSameInstant(ZoneId.of("UTC")).toOffsetDateTime();
    }

    @Query(value="insert into subscription(id, subscription_descriptor_fk, reservation_id_fk, max_usage,  valid_from, valid_to,  organization_id_fk, status, src_price_cts, currency, max_entries, time_zone)  values (:id, :subscriptionDescriptorId, :reservationId, :maxUsage, :validFrom, :validTo, :organizationId, :status::ALLOCATION_STATUS,  :srcPriceCts, :currency, :maxEntries, :timeZone)")
    public int createSubscription(@Bind(value="id") UUID var1, @Bind(value="subscriptionDescriptorId") UUID var2, @Bind(value="reservationId") String var3, @Bind(value="maxUsage") int var4, @Bind(value="validFrom") ZonedDateTime var5, @Bind(value="validTo") ZonedDateTime var6, @Bind(value="srcPriceCts") int var7, @Bind(value="currency") String var8, @Bind(value="organizationId") int var9, @Bind(value="status") AllocationStatus var10, @Bind(value="maxEntries") int var11, @Bind(value="timeZone") String var12);

    @Query(value="select id from subscription where subscription_descriptor_fk = :descriptorId and status = 'FREE' limit 1 for update skip locked")
    public Optional<UUID> selectFreeSubscription(@Bind(value="descriptorId") UUID var1);

    @Query(value="select count(*) from subscription where subscription_descriptor_fk = :descriptorId and status = 'FREE'")
    public int countFreeSubscriptionForDescriptor(@Bind(value="descriptorId") UUID var1);

    @Query(value="update subscription set reservation_id_fk = :reservationId, status = :status::allocation_status, src_price_cts = :srcPriceCts where id = :subscriptionId")
    public int bindSubscriptionToReservation(@Bind(value="reservationId") String var1, @Bind(value="srcPriceCts") int var2, @Bind(value="status") AllocationStatus var3, @Bind(value="subscriptionId") UUID var4);

    @Query(value="delete from subscription where reservation_id_fk in (:expiredReservationIds)")
    public int deleteSubscriptionWithReservationId(@Bind(value="expiredReservationIds") List<String> var1);

    @Query(value="select * from subscription where reservation_id_fk = :reservationId")
    public List<Subscription> findSubscriptionsByReservationId(@Bind(value="reservationId") String var1);

    @Query(value="select * from subscription where reservation_id_fk = :reservationId for update")
    public Optional<Subscription> findFirstSubscriptionByReservationIdForUpdate(@Bind(value="reservationId") String var1);

    @Query(value="select exists(select 1 from subscription_descriptor where id = :id and status = 'ACTIVE')")
    public boolean existsById(@Bind(value="id") UUID var1);

    @Query(value="select exists (select id from subscription_event where event_id_fk  = :eventId)")
    public boolean hasLinkedSubscription(@Bind(value="eventId") int var1);

    @Query(value="select exists (select id from subscription_event where subscription_descriptor_id_fk  = :descriptorId::uuid)")
    public boolean hasLinkedEvents(@Bind(value="descriptorId") UUID var1);

    @Query(value="select * from subscription where id = :id for update")
    public Subscription findSubscriptionByIdForUpdate(@Bind(value="id") UUID var1);

    @Query(value="select * from subscription where id = :id")
    public Subscription findSubscriptionById(@Bind(value="id") UUID var1);

    @Query(value="select count(*) from subscription where substring(replace(id::text,'-',''), 0, 11) like concat(:partialUuid, '%') and email_address = :email")
    public int countSubscriptionByPartialUuidAndEmail(@Bind(value="partialUuid") String var1, @Bind(value="email") String var2);

    @Query(value="select count(*) from subscription where substring(replace(id::text,'-',''), 0, 11) like concat(:partialUuid, '%')")
    public int countSubscriptionByPartialUuid(@Bind(value="partialUuid") String var1);

    @Query(value="select id from subscription where substring(replace(id::text,'-',''), 0, 11) like concat(:partialUuid, '%') and email_address = :email")
    public UUID getSubscriptionIdByPartialUuidAndEmail(@Bind(value="partialUuid") String var1, @Bind(value="email") String var2);

    @Query(value="select id from subscription where substring(replace(id::text,'-',''), 0, 11) like concat(:partialUuid, '%')")
    public UUID getSubscriptionIdByPartialUuid(@Bind(value="partialUuid") String var1);

    @Query(value="select * from subscription where id = (select subscription_id_fk from tickets_reservation where id = :reservationId)")
    public Optional<Subscription> findAppliedSubscriptionByReservationId(@Bind(value="reservationId") String var1);

    @Query(value="select count(*) from subscription where id = :id")
    public int countSubscriptionById(@Bind(value="id") UUID var1);

    @Query(value="update subscription set status = :status::allocation_status, first_name = :firstName, last_name = :lastName, email_address = :email, max_entries = :maxEntries, confirmation_ts = :confirmationTs, validity_from = :validityFrom, validity_to = :validityTo, time_zone = :timeZone  where reservation_id_fk = :reservationId")
    public int confirmSubscription(@Bind(value="reservationId") String var1, @Bind(value="status") AllocationStatus var2, @Bind(value="firstName") String var3, @Bind(value="lastName") String var4, @Bind(value="email") String var5, @Bind(value="maxEntries") int var6, @Bind(value="validityFrom") ZonedDateTime var7, @Bind(value="validityTo") ZonedDateTime var8, @Bind(value="confirmationTs") ZonedDateTime var9, @Bind(value="timeZone") String var10);

    @Query(value="update subscription set first_name = :firstName, last_name = :lastName, email_address = :email, max_entries = :maxEntries, validity_from = :validityFrom, validity_to = :validityTo where id = :id::uuid")
    public int updateSubscription(@Bind(value="id") UUID var1, @Bind(value="firstName") String var2, @Bind(value="lastName") String var3, @Bind(value="email") String var4, @Bind(value="maxEntries") int var5, @Bind(value="validityFrom") ZonedDateTime var6, @Bind(value="validityTo") ZonedDateTime var7);

    @Query(value="update subscription set first_name = :firstName, last_name = :lastName, email_address = :email where reservation_id_fk = :reservationId")
    public int assignSubscription(@Bind(value="reservationId") String var1, @Bind(value="firstName") String var2, @Bind(value="lastName") String var3, @Bind(value="email") String var4);

    @Query(value="update subscription set status = 'INVALIDATED' where id in (select id from subscription where subscription_descriptor_fk = :descriptorId and status = 'FREE' limit :amount)")
    public int invalidateSubscriptions(@Bind(value="descriptorId") UUID var1, @Bind(value="amount") int var2);

    @Query(value="update subscription set status = 'CANCELLED' where reservation_id_fk = :reservationId")
    public int cancelSubscriptions(@Bind(value="reservationId") String var1);

    @Query(value="update subscription set status = 'CANCELLED' where reservation_id_fk = :reservationId and id = :subscriptionId and subscription_descriptor_fk = :descriptorId")
    public int cancelSubscription(@Bind(value="reservationId") String var1, @Bind(value="subscriptionId") UUID var2, @Bind(value="descriptorId") UUID var3);

    public NamedParameterJdbcTemplate getJdbcTemplate();

    default public Map<Integer, List<AvailableSubscriptionsByEvent>> loadAvailableSubscriptionsByEvent(@Bind(value="eventId") Integer eventId, @Bind(value="organizationId") Integer organizationId) {
        TreeMap<Integer, List<AvailableSubscriptionsByEvent>> result = new TreeMap<Integer, List<AvailableSubscriptionsByEvent>>();
        MapSqlParameterSource paramSource = new MapSqlParameterSource("eventId", (Object)eventId).addValue("organizationId", (Object)organizationId);
        this.getJdbcTemplate().query("with usage_by_subscription_id as (         select s.id subscription_id,                sum(case when t.subscription_id_fk is not null then 1 else 0 end) usage         from subscription s                  left join tickets_reservation t on t.subscription_id_fk = s.id         group by 1     ), subscription_expiration as (         select id,                coalesce(s.validity_from, 'yesterday'::timestamp) inception,                coalesce(s.validity_to, 'tomorrow'::timestamp) expiration         from subscription s     ), subscription_additional as (       select subscription_id_fk, jsonb_agg(jsonb_build_object('name', field_name, 'value', to_jsonb(field_value))) fields           from field_value_w_additional where context = 'SUBSCRIPTION' group by 1    )     select e.id event_id,            e.org_id organization_id,            s.id as subscription_id,            sd.id as descriptor_id,            s.email_address as email_address,            s.first_name as first_name,            s.last_name as last_name,            r.user_language as user_language,           r.email_address as reservation_email,           fv.fields as additional_fields,            se.compatible_categories as compatible_categories     from event e              join subscription_event se on se.event_id_fk = e.id              join subscription_descriptor sd on se.subscription_descriptor_id_fk = sd.id              join subscription s on sd.id = s.subscription_descriptor_fk              join usage_by_subscription_id u on s.id = u.subscription_id              join subscription_expiration exp on s.id = exp.id              join tickets_reservation r on r.id = s.reservation_id_fk              left join subscription_additional fv on s.id = fv.subscription_id_fk    where e.end_ts > now()       and (:eventId::int is null or e.id = :eventId::int)      and (:organizationId::int is null or e.org_id = :organizationId::int)      and s.status = 'ACQUIRED'       and not exists(select id from tickets_reservation tr where tr.subscription_id_fk = s.id and tr.event_id_fk = e.id)       and sd.supports_tickets_generation is TRUE       and exp.inception <= now()       and exp.expiration > now()       and (s.max_entries = -1 or s.max_entries > u.usage)       and (select count(*) from ticket_category where event_id = e.id and tc_status = 'ACTIVE') > 0    order by e.id", (SqlParameterSource)paramSource, rse -> {
            int eId = rse.getInt("event_id");
            if (!result.containsKey(eId)) {
                result.put(eId, new ArrayList());
            }
            ((List)result.get(eId)).add(new AvailableSubscriptionsByEvent(eId, rse.getInt("organization_id"), rse.getObject("subscription_id", UUID.class), rse.getObject("descriptor_id", UUID.class), rse.getString("email_address"), rse.getString("first_name"), rse.getString("last_name"), rse.getString("user_language"), rse.getString("reservation_email"), rse.getString("additional_fields"), rse.getString("compatible_categories")));
        });
        return result;
    }

    @Query(value="update subscription set src_price_cts = :price where subscription_descriptor_fk = :descriptorId and status = 'FREE'")
    public int updatePriceForSubscriptions(@Bind(value="descriptorId") UUID var1, @Bind(value="price") int var2);

    @Query(value="update subscription set max_entries = :maxEntries, max_usage = :maxEntries where subscription_descriptor_fk = :descriptorId")
    public int updateMaxEntriesForSubscriptions(@Bind(value="descriptorId") UUID var1, @Bind(value="maxEntries") int var2);

    @Query(value="update subscription set metadata = :metadata::jsonb where id = :id")
    public int setMetadataForSubscription(@Bind(value="id") UUID var1, @Bind(value="metadata") @JSONData SubscriptionMetadata var2);

    @Query(value="select metadata from subscription where id = :id")
    @JSONData
    public SubscriptionMetadata getSubscriptionMetadata(@Bind(value="id") UUID var1);
}

