/*
 * Decompiled with CFR 0.152.
 */
package alfio.repository;

import alfio.model.TicketCategoryDescription;
import ch.digitalfondue.npjt.Bind;
import ch.digitalfondue.npjt.Query;
import ch.digitalfondue.npjt.QueryRepository;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

@QueryRepository
public interface TicketCategoryDescriptionRepository {
    @Query(value="select * from ticket_category_text where ticket_category_id_fk = :ticketCategoryId")
    public List<TicketCategoryDescription> findByTicketCategoryId(@Bind(value="ticketCategoryId") int var1);

    @Query(value="select description from ticket_category_text where ticket_category_id_fk = :ticketCategoryId and locale = :locale")
    public Optional<String> findByTicketCategoryIdAndLocale(@Bind(value="ticketCategoryId") int var1, @Bind(value="locale") String var2);

    @Query(value="insert into ticket_category_text(ticket_category_id_fk, locale, description) values (:ticketCategoryId, :locale, :description)")
    public int insert(@Bind(value="ticketCategoryId") int var1, @Bind(value="locale") String var2, @Bind(value="description") String var3);

    @Query(value="delete from ticket_category_text where ticket_category_id_fk = :ticketCategoryId")
    public int delete(@Bind(value="ticketCategoryId") int var1);

    @Query(value="select * from ticket_category_text where ticket_category_id_fk in (:ticketCategoryIds)")
    public List<TicketCategoryDescription> findByTicketCategoryIds(@Bind(value="ticketCategoryIds") Collection<Integer> var1);

    default public Map<String, String> descriptionForTicketCategory(int ticketCategory) {
        return this.findByTicketCategoryId(ticketCategory).stream().collect(Collectors.toMap(TicketCategoryDescription::getLocale, TicketCategoryDescription::getDescription));
    }

    default public Map<Integer, Map<String, String>> descriptionsByTicketCategory(Collection<Integer> ticketCategoryIds) {
        if (ticketCategoryIds.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Integer, Map<String, String>> res = new HashMap<Integer, Map<String, String>>();
        this.findByTicketCategoryIds(ticketCategoryIds).forEach(t -> {
            if (!res.containsKey(t.getTicketCategoryId())) {
                res.put(t.getTicketCategoryId(), new HashMap());
            }
            ((Map)res.get(t.getTicketCategoryId())).put(t.getLocale(), t.getDescription());
        });
        return res;
    }
}

