/*
 * Decompiled with CFR 0.152.
 */
package alfio.repository;

import alfio.model.EntityIdAndMetadata;
import alfio.model.TicketCategory;
import alfio.model.TicketCategoryStatisticView;
import alfio.model.metadata.AlfioMetadata;
import alfio.model.support.JSONData;
import ch.digitalfondue.npjt.AffectedRowCountAndKey;
import ch.digitalfondue.npjt.AutoGeneratedKey;
import ch.digitalfondue.npjt.Bind;
import ch.digitalfondue.npjt.Query;
import ch.digitalfondue.npjt.QueryRepository;
import ch.digitalfondue.npjt.QueryType;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

@QueryRepository
public interface TicketCategoryRepository {
    public static final String CHECK_ACTIVE = "event_id = :eventId and tc_status = 'ACTIVE'";
    public static final String FIND_ALL_AVAILABLE = "select tc.* from ticket_category_with_currency tc\n            join ticket_category_statistics tcs on tc.id = tcs.ticket_category_id\n            where tc.event_id = :eventId\n            and tcs.is_expired is FALSE\n            and tcs.access_restricted is FALSE\n            and (tcs.bounded is FALSE or tcs.not_sold_tickets > 0)\n         order by tc.inception, tc.expiration, tc.id\n";

    @Query(value="insert into ticket_category(inception, expiration, name, max_tickets, price_cts, src_price_cts, access_restricted, tc_status, event_id, bounded, category_code, valid_checkin_from, valid_checkin_to, ticket_validity_start, ticket_validity_end, ordinal, ticket_checkin_strategy, metadata, ticket_access_type) values(:inception, :expiration, :name, :max_tickets, 0, :price, :accessRestricted, 'ACTIVE', :eventId, :bounded, :code, :validCheckInFrom, :validCheckInTo, :ticketValidityStart, :ticketValidityEnd, :ordinal, :ticketCheckInStrategy, :metadata::jsonb, :ticketAccessType::ticket_access_type)")
    @AutoGeneratedKey(value="id")
    public AffectedRowCountAndKey<Integer> insert(@Bind(value="inception") ZonedDateTime var1, @Bind(value="expiration") ZonedDateTime var2, @Bind(value="name") String var3, @Bind(value="max_tickets") int var4, @Bind(value="accessRestricted") boolean var5, @Bind(value="eventId") int var6, @Bind(value="bounded") boolean var7, @Bind(value="price") int var8, @Bind(value="code") String var9, @Bind(value="validCheckInFrom") ZonedDateTime var10, @Bind(value="validCheckInTo") ZonedDateTime var11, @Bind(value="ticketValidityStart") ZonedDateTime var12, @Bind(value="ticketValidityEnd") ZonedDateTime var13, @Bind(value="ordinal") int var14, @Bind(value="ticketCheckInStrategy") TicketCategory.TicketCheckInStrategy var15, @Bind(value="metadata") @JSONData AlfioMetadata var16, @Bind(value="ticketAccessType") TicketCategory.TicketAccessType var17);

    @Query(value="select * from ticket_category_with_currency where id = :id and event_id = :eventId and tc_status = 'ACTIVE'")
    public TicketCategory getByIdAndActive(@Bind(value="id") int var1, @Bind(value="eventId") int var2);

    @Query(value="select exists(select id from ticket_category where id = :id and event_id = :eventId and tc_status = 'ACTIVE')")
    public Boolean checkCategoryExistsForEvent(@Bind(value="id") int var1, @Bind(value="eventId") int var2);

    @Query(value="select count(*) from ticket_category where id in (:ids) and event_id = :eventId and tc_status = 'ACTIVE'")
    public Integer countCategoriesBelongingToEvent(@Bind(value="eventId") int var1, @Bind(value="ids") Collection<Integer> var2);

    @Query(value="select * from ticket_category_with_currency where id in (:ids) and event_id = :eventId and tc_status = 'ACTIVE'")
    public List<TicketCategory> getByIdsAndActive(@Bind(value="ids") Collection<Integer> var1, @Bind(value="eventId") int var2);

    @Query(value="select * from ticket_category_with_currency where id = :id and event_id = :eventId and tc_status = 'ACTIVE'")
    public Optional<TicketCategory> getOptionalByIdAndActive(@Bind(value="id") int var1, @Bind(value="eventId") int var2);

    @Query(value="select * from ticket_category_with_currency where id = :id and tc_status = 'ACTIVE'")
    public Optional<TicketCategory> getByIdAndActive(@Bind(value="id") int var1);

    @Query(value="select * from ticket_category_with_currency where id = :id")
    public TicketCategory getById(@Bind(value="id") int var1);

    @Query(value="select * from ticket_category_with_currency where id in(:ids)")
    public List<TicketCategory> findByIds(@Bind(value="ids") Collection<Integer> var1);

    @Query(value="select * from ticket_category_with_currency where event_id = :eventId and category_code = :code and tc_status = 'ACTIVE'")
    public Optional<TicketCategory> findCodeInEvent(@Bind(value="eventId") int var1, @Bind(value="code") String var2);

    @Query(value="select count(*) from ticket_category_with_currency where event_id = :eventId and tc_status = 'ACTIVE' and bounded = false")
    public Integer countUnboundedCategoriesByEventId(@Bind(value="eventId") int var1);

    @Query(value="select * from ticket_category_with_currency where event_id = :eventId and tc_status = 'ACTIVE' and bounded = false order by expiration desc")
    public List<TicketCategory> findUnboundedOrderByExpirationDesc(@Bind(value="eventId") int var1);

    @Query(value="select * from ticket_category_with_currency where event_id = :eventId  and tc_status = 'ACTIVE' order by ordinal asc, inception asc, expiration asc, id asc")
    public List<TicketCategory> findAllTicketCategories(@Bind(value="eventId") int var1);

    @Query(value="select tc.* from ticket_category_with_currency tc\n            join ticket_category_statistics tcs on tc.id = tcs.ticket_category_id\n            where tc.event_id = :eventId\n            and tcs.is_expired is FALSE\n            and tcs.access_restricted is FALSE\n            and (tcs.bounded is FALSE or tcs.not_sold_tickets > 0)\n         order by tc.inception, tc.expiration, tc.id\n limit 1")
    public Optional<TicketCategory> findFirstWithAvailableTickets(@Bind(value="eventId") int var1);

    @Query(value="select tc.* from ticket_category_with_currency tc\n            join ticket_category_statistics tcs on tc.id = tcs.ticket_category_id\n            where tc.event_id = :eventId\n            and tcs.is_expired is FALSE\n            and tcs.access_restricted is FALSE\n            and (tcs.bounded is FALSE or tcs.not_sold_tickets > 0)\n         order by tc.inception, tc.expiration, tc.id\n")
    public List<TicketCategory> findAllWithAvailableTickets(@Bind(value="eventId") int var1);

    default public Map<Integer, TicketCategory> findByEventIdAsMap(int eventId) {
        return this.findAllTicketCategories(eventId).stream().collect(Collectors.toMap(TicketCategory::getId, Function.identity()));
    }

    @Query(value="select id, metadata from ticket_category where event_id = :eventId and tc_status = 'ACTIVE' order by ordinal asc, inception asc, expiration asc, id asc")
    public List<EntityIdAndMetadata> findMetadataForCategoriesInEvent(@Bind(value="eventId") int var1);

    default public Map<Integer, AlfioMetadata> findCategoryMetadataForEventGroupByCategoryId(int eventId) {
        return this.findMetadataForCategoriesInEvent(eventId).stream().filter(ei -> ei.getMetadata() != null).collect(Collectors.toMap(EntityIdAndMetadata::getId, EntityIdAndMetadata::getMetadata));
    }

    @Query(value="select count(*) from ticket_category_with_currency where event_id = :eventId and access_restricted = true")
    public Integer countAccessRestrictedRepositoryByEventId(@Bind(value="eventId") int var1);

    @Query(value="update ticket_category set name = :name, inception = :inception, expiration = :expiration, max_tickets = :max_tickets, src_price_cts = :price, access_restricted = :accessRestricted, category_code = :code,  valid_checkin_from = :validCheckInFrom, valid_checkin_to = :validCheckInTo, ticket_validity_start = :ticketValidityStart, ticket_validity_end = :ticketValidityEnd, ticket_checkin_strategy = :ticketCheckInStrategy, ticket_access_type = :ticketAccessType::ticket_access_type where id = :id")
    public int update(@Bind(value="id") int var1, @Bind(value="name") String var2, @Bind(value="inception") ZonedDateTime var3, @Bind(value="expiration") ZonedDateTime var4, @Bind(value="max_tickets") int var5, @Bind(value="accessRestricted") boolean var6, @Bind(value="price") int var7, @Bind(value="code") String var8, @Bind(value="validCheckInFrom") ZonedDateTime var9, @Bind(value="validCheckInTo") ZonedDateTime var10, @Bind(value="ticketValidityStart") ZonedDateTime var11, @Bind(value="ticketValidityEnd") ZonedDateTime var12, @Bind(value="ticketCheckInStrategy") TicketCategory.TicketCheckInStrategy var13, @Bind(value="ticketAccessType") TicketCategory.TicketAccessType var14);

    @Query(value="update ticket_category set max_tickets = :max_tickets where id = :id")
    public int updateSeatsAvailability(@Bind(value="id") int var1, @Bind(value="max_tickets") int var2);

    @Query(value="update ticket_category set bounded = :bounded where id = :id")
    public int updateBoundedFlag(@Bind(value="id") int var1, @Bind(value="bounded") boolean var2);

    @Query(value="update ticket_category set inception = :inception, expiration = :expiration where id = :id")
    public int fixDates(@Bind(value="id") int var1, @Bind(value="inception") ZonedDateTime var2, @Bind(value="expiration") ZonedDateTime var3);

    default public int getTicketAllocation(int eventId) {
        return this.findAllTicketCategories(eventId).stream().filter(TicketCategory::isBounded).mapToInt(TicketCategory::getMaxTickets).sum();
    }

    @Query(value="select * from ticket_category_statistics where ticket_category_id = :ticketCategoryId and event_id = :eventId")
    public TicketCategoryStatisticView findStatisticWithId(@Bind(value="ticketCategoryId") int var1, @Bind(value="eventId") int var2);

    @Query(value="select * from ticket_category_statistics where event_id = :eventId")
    public List<TicketCategoryStatisticView> findStatisticsForEventId(@Bind(value="eventId") int var1);

    default public Map<Integer, TicketCategoryStatisticView> findStatisticsForEventIdByCategoryId(int eventId) {
        return this.findStatisticsForEventId(eventId).stream().collect(Collectors.toMap(TicketCategoryStatisticView::getId, Function.identity()));
    }

    @Query(value="select access_restricted from ticket_category where id = :id")
    public Boolean isAccessRestricted(@Bind(value="id") Integer var1);

    @Query(value="update ticket_category set tc_status = 'NOT_ACTIVE' from (select count(*) cnt from ticket where category_id = :categoryId and status in ('PENDING', 'ACQUIRED', 'CHECKED_IN')) tkts where id = :categoryId and tkts.cnt = 0")
    public int deleteCategoryIfEmpty(@Bind(value="categoryId") int var1);

    @Query(type=QueryType.TEMPLATE, value="update ticket_category set ordinal = :ordinal where id = :id and event_id = :eventId")
    public String updateOrdinal();

    @Query(value="select ticket_checkin_strategy from ticket_category where id = :id")
    public TicketCategory.TicketCheckInStrategy getCheckInStrategy(@Bind(value="id") int var1);

    @Query(value="select count(*) from ticket_category where id in (:categoryIds) and src_price_cts > 0")
    public Integer countPaidCategoriesInReservation(@Bind(value="categoryIds") Collection<Integer> var1);

    @Query(value="select distinct tc.* from ticket_category_with_currency tc join ticket t on t.category_id = tc.id where t.tickets_reservation_id = :reservationId")
    public List<TicketCategory> findCategoriesInReservation(@Bind(value="reservationId") String var1);

    @JSONData
    @Query(value="select metadata from ticket_category where id = :id and event_id = :eventId")
    public AlfioMetadata getMetadata(@Bind(value="eventId") int var1, @Bind(value="id") int var2);

    @Query(value="update ticket_category set metadata = :metadata::jsonb where id = :id and event_id = :eventId")
    public int updateMetadata(@Bind(value="metadata") @JSONData AlfioMetadata var1, @Bind(value="eventId") int var2, @Bind(value="id") int var3);

    @Query(value="update ticket_category set ticket_access_type = :ticketAccessType::ticket_access_type where event_id = :eventId")
    public void updateTicketAccessTypeForEvent(@Bind(value="eventId") int var1, @Bind(value="ticketAccessType") TicketCategory.TicketAccessType var2);

    @Query(value="select count(*) from ticket_category where event_id = :eventId and tc_status = 'ACTIVE'")
    public Integer countActiveByEventId(@Bind(value="eventId") int var1);

    @Query(value="select count(*) from ticket_category where event_id = :eventId and id in (:categoryIds)")
    public int countCategoryForEvent(@Bind(value="categoryIds") Set<Integer> var1, @Bind(value="eventId") int var2);

    @Query(value="select count(*) from ticket_category tc join event e on tc.event_id = e.id where e.short_name = :shortName and tc.id in (:categoryIds)")
    public int countCategoryForEvent(@Bind(value="categoryIds") Set<Integer> var1, @Bind(value="shortName") String var2);
}

