/*
 * Decompiled with CFR 0.152.
 */
package alfio.repository;

import alfio.model.CategoryAvailability;
import alfio.model.Event;
import alfio.model.FullTicketInfo;
import alfio.model.PriceContainer;
import alfio.model.Ticket;
import alfio.model.TicketCategory;
import alfio.model.TicketInfo;
import alfio.model.TicketWithMetadataAttributes;
import alfio.model.TicketWithReservationAndTransaction;
import alfio.model.checkin.AttendeeSearchResultsCount;
import alfio.model.checkin.CheckInFullInfo;
import alfio.model.metadata.TicketMetadata;
import alfio.model.metadata.TicketMetadataContainer;
import alfio.model.modification.AttendeeData;
import alfio.model.poll.PollParticipant;
import alfio.model.support.Array;
import alfio.model.support.EnumTypeAsString;
import alfio.model.support.JSONData;
import alfio.util.Json;
import ch.digitalfondue.npjt.Bind;
import ch.digitalfondue.npjt.Query;
import ch.digitalfondue.npjt.QueryRepository;
import ch.digitalfondue.npjt.QueryType;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntFunction;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

@QueryRepository
public interface TicketRepository {
    public static final String CONFIRMED = "'ACQUIRED', 'CHECKED_IN', 'TO_BE_PAID'";
    public static final String FREE = "FREE";
    public static final String RELEASED = "RELEASED";
    public static final String REVERT_TO_FREE = "update ticket set status = 'FREE' where status = 'RELEASED' and event_id = :eventId";
    public static final String SORT_TICKETS = "order by category_id asc, uuid asc";
    public static final String FIND_TICKETS_IN_RESERVATION = "select * from ticket where tickets_reservation_id = :reservationId order by category_id asc, uuid asc";
    public static final String RESET_TICKET = " TICKETS_RESERVATION_ID = null, FULL_NAME = null, EMAIL_ADDRESS = null, SPECIAL_PRICE_ID_FK = null, LOCKED_ASSIGNMENT = false, USER_LANGUAGE = null, REMINDER_SENT = false, SRC_PRICE_CTS = 0, FINAL_PRICE_CTS = 0, VAT_CTS = 0, DISCOUNT_CTS = 0, FIRST_NAME = null, LAST_NAME = null, EXT_REFERENCE = null, TAGS = array[]::text[], VAT_STATUS = null, METADATA = '{}'::jsonb ";
    public static final String RELEASE_TICKET_QUERY = "update ticket set status = 'RELEASED', uuid = :newUuid, public_uuid = :newPublicUuid,  TICKETS_RESERVATION_ID = null, FULL_NAME = null, EMAIL_ADDRESS = null, SPECIAL_PRICE_ID_FK = null, LOCKED_ASSIGNMENT = false, USER_LANGUAGE = null, REMINDER_SENT = false, SRC_PRICE_CTS = 0, FINAL_PRICE_CTS = 0, VAT_CTS = 0, DISCOUNT_CTS = 0, FIRST_NAME = null, LAST_NAME = null, EXT_REFERENCE = null, TAGS = array[]::text[], VAT_STATUS = null, METADATA = '{}'::jsonb  where id = :ticketId and status in('ACQUIRED', 'PENDING', 'TO_BE_PAID') and tickets_reservation_id = :reservationId and event_id = :eventId";
    public static final String FIND_BASIC_TICKET_INFO_BY_EVENT_ID = "select t.id t_id, t.uuid t_uuid, t.public_uuid t_public_uuid, tc.id tc_id, tc.bounded tc_bounded, t.vat_status t_vat_status from ticket t inner join ticket_category tc on t.category_id = tc.id where t.event_id = :eventId";
    public static final String UPDATE_TICKET_PRICE = "update ticket set src_price_cts = :srcPriceCts, final_price_cts = :finalPriceCts, vat_cts = :vatCts, discount_cts = :discountCts, currency_code = :currencyCode, vat_status = :vatStatus::VAT_STATUS where event_id = :eventId and category_id = :categoryId";
    public static final String FIND_FULL_TICKET_INFO = "select  t.id t_id, t.uuid t_uuid, t.public_uuid t_public_uuid, t.creation t_creation, t.category_id t_category_id, t.status t_status, t.event_id t_event_id, t.src_price_cts t_src_price_cts, t.final_price_cts t_final_price_cts, t.vat_cts t_vat_cts, t.discount_cts t_discount_cts, t.tickets_reservation_id t_tickets_reservation_id, t.full_name t_full_name, t.first_name t_first_name, t.last_name t_last_name, t.email_address t_email_address, t.locked_assignment t_locked_assignment, t.user_language t_user_language, t.ext_reference t_ext_reference, t.currency_code t_currency_code, t.tags t_tags, t.subscription_id_fk t_subscription_id, t.vat_status t_vat_status,  tr.id tr_id, tr.validity tr_validity, tr.status tr_status, tr.full_name tr_full_name, tr.first_name tr_first_name, tr.last_name tr_last_name, tr.email_address tr_email_address, tr.billing_address tr_billing_address, tr.confirmation_ts tr_confirmation_ts, tr.latest_reminder_ts tr_latest_reminder_ts, tr.payment_method tr_payment_method,  tr.offline_payment_reminder_sent tr_offline_payment_reminder_sent, tr.promo_code_id_fk tr_promo_code_id_fk, tr.automatic tr_automatic, tr.user_language tr_user_language, tr.direct_assignment tr_direct_assignment, tr.invoice_number tr_invoice_number, tr.invoice_model tr_invoice_model,  tr.vat_status tr_vat_status, tr.vat_nr tr_vat_nr, tr.vat_country tr_vat_country, tr.invoice_requested tr_invoice_requested, tr.used_vat_percent tr_used_vat_percent, tr.vat_included tr_vat_included, tr.creation_ts tr_creation_ts, tr.registration_ts tr_registration_ts, tr.customer_reference tr_customer_reference,  tr.billing_address_company tr_billing_address_company, tr.billing_address_line1 tr_billing_address_line1, tr.billing_address_line2 tr_billing_address_line2, tr.billing_address_city tr_billing_address_city, tr.billing_address_state tr_billing_address_state, tr.billing_address_zip tr_billing_address_zip, tr.invoicing_additional_information tr_invoicing_additional_information,  tr.src_price_cts tr_src_price_cts, tr.final_price_cts tr_final_price_cts, tr.vat_cts tr_vat_cts, tr.discount_cts tr_discount_cts, tr.currency_code tr_currency_code,  tc.id tc_id, tc.inception tc_inception, tc.expiration tc_expiration, tc.max_tickets tc_max_tickets, tc.name tc_name, tc.src_price_cts tc_src_price_cts, tc.access_restricted tc_access_restricted, tc.tc_status tc_tc_status, tc.event_id tc_event_id, tc.bounded tc_bounded, tc.category_code tc_category_code,  tc.valid_checkin_from tc_valid_checkin_from, tc.valid_checkin_to tc_valid_checkin_to, tc.ticket_validity_start tc_ticket_validity_start, tc.ticket_validity_end tc_ticket_validity_end, tc.currency_code tc_currency_code, tc.ordinal tc_ordinal, tc.ticket_checkin_strategy tc_ticket_checkin_strategy, tc.ticket_access_type tc_ticket_access_type from ticket t  inner join tickets_reservation tr on t.tickets_reservation_id = tr.id  inner join ticket_category_with_currency tc on t.category_id = tc.id ";

    default public void bulkTicketInitialization(MapSqlParameterSource[] args) {
        this.getNamedParameterJdbcTemplate().batchUpdate("insert into ticket (uuid, public_uuid, creation, category_id, event_id, status, original_price_cts, paid_price_cts, src_price_cts)\nvalues(:uuid, :publicUuid, :creation, :categoryId, :eventId, :status, 0, 0, :srcPriceCts)\n", (SqlParameterSource[])args);
    }

    default public void bulkTicketUpdate(List<Integer> ids, TicketCategory ticketCategory) {
        MapSqlParameterSource[] params = (MapSqlParameterSource[])ids.stream().map(id -> new MapSqlParameterSource("id", id).addValue("categoryId", (Object)ticketCategory.getId()).addValue("srcPriceCts", (Object)ticketCategory.getSrcPriceCts())).toArray(MapSqlParameterSource[]::new);
        this.getNamedParameterJdbcTemplate().batchUpdate("update ticket set category_id = :categoryId, src_price_cts = :srcPriceCts where id = :id", (SqlParameterSource[])params);
    }

    @Query(value="select id from ticket where status in (:requiredStatuses) and category_id = :categoryId and event_id = :eventId and tickets_reservation_id is null order by id limit :amount for update")
    public List<Integer> selectTicketInCategoryForUpdate(@Bind(value="eventId") int var1, @Bind(value="categoryId") int var2, @Bind(value="amount") int var3, @Bind(value="requiredStatuses") List<String> var4);

    @Query(value="select id from ticket where status in (:requiredStatuses) and category_id = :categoryId and event_id = :eventId and tickets_reservation_id is null order by id limit :amount for update skip locked")
    public List<Integer> selectTicketInCategoryForUpdateSkipLocked(@Bind(value="eventId") int var1, @Bind(value="categoryId") int var2, @Bind(value="amount") int var3, @Bind(value="requiredStatuses") List<String> var4);

    @Query(value="select id from ticket where status in(:requiredStatuses) and category_id is null and event_id = :eventId and tickets_reservation_id is null order by id limit :amount for update")
    public List<Integer> selectNotAllocatedTicketsForUpdate(@Bind(value="eventId") int var1, @Bind(value="amount") int var2, @Bind(value="requiredStatuses") List<String> var3);

    @Query(value="select id from ticket where status in(:requiredStatuses) and category_id is null and event_id = :eventId and tickets_reservation_id is null order by id limit :amount for update skip locked")
    public List<Integer> selectNotAllocatedTicketsForUpdateSkipLocked(@Bind(value="eventId") int var1, @Bind(value="amount") int var2, @Bind(value="requiredStatuses") List<String> var3);

    @Query(value="select id from ticket where status = 'FREE' and category_id = :categoryId and event_id = :eventId and tickets_reservation_id is null order by id desc limit :amount for update")
    public List<Integer> lockTicketsToInvalidate(@Bind(value="eventId") int var1, @Bind(value="categoryId") int var2, @Bind(value="amount") int var3);

    @Query(value="select count(*) from ticket where status in ('ACQUIRED', 'CHECKED_IN', 'TO_BE_PAID') and category_id = :categoryId and event_id = :eventId and full_name is not null and email_address is not null")
    public Integer countAssignedTickets(@Bind(value="eventId") int var1, @Bind(value="categoryId") int var2);

    @Query(value="select count(*) from ticket where status in ('ACQUIRED', 'CHECKED_IN', 'TO_BE_PAID', 'PENDING') and category_id = :categoryId and event_id = :eventId")
    public Integer countConfirmedAndPendingTickets(@Bind(value="eventId") int var1, @Bind(value="categoryId") int var2);

    @Query(value="select count(*) from ticket where status in ('ACQUIRED', 'CHECKED_IN', 'TO_BE_PAID') and category_id = :categoryId and event_id = :eventId")
    public Integer countConfirmedForCategory(@Bind(value="eventId") int var1, @Bind(value="categoryId") int var2);

    @Query(value="select count(*) from ticket where status in ('PENDING', 'RELEASED') and category_id = :categoryId and event_id = :eventId")
    public Integer countPendingOrReleasedForCategory(@Bind(value="eventId") int var1, @Bind(value="categoryId") int var2);

    @Query(value="select count(*) from ticket where status = 'FREE'  and category_id = :categoryId and event_id = :eventId")
    public Integer countFreeTickets(@Bind(value="eventId") int var1, @Bind(value="categoryId") int var2);

    @Query(value="select count(*) filter (where status = 'FREE') as available_tickets,\n       count(*) filter (where status = 'PENDING' or status = 'RELEASED') as pending_tickets\nfrom ticket\nwhere category_id = :categoryId and event_id = :eventId\n")
    public CategoryAvailability getCategoryAvailability(@Bind(value="eventId") int var1, @Bind(value="categoryId") int var2);

    @Query(value="select count(*) filter (where category_id is null and status = 'FREE') as available_tickets,\n       count(*) filter (where (category_id = :categoryId and status = 'PENDING') or status = 'RELEASED') as pending_tickets\nfrom ticket\nwhere event_id = :eventId\n")
    public CategoryAvailability getUnboundedCategoryAvailability(@Bind(value="eventId") int var1, @Bind(value="categoryId") int var2);

    @Query(value="select count(*) from ticket where status = 'FREE' and category_id is null and event_id = :eventId")
    public Integer countFreeTicketsForUnbounded(@Bind(value="eventId") int var1);

    @Query(value="select case(show_public_statistics) when true then dynamic_allocation else 0 end from events_statistics where id = :eventId")
    public Integer countFreeTicketsForPublicStatistics(@Bind(value="eventId") int var1);

    @Query(value="select count(*) from ticket where status in ('FREE', 'RELEASED') and category_id is null and event_id = :eventId")
    public Integer countNotAllocatedFreeAndReleasedTicket(@Bind(value="eventId") int var1);

    @Query(value="select count(*) from ticket where status = 'RELEASED' and category_id is null and event_id = :eventId")
    public Integer countReleasedUnboundedTickets(@Bind(value="eventId") int var1);

    @Query(value="select count(*) from ticket where status = 'RELEASED' and category_id = :categoryId and event_id = :eventId")
    public Integer countReleasedTicketInCategory(@Bind(value="eventId") int var1, @Bind(value="categoryId") int var2);

    default public int reserveTickets(String reservationId, List<Integer> ticketIds, TicketCategory category, String userLanguage, PriceContainer.VatStatus vatStatus, IntFunction<AttendeeData> attendeeDataSupplier) {
        AtomicInteger idx = new AtomicInteger();
        MapSqlParameterSource[] batchReserveParameters = (MapSqlParameterSource[])ticketIds.stream().map(id -> {
            AttendeeData attendee = Objects.requireNonNullElse((AttendeeData)attendeeDataSupplier.apply(idx.getAndIncrement()), AttendeeData.empty());
            String metadata = null;
            if (attendee.hasMetadata()) {
                metadata = Json.toJson((Object)TicketMetadataContainer.fromMetadata((TicketMetadata)new TicketMetadata(null, null, attendee.getMetadata())));
            }
            return new MapSqlParameterSource("reservationId", (Object)reservationId).addValue("id", id).addValue("categoryId", (Object)category.getId()).addValue("userLanguage", (Object)userLanguage).addValue("srcPriceCts", (Object)category.getSrcPriceCts()).addValue("currencyCode", (Object)category.getCurrencyCode()).addValue("ticketMetadata", (Object)Objects.requireNonNullElse(metadata, "{}")).addValue("firstName", (Object)attendee.getFirstName()).addValue("lastName", (Object)attendee.getLastName()).addValue("fullName", (Object)attendee.getFullName()).addValue("email", (Object)attendee.getEmail()).addValue("vatStatus", (Object)vatStatus.name());
        }).toArray(MapSqlParameterSource[]::new);
        return (int)Arrays.stream(this.getNamedParameterJdbcTemplate().batchUpdate(this.batchReserveTickets(), (SqlParameterSource[])batchReserveParameters)).asLongStream().sum();
    }

    @Query(type=QueryType.TEMPLATE, value="update ticket set tickets_reservation_id = :reservationId, status = 'PENDING', category_id = :categoryId, user_language = :userLanguage, src_price_cts = :srcPriceCts, currency_code = :currencyCode, metadata = :ticketMetadata::jsonb, vat_status = :vatStatus::VAT_STATUS, first_name = :firstName, last_name = :lastName, email_address = :email, full_name = :fullName where id = :id")
    public String batchReserveTickets();

    @Query(type=QueryType.TEMPLATE, value="update ticket set tickets_reservation_id = :reservationId, special_price_id_fk = :specialCodeId, user_language = :userLanguage, status = 'PENDING', src_price_cts = :srcPriceCts, currency_code = :currencyCode, vat_status = :vatStatus::VAT_STATUS, metadata = :ticketMetadata::jsonb, first_name = :firstName, last_name = :lastName, email_address = :email, full_name = :fullName where id = :ticketId")
    public String batchReserveTicketsForSpecialPrice();

    @Query(value="update ticket set tickets_reservation_id = :reservationId, special_price_id_fk = :specialCodeId, user_language = :userLanguage, status = 'PENDING', src_price_cts = :srcPriceCts, currency_code = :currencyCode, vat_status = :vatStatus::VAT_STATUS, metadata = :ticketMetadata::jsonb where id = :ticketId")
    public void reserveTicket(@Bind(value="reservationId") String var1, @Bind(value="ticketId") int var2, @Bind(value="specialCodeId") int var3, @Bind(value="userLanguage") String var4, @Bind(value="srcPriceCts") int var5, @Bind(value="currencyCode") String var6, @Bind(value="vatStatus") @EnumTypeAsString PriceContainer.VatStatus var7, @Bind(value="ticketMetadata") @JSONData TicketMetadataContainer var8);

    @Query(value="update ticket set status = :status where tickets_reservation_id = :reservationId")
    public int updateTicketsStatusWithReservationId(@Bind(value="reservationId") String var1, @Bind(value="status") String var2);

    @Query(value="update ticket set status = :status where uuid = :uuid")
    public int updateTicketStatusWithUUID(@Bind(value="uuid") String var1, @Bind(value="status") String var2);

    @Query(value="update ticket set status = 'INVALIDATED' where id in (:ids)")
    public int invalidateTickets(@Bind(value="ids") List<Integer> var1);

    @Query(value="update ticket set src_price_cts = :srcPriceCts, final_price_cts = :finalPriceCts, vat_cts = :vatCts, discount_cts = :discountCts, currency_code = :currencyCode, vat_status = null where event_id = :eventId and category_id = :categoryId and status = 'FREE'")
    public int updateTicketPrice(@Bind(value="categoryId") int var1, @Bind(value="eventId") int var2, @Bind(value="srcPriceCts") int var3, @Bind(value="finalPriceCts") int var4, @Bind(value="vatCts") int var5, @Bind(value="discountCts") int var6, @Bind(value="currencyCode") String var7);

    @Query(value="update ticket set src_price_cts = :srcPriceCts, final_price_cts = :finalPriceCts, vat_cts = :vatCts, discount_cts = :discountCts, currency_code = :currencyCode, vat_status = :vatStatus::VAT_STATUS where event_id = :eventId and category_id = :categoryId and id in(:ids)")
    public int updateTicketPrice(@Bind(value="ids") List<Integer> var1, @Bind(value="categoryId") int var2, @Bind(value="eventId") int var3, @Bind(value="srcPriceCts") int var4, @Bind(value="finalPriceCts") int var5, @Bind(value="vatCts") int var6, @Bind(value="discountCts") int var7, @Bind(value="currencyCode") String var8, @Bind(value="vatStatus") @EnumTypeAsString PriceContainer.VatStatus var9);

    @Query(type=QueryType.TEMPLATE, value="update ticket set src_price_cts = :srcPriceCts, final_price_cts = :finalPriceCts, vat_cts = :vatCts, discount_cts = :discountCts, currency_code = :currencyCode, vat_status = :vatStatus::VAT_STATUS where event_id = :eventId and category_id = :categoryId and tickets_reservation_id = :reservationId")
    public String updateTicketPriceForCategoryInReservation();

    @Query(type=QueryType.TEMPLATE, value="update ticket set src_price_cts = :srcPriceCts, final_price_cts = :finalPriceCts, vat_cts = :vatCts, discount_cts = :discountCts, currency_code = :currencyCode, vat_status = :vatStatus::VAT_STATUS where event_id = :eventId and category_id = :categoryId and uuid = :uuid")
    public String bulkUpdateTicketPrice();

    @Query(value="update ticket set tags = :tags::text[] where id in(:ids)")
    public int updateTicketTags(@Bind(value="ids") List<Integer> var1, @Bind(value="tags") @Array List<String> var2);

    @Query(value="update ticket set status = 'RELEASED',  TICKETS_RESERVATION_ID = null, FULL_NAME = null, EMAIL_ADDRESS = null, SPECIAL_PRICE_ID_FK = null, LOCKED_ASSIGNMENT = false, USER_LANGUAGE = null, REMINDER_SENT = false, SRC_PRICE_CTS = 0, FINAL_PRICE_CTS = 0, VAT_CTS = 0, DISCOUNT_CTS = 0, FIRST_NAME = null, LAST_NAME = null, EXT_REFERENCE = null, TAGS = array[]::text[], VAT_STATUS = null, METADATA = '{}'::jsonb  where status in ('PENDING', 'OFFLINE_PAYMENT')  and tickets_reservation_id in (:reservationIds)")
    public int freeFromReservation(@Bind(value="reservationIds") List<String> var1);

    @Query(value="update ticket set category_id = null where tickets_reservation_id in (:reservationIds) and status in ('PENDING', 'OFFLINE_PAYMENT') and category_id in (select tc.id from ticket_category tc, ticket t where t.tickets_reservation_id in (:reservationIds) and t.category_id = tc.id and tc.bounded = false)")
    public int resetCategoryIdForUnboundedCategories(@Bind(value="reservationIds") List<String> var1);

    @Query(value="update ticket set category_id = null where id in (:ticketIds) and category_id in (select tc.id from ticket_category tc, ticket t where t.id in (:ticketIds) and t.category_id = tc.id and tc.bounded = false)")
    public int resetCategoryIdForUnboundedCategoriesWithTicketIds(@Bind(value="ticketIds") List<Integer> var1);

    @Query(value="update ticket set category_id = null where event_id = :eventId and category_id = :categoryId and id in (:ticketIds)")
    public int unbindTicketsFromCategory(@Bind(value="eventId") int var1, @Bind(value="categoryId") int var2, @Bind(value="ticketIds") List<Integer> var3);

    @Query(value="select * from ticket where tickets_reservation_id = :reservationId order by category_id asc, uuid asc")
    public List<Ticket> findTicketsInReservation(@Bind(value="reservationId") String var1);

    @Query(value="select id from ticket where tickets_reservation_id = :reservationId order by category_id asc, uuid asc")
    public List<Integer> findTicketIdsInReservation(@Bind(value="reservationId") String var1);

    @Query(value="select * from ticket where tickets_reservation_id = :reservationId order by category_id asc, uuid asc LIMIT 1 OFFSET 0")
    public Optional<Ticket> findFirstTicketInReservation(@Bind(value="reservationId") String var1);

    @Query(value="select id from ticket where tickets_reservation_id = :reservationId order by category_id asc, uuid asc LIMIT 1 OFFSET 0")
    public Optional<Integer> findFirstTicketIdInReservation(@Bind(value="reservationId") String var1);

    @Query(value="select count(*) from ticket where tickets_reservation_id = :reservationId ")
    public Integer countTicketsInReservation(@Bind(value="reservationId") String var1);

    @Query(value="select * from ticket where uuid = :uuid")
    public Ticket findByUUID(@Bind(value="uuid") String var1);

    @Query(value="select * from ticket where public_uuid = :publicUuid")
    public Ticket findByPublicUUID(@Bind(value="publicUuid") UUID var1);

    @Query(value="select uuid from ticket where public_uuid = :publicUuid and event_id = :eventId")
    public Optional<String> getInternalUuid(@Bind(value="publicUuid") UUID var1, @Bind(value="eventId") int var2);

    @Query(value="select category_id from ticket where uuid = :uuid")
    public Integer getTicketCategoryByUUID(@Bind(value="uuid") String var1);

    @Query(value="select * from ticket where uuid = :uuid")
    public Optional<Ticket> findOptionalByUUID(@Bind(value="uuid") String var1);

    @Query(value="select * from ticket where public_uuid = :publicUuid")
    public Optional<Ticket> findOptionalByPublicUUID(@Bind(value="publicUuid") UUID var1);

    @Query(value="select * from ticket where uuid = :uuid for update")
    public Optional<Ticket> findByUUIDForUpdate(@Bind(value="uuid") String var1);

    @Query(value="select * from ticket where event_id = :eventId and status = :status and uuid like :uuid for update")
    public List<Ticket> findByEventIdAndPartialUUIDForUpdate(@Bind(value="eventId") int var1, @Bind(value="uuid") String var2, @Bind(value="status") Ticket.TicketStatus var3);

    @Query(value="update ticket set email_address = :email, full_name = :fullName, first_name = :firstName, last_name = :lastName where uuid = :ticketIdentifier")
    public int updateTicketOwner(@Bind(value="ticketIdentifier") String var1, @Bind(value="email") String var2, @Bind(value="fullName") String var3, @Bind(value="firstName") String var4, @Bind(value="lastName") String var5);

    @Query(value="update ticket set email_address = :email, full_name = :fullName, first_name = :firstName, last_name = :lastName where id = :id")
    public int updateTicketOwnerById(@Bind(value="id") int var1, @Bind(value="email") String var2, @Bind(value="fullName") String var3, @Bind(value="firstName") String var4, @Bind(value="lastName") String var5);

    @Query(type=QueryType.TEMPLATE, value="update ticket set email_address = :email, full_name = :fullName, first_name = :firstName, last_name = :lastName, metadata = :metadata::jsonb where id = :id")
    public String updateTicketOwnerAndMetadataById();

    @Query(value="update ticket set locked_assignment = :lockedAssignment where id = :id and category_id = :categoryId")
    public int toggleTicketLocking(@Bind(value="id") int var1, @Bind(value="categoryId") int var2, @Bind(value="lockedAssignment") boolean var3);

    @Query(value="update ticket set locked_assignment = true where id in (:ids)")
    public int forbidReassignment(@Bind(value="ids") Collection<Integer> var1);

    @Query(value="update ticket set ext_reference = :extReference, locked_assignment = :lockedAssignment where id = :id and category_id = :categoryId")
    public int updateExternalReferenceAndLocking(@Bind(value="id") int var1, @Bind(value="categoryId") int var2, @Bind(value="extReference") String var3, @Bind(value="lockedAssignment") boolean var4);

    @Query(value="update ticket set user_language = :userLanguage where uuid = :ticketIdentifier")
    public int updateOptionalTicketInfo(@Bind(value="ticketIdentifier") String var1, @Bind(value="userLanguage") String var2);

    @Query(value="select * from ticket where id = :id and category_id = :categoryId")
    public Ticket findById(@Bind(value="id") int var1, @Bind(value="categoryId") int var2);

    @Query(value="select exists(select id from ticket where id = :id and category_id = :categoryId)")
    public boolean isInCategory(@Bind(value="id") int var1, @Bind(value="categoryId") int var2);

    @Query(value="select * from ticket where id in (:ids)")
    public List<Ticket> findByIds(@Bind(value="ids") List<Integer> var1);

    @Query(value="select uuid from ticket where id in (:ids)")
    public List<String> findUUIDs(@Bind(value="ids") List<Integer> var1);

    @Query(value="select distinct tickets_reservation_id from ticket where id in (:ids)")
    public List<String> findReservationIds(@Bind(value="ids") List<Integer> var1);

    @Query(value="select * from ticket where special_price_id_fk = :specialPriceId")
    public Optional<Ticket> findBySpecialPriceId(@Bind(value="specialPriceId") int var1);

    @Query(value="update ticket set category_id = :targetCategoryId, src_price_cts = :srcPriceCts where id in (:ticketIds)")
    public int moveToAnotherCategory(@Bind(value="ticketIds") List<Integer> var1, @Bind(value="targetCategoryId") int var2, @Bind(value="srcPriceCts") int var3);

    @Query(value="select * from ticket where category_id in (:categories) and status = 'PENDING'")
    public List<Ticket> findPendingTicketsInCategories(@Bind(value="categories") List<Integer> var1);

    @Query(value="select  t.id t_id, t.uuid t_uuid, t.public_uuid t_public_uuid, t.creation t_creation, t.category_id t_category_id, t.status t_status, t.event_id t_event_id, t.src_price_cts t_src_price_cts, t.final_price_cts t_final_price_cts, t.vat_cts t_vat_cts, t.discount_cts t_discount_cts, t.tickets_reservation_id t_tickets_reservation_id, t.full_name t_full_name, t.first_name t_first_name, t.last_name t_last_name, t.email_address t_email_address, t.locked_assignment t_locked_assignment, t.user_language t_user_language, t.ext_reference t_ext_reference, t.currency_code t_currency_code, t.tags t_tags, t.subscription_id_fk t_subscription_id, t.vat_status t_vat_status,  tr.id tr_id, tr.validity tr_validity, tr.status tr_status, tr.full_name tr_full_name, tr.first_name tr_first_name, tr.last_name tr_last_name, tr.email_address tr_email_address, tr.billing_address tr_billing_address, tr.confirmation_ts tr_confirmation_ts, tr.latest_reminder_ts tr_latest_reminder_ts, tr.payment_method tr_payment_method,  tr.offline_payment_reminder_sent tr_offline_payment_reminder_sent, tr.promo_code_id_fk tr_promo_code_id_fk, tr.automatic tr_automatic, tr.user_language tr_user_language, tr.direct_assignment tr_direct_assignment, tr.invoice_number tr_invoice_number, tr.invoice_model tr_invoice_model,  tr.vat_status tr_vat_status, tr.vat_nr tr_vat_nr, tr.vat_country tr_vat_country, tr.invoice_requested tr_invoice_requested, tr.used_vat_percent tr_used_vat_percent, tr.vat_included tr_vat_included, tr.creation_ts tr_creation_ts, tr.registration_ts tr_registration_ts, tr.customer_reference tr_customer_reference,  tr.billing_address_company tr_billing_address_company, tr.billing_address_line1 tr_billing_address_line1, tr.billing_address_line2 tr_billing_address_line2, tr.billing_address_city tr_billing_address_city, tr.billing_address_state tr_billing_address_state, tr.billing_address_zip tr_billing_address_zip, tr.invoicing_additional_information tr_invoicing_additional_information,  tr.src_price_cts tr_src_price_cts, tr.final_price_cts tr_final_price_cts, tr.vat_cts tr_vat_cts, tr.discount_cts tr_discount_cts, tr.currency_code tr_currency_code,  tc.id tc_id, tc.inception tc_inception, tc.expiration tc_expiration, tc.max_tickets tc_max_tickets, tc.name tc_name, tc.src_price_cts tc_src_price_cts, tc.access_restricted tc_access_restricted, tc.tc_status tc_tc_status, tc.event_id tc_event_id, tc.bounded tc_bounded, tc.category_code tc_category_code,  tc.valid_checkin_from tc_valid_checkin_from, tc.valid_checkin_to tc_valid_checkin_to, tc.ticket_validity_start tc_ticket_validity_start, tc.ticket_validity_end tc_ticket_validity_end, tc.currency_code tc_currency_code, tc.ordinal tc_ordinal, tc.ticket_checkin_strategy tc_ticket_checkin_strategy, tc.ticket_access_type tc_ticket_access_type from ticket t  inner join tickets_reservation tr on t.tickets_reservation_id = tr.id  inner join ticket_category_with_currency tc on t.category_id = tc.id  where t.event_id = :eventId and t.full_name is not null and t.email_address is not null and t.id in (:ids) order by t.id asc")
    public List<FullTicketInfo> findAllFullTicketInfoAssignedByEventId(@Bind(value="eventId") int var1, @Bind(value="ids") List<Integer> var2);

    @Query(value="select t.id  from ticket t  join ticket_category tc on t.category_id = tc.id left outer join latest_ticket_update ltu on t.id = ltu.ticket_id and ltu.event_id = :eventId  where t.event_id = :eventId and tc.ticket_access_type <> 'ONLINE' and t.full_name is not null and t.email_address is not null and (coalesce(ltu.last_update, t.creation) > :changedSince)  order by t.id asc")
    public List<Integer> findAllAssignedByEventIdForCheckIn(@Bind(value="eventId") int var1, @Bind(value="changedSince") Date var2);

    @Query(value="select * from reservation_and_ticket_and_tx where t_id is not null and t_status in ('ACQUIRED', 'CHECKED_IN', 'TO_BE_PAID') and t_event_id = :eventId order by tr_confirmation_ts, t_id")
    public List<TicketWithReservationAndTransaction> findAllConfirmedForCSV(@Bind(value="eventId") int var1);

    @Query(value="select a.*, b.confirmation_ts from ticket a, tickets_reservation b where a.event_id = :eventId and a.status in('ACQUIRED', 'CHECKED_IN', 'TO_BE_PAID') and a.tickets_reservation_id = b.id order by b.confirmation_ts")
    public List<Ticket> findAllConfirmed(@Bind(value="eventId") int var1);

    @Query(value="select * from ticket where event_id = :eventId and status in('ACQUIRED', 'CHECKED_IN', 'TO_BE_PAID') and category_id = :categoryId")
    public List<Ticket> findConfirmedByCategoryId(@Bind(value="eventId") int var1, @Bind(value="categoryId") int var2);

    @Query(value="select count(*) from ticket where event_id = :eventId and status in('ACQUIRED', 'CHECKED_IN', 'TO_BE_PAID') and full_name is not null and email_address is not null")
    public Integer countAllAssigned(@Bind(value="eventId") int var1);

    @Query(value="select tickets_reservation_id from ticket where event_id = :eventId and status in('ACQUIRED', 'TO_BE_PAID') and (full_name is null or email_address is null) for update skip locked")
    public List<String> internalFindAllReservationsConfirmedButNotAssignedForUpdate(@Bind(value="eventId") int var1);

    default public Set<String> findAllReservationsConfirmedButNotAssignedForUpdate(int eventId) {
        return new TreeSet<String>(this.internalFindAllReservationsConfirmedButNotAssignedForUpdate(eventId));
    }

    @Query(value="select * from ticket where event_id = :eventId  and status in('ACQUIRED', 'TO_BE_PAID') and full_name is not null and email_address is not null and reminder_sent = false for update skip locked")
    public List<Ticket> findAllAssignedButNotYetNotifiedForUpdate(@Bind(value="eventId") int var1);

    @Query(value="update ticket set reminder_sent = true where id = :id and reminder_sent = false")
    public int flagTicketAsReminderSent(@Bind(value="id") int var1);

    @Query(value="update ticket set status = 'RELEASED', uuid = :newUuid, public_uuid = :newPublicUuid,  TICKETS_RESERVATION_ID = null, FULL_NAME = null, EMAIL_ADDRESS = null, SPECIAL_PRICE_ID_FK = null, LOCKED_ASSIGNMENT = false, USER_LANGUAGE = null, REMINDER_SENT = false, SRC_PRICE_CTS = 0, FINAL_PRICE_CTS = 0, VAT_CTS = 0, DISCOUNT_CTS = 0, FIRST_NAME = null, LAST_NAME = null, EXT_REFERENCE = null, TAGS = array[]::text[], VAT_STATUS = null, METADATA = '{}'::jsonb  where id = :ticketId and status in('ACQUIRED', 'PENDING', 'TO_BE_PAID') and tickets_reservation_id = :reservationId and event_id = :eventId")
    public int releaseTicket(@Bind(value="reservationId") String var1, @Bind(value="newUuid") String var2, @Bind(value="newPublicUuid") UUID var3, @Bind(value="eventId") int var4, @Bind(value="ticketId") int var5);

    default public int[] batchReleaseTickets(String reservationId, List<Integer> ticketIds, Event event) {
        MapSqlParameterSource[] args = (MapSqlParameterSource[])ticketIds.stream().map(id -> new MapSqlParameterSource("ticketId", id).addValue("reservationId", (Object)reservationId).addValue("eventId", (Object)event.getId()).addValue("newUuid", (Object)UUID.randomUUID().toString()).addValue("newPublicUuid", (Object)UUID.randomUUID())).toArray(MapSqlParameterSource[]::new);
        return this.getNamedParameterJdbcTemplate().batchUpdate(RELEASE_TICKET_QUERY, (SqlParameterSource[])args);
    }

    @Query(type=QueryType.TEMPLATE, value="update ticket set status = 'RELEASED', uuid = :newUuid, public_uuid = :newPublicUuid,  TICKETS_RESERVATION_ID = null, FULL_NAME = null, EMAIL_ADDRESS = null, SPECIAL_PRICE_ID_FK = null, LOCKED_ASSIGNMENT = false, USER_LANGUAGE = null, REMINDER_SENT = false, SRC_PRICE_CTS = 0, FINAL_PRICE_CTS = 0, VAT_CTS = 0, DISCOUNT_CTS = 0, FIRST_NAME = null, LAST_NAME = null, EXT_REFERENCE = null, TAGS = array[]::text[], VAT_STATUS = null, METADATA = '{}'::jsonb  where id = :ticketId and status = 'PENDING' and tickets_reservation_id = :reservationId and event_id = :eventId")
    public String batchReleaseTickets();

    public NamedParameterJdbcTemplate getNamedParameterJdbcTemplate();

    default public void resetTickets(List<Integer> ticketIds) {
        MapSqlParameterSource[] params = (MapSqlParameterSource[])ticketIds.stream().map(ticketId -> new MapSqlParameterSource("ticketId", ticketId).addValue("newUuid", (Object)UUID.randomUUID().toString()).addValue("newPublicUuid", (Object)UUID.randomUUID())).toArray(MapSqlParameterSource[]::new);
        this.getNamedParameterJdbcTemplate().batchUpdate("update ticket set status = 'RELEASED', uuid = :newUuid, public_uuid = :newPublicUuid,  TICKETS_RESERVATION_ID = null, FULL_NAME = null, EMAIL_ADDRESS = null, SPECIAL_PRICE_ID_FK = null, LOCKED_ASSIGNMENT = false, USER_LANGUAGE = null, REMINDER_SENT = false, SRC_PRICE_CTS = 0, FINAL_PRICE_CTS = 0, VAT_CTS = 0, DISCOUNT_CTS = 0, FIRST_NAME = null, LAST_NAME = null, EXT_REFERENCE = null, TAGS = array[]::text[], VAT_STATUS = null, METADATA = '{}'::jsonb  where id = :ticketId", (SqlParameterSource[])params);
    }

    @Query(value="select count(*) from ticket where status = 'RELEASED' and event_id = :eventId")
    public Integer countWaiting(@Bind(value="eventId") int var1);

    @Query(value="select t.id t_id, t.uuid t_uuid, t.public_uuid t_public_uuid, tc.id tc_id, tc.bounded tc_bounded, t.vat_status t_vat_status from ticket t inner join ticket_category tc on t.category_id = tc.id where t.event_id = :eventId and t.status = 'RELEASED' and tc.expiration <= :currentTs")
    public List<TicketInfo> findReleasedBelongingToExpiredCategories(@Bind(value="eventId") int var1, @Bind(value="currentTs") ZonedDateTime var2);

    @Query(value="select t.id t_id, t.uuid t_uuid, t.public_uuid t_public_uuid, tc.id tc_id, tc.bounded tc_bounded, t.vat_status t_vat_status from ticket t inner join ticket_category tc on t.category_id = tc.id where t.event_id = :eventId and t.tickets_reservation_id = :reservationId")
    public List<TicketInfo> findBasicTicketInfoForReservation(@Bind(value="eventId") int var1, @Bind(value="reservationId") String var2);

    @Query(value="update ticket set status = 'FREE' where status = 'RELEASED' and event_id = :eventId")
    public int revertToFree(@Bind(value="eventId") int var1);

    @Query(value="update ticket set status = 'FREE' where status = 'RELEASED' and event_id = :eventId and category_id = :categoryId and id in (:ticketIds)")
    public int revertToFree(@Bind(value="eventId") int var1, @Bind(value="categoryId") int var2, @Bind(value="ticketIds") List<Integer> var3);

    @Query(value="select * from ticket where status = :status and event_id = :eventId order by id limit :amount for update")
    public List<Ticket> selectWaitingTicketsForUpdate(@Bind(value="eventId") int var1, @Bind(value="status") String var2, @Bind(value="amount") int var3);

    @Query(value="select id from ticket where status = 'FREE' and event_id = :eventId and category_id = :categoryId order by id limit :amount for update skip locked")
    public List<Integer> selectFreeTicketsForPreReservation(@Bind(value="eventId") int var1, @Bind(value="amount") int var2, @Bind(value="categoryId") int var3);

    @Query(value="select id from ticket where status = 'FREE' and event_id = :eventId and category_id is null order by id limit :amount for update skip locked")
    public List<Integer> selectNotAllocatedFreeTicketsForPreReservation(@Bind(value="eventId") int var1, @Bind(value="amount") int var2);

    @Query(value="select count(*) from ticket where status = 'PRE_RESERVED'")
    public Integer countPreReservedTickets(@Bind(value="eventId") int var1);

    default public void preReserveTicket(List<Integer> ids) {
        MapSqlParameterSource[] params = (MapSqlParameterSource[])ids.stream().map(id -> new MapSqlParameterSource().addValue("id", id)).toArray(MapSqlParameterSource[]::new);
        this.getNamedParameterJdbcTemplate().batchUpdate("update ticket set status = 'PRE_RESERVED' where id = :id", (SqlParameterSource[])params);
    }

    @Query(value="select * from ticket where status = 'FREE' and event_id = :eventId")
    public List<Ticket> findFreeByEventId(@Bind(value="eventId") int var1);

    @Query(value="select count(*) from ticket where event_id = :eventId and category_id is not null and status <> 'INVALIDATED'")
    public Integer countAllocatedTicketsForEvent(@Bind(value="eventId") int var1);

    @Query(value="update ticket set status = 'FREE' where event_id = :eventId and category_id in(:categoryId) and status = 'RELEASED'")
    public int revertToFreeForRestrictedCategories(@Bind(value="eventId") int var1, @Bind(value="categoryId") List<Integer> var2);

    @Query(value="select distinct category_id from ticket where tickets_reservation_id = :reservationId and src_price_cts > 0")
    public List<Integer> getCategoriesIdToPayInReservation(@Bind(value="reservationId") String var1);

    @Query(value="select * from checkin_ticket_event_and_category_info where t_public_uuid = :publicUUID and e_short_name = :eventShortName and (e_format = 'ONLINE' or tc_ticket_access_type = 'ONLINE') ")
    public Optional<CheckInFullInfo> getFullInfoForOnlineCheckin(@Bind(value="eventShortName") String var1, @Bind(value="publicUUID") UUID var2);

    @Query(value="select * from checkin_ticket_event_and_category_info where e_id = :eventId and (:search is null or (lower(tr_id) like lower(:search) or lower(t_uuid) like lower(:search) or lower(t_public_uuid::text) like lower(:search) or lower(t_full_name) like lower(:search) or lower(t_first_name) like lower(:search) or lower(t_last_name) like lower(:search) or lower(t_email_address) like lower(:search) or   lower(tr_full_name) like lower(:search) or lower(tr_first_name) like lower(:search) or lower(tr_last_name) like lower(:search) or lower(tr_email_address) like lower(:search) or lower(tr_customer_reference) like lower(:search)   or (tr_invoice_number is not null and lower(tr_invoice_number) like lower(:search)) ) or lower(tc_name) like lower(:search)) and (e_format = 'IN_PERSON' or tc_ticket_access_type = 'IN_PERSON') order by t_last_name, t_first_name, t_uuid limit :limit offset :offset")
    public List<CheckInFullInfo> searchAttendees(@Bind(value="eventId") int var1, @Bind(value="search") String var2, @Bind(value="limit") int var3, @Bind(value="offset") int var4);

    @Query(value="select count(*) as total, count(*) filter (where t_status = 'CHECKED_IN') as checked_in from checkin_ticket_event_and_category_info where e_id = :eventId and (:search is null or (lower(tr_id) like lower(:search) or lower(t_uuid) like lower(:search) or lower(t_public_uuid::text) like lower(:search) or lower(t_full_name) like lower(:search) or lower(t_first_name) like lower(:search) or lower(t_last_name) like lower(:search) or lower(t_email_address) like lower(:search) or   lower(tr_full_name) like lower(:search) or lower(tr_first_name) like lower(:search) or lower(tr_last_name) like lower(:search) or lower(tr_email_address) like lower(:search) or lower(tr_customer_reference) like lower(:search)   or (tr_invoice_number is not null and lower(tr_invoice_number) like lower(:search)) ) or lower(tc_name) like lower(:search)) and (e_format = 'IN_PERSON' or tc_ticket_access_type = 'IN_PERSON') ")
    public AttendeeSearchResultsCount countSearchResults(@Bind(value="eventId") int var1, @Bind(value="search") String var2);

    @Query(value="update ticket set status = 'CHECKED_IN', locked_assignment = true where uuid = :uuid and event_id = :eventId and status = 'ACQUIRED'")
    public int performCheckIn(@Bind(value="uuid") String var1, @Bind(value="eventId") int var2);

    @Query(value="select t.id as t_id, t.first_name as t_first_name, t.last_name as t_last_name, t.email_address as t_email_address, tc.name as tc_name from ticket t  join ticket_category tc on t.category_id = tc.id where t.event_id = :eventId and t.status in ('ACQUIRED', 'TO_BE_PAID', 'CHECKED_IN') and t.tags @> ARRAY[ :tags ]::text[]")
    public List<PollParticipant> getTicketsForEventByTags(@Bind(value="eventId") int var1, @Bind(value="tags") List<String> var2);

    @Query(value="select count(*) from ticket t where t.event_id = :eventId and t.status in (:statuses) and t.tags @> ARRAY[ :tags ]::text[]")
    public Integer countTicketsMatchingTagsAndStatus(@Bind(value="eventId") int var1, @Bind(value="tags") List<String> var2, @Bind(value="statuses") Collection<String> var3);

    @Query(value="update ticket set tags = array_append(tags, :tag::text) where id in (:ticketIds) and event_id = :eventId")
    public int tagTickets(@Bind(value="ticketIds") List<Integer> var1, @Bind(value="eventId") int var2, @Bind(value="tag") String var3);

    @Query(value="update ticket set tags = array_remove(tags, :tag::text) where id in (:ticketIds) and event_id = :eventId")
    public int untagTickets(@Bind(value="ticketIds") List<Integer> var1, @Bind(value="eventId") int var2, @Bind(value="tag") String var3);

    @Query(value="update ticket set subscription_id_fk = :subscriptionId from  (select id from ticket where tickets_reservation_id = :reservationId order by final_price_cts limit :limit) t where ticket.id = t.id")
    public int applySubscriptionToTicketsInReservation(@Bind(value="reservationId") String var1, @Bind(value="subscriptionId") UUID var2, @Bind(value="limit") int var3);

    @Query(value="update ticket set subscription_id_fk = :subscriptionId from  (select id from ticket where tickets_reservation_id = :reservationId and category_id in (:categories) order by final_price_cts limit :limit) t where ticket.id = t.id")
    public int applySubscriptionToTicketsInReservation(@Bind(value="reservationId") String var1, @Bind(value="subscriptionId") UUID var2, @Bind(value="categories") Collection<Integer> var3, @Bind(value="limit") int var4);

    @Query(value="update ticket set subscription_id_fk = null where tickets_reservation_id = :reservationId")
    public int removeSubscriptionFromTicketsInReservation(@Bind(value="reservationId") String var1);

    @Query(value="select count(*) from ticket where subscription_id_fk = :subscriptionId and (:eventId is null or event_id = :eventId)")
    public Integer countSubscriptionUsage(@Bind(value="subscriptionId") UUID var1, @Bind(value="eventId") Integer var2);

    @JSONData
    @Query(value="select metadata::jsonb from ticket where id = :ticketId")
    public TicketMetadataContainer getTicketMetadata(@Bind(value="ticketId") int var1);

    @Query(value="update ticket set metadata = :metadata::jsonb where id = :ticketId")
    public int updateTicketMetadata(@Bind(value="ticketId") int var1, @JSONData @Bind(value="metadata") TicketMetadataContainer var2);

    @Query(value="update ticket set vat_status = :vatStatus::VAT_STATUS where tickets_reservation_id = :reservationId")
    public int updateVatStatusForReservation(@Bind(value="reservationId") String var1, @Bind(value="vatStatus") @EnumTypeAsString PriceContainer.VatStatus var2);

    @Query(value="select * from ticket where tickets_reservation_id = :reservationId order by category_id asc, uuid asc")
    public List<TicketWithMetadataAttributes> findTicketsInReservationWithMetadata(@Bind(value="reservationId") String var1);

    @Query(value="select t.id from ticket t    join event e on t.event_id = e.id    join tickets_reservation tr on t.tickets_reservation_id = tr.id    join all_ticket_field_values tfv on t.id = tfv.ticket_id_fk where e.short_name = :eventPublicIdentifier and tr.id = :reservationId")
    public List<Integer> findTicketsWithAdditionalData(@Bind(value="reservationId") String var1, @Bind(value="eventPublicIdentifier") String var2);

    @Query(value="select exists ( select id from ticket where uuid = :uuid and event_id = :eventId)")
    public boolean isTicketInEvent(@Bind(value="eventId") int var1, @Bind(value="uuid") String var2);
}

