/*
 * Decompiled with CFR 0.152.
 */
package alfio.repository;

import alfio.model.BillingDetails;
import alfio.model.PriceContainer;
import alfio.model.ReservationIdAndEventId;
import alfio.model.ReservationMetadata;
import alfio.model.ReservationWithPurchaseContext;
import alfio.model.TicketReservation;
import alfio.model.TicketReservationAdditionalInfo;
import alfio.model.TicketReservationInfo;
import alfio.model.TicketReservationStatusAndValidation;
import alfio.model.TicketReservationWithEventIdentifier;
import alfio.model.TicketsByDateStatistic;
import alfio.model.support.Array;
import alfio.model.support.JSONData;
import alfio.model.support.UserIdAndOrganizationId;
import ch.digitalfondue.npjt.Bind;
import ch.digitalfondue.npjt.Query;
import ch.digitalfondue.npjt.QueryRepository;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;

@QueryRepository
public interface TicketReservationRepository {
    @Query(value="insert into tickets_reservation(id, creation_ts, validity, promo_code_id_fk, status, user_language, event_id_fk, used_vat_percent, vat_included, currency_code, organization_id_fk, user_id_fk) values (:id, :creationTimestamp, :validity, :promotionCodeDiscountId, 'PENDING', :userLanguage, :eventId, :vatPercentage, :vatIncluded, :currencyCode, :organizationId, :userId)")
    public int createNewReservation(@Bind(value="id") String var1, @Bind(value="creationTimestamp") ZonedDateTime var2, @Bind(value="validity") Date var3, @Bind(value="promotionCodeDiscountId") Integer var4, @Bind(value="userLanguage") String var5, @Bind(value="eventId") Integer var6, @Bind(value="vatPercentage") BigDecimal var7, @Bind(value="vatIncluded") Boolean var8, @Bind(value="currencyCode") String var9, @Bind(value="organizationId") int var10, @Bind(value="userId") Integer var11);

    @Query(value="update tickets_reservation set user_id_fk = :userId where id = :reservationId")
    public int setReservationOwner(@Bind(value="reservationId") String var1, @Bind(value="userId") Integer var2);

    @Query(value="select user_id_fk user_id, organization_id_fk organization_id from tickets_reservation where id = :reservationId and user_id_fk is not null")
    public Optional<UserIdAndOrganizationId> getReservationOwnerAndOrganizationId(@Bind(value="reservationId") String var1);

    @Query(value="select * from tickets_reservation tr join ba_user u on u.id = tr.user_id_fk where u.username = :username")
    public List<TicketReservation> loadByOwner(@Bind(value="username") String var1);

    @Query(value="select user_language from tickets_reservation where id = :reservationId")
    public String loadUserLanguage(@Bind(value="reservationId") String var1);

    @Query(value="update tickets_reservation set billing_address = :billingAddress where id = :reservationId")
    public int updateBillingAddress(@Bind(value="billingAddress") String var1, @Bind(value="reservationId") String var2);

    @Query(value="update tickets_reservation set status = :status, full_name = :fullName, first_name = :firstName, last_name = :lastName, email_address = :email, user_language = :userLanguage, billing_address = :billingAddress, confirmation_ts = :timestamp, payment_method = :paymentMethod, customer_reference = :customerReference where id = :reservationId")
    public int updateTicketReservation(@Bind(value="reservationId") String var1, @Bind(value="status") String var2, @Bind(value="email") String var3, @Bind(value="fullName") String var4, @Bind(value="firstName") String var5, @Bind(value="lastName") String var6, @Bind(value="userLanguage") String var7, @Bind(value="billingAddress") String var8, @Bind(value="timestamp") ZonedDateTime var9, @Bind(value="paymentMethod") String var10, @Bind(value="customerReference") String var11);

    @Query(value="update tickets_reservation set validity = :validity, status = :status, payment_method = 'OFFLINE', full_name = :fullName, first_name = :firstName, last_name = :lastName, email_address = :email, billing_address = :billingAddress, customer_reference = :customerReference where id = :reservationId")
    public int postponePayment(@Bind(value="reservationId") String var1, @Bind(value="status") TicketReservation.TicketReservationStatus var2, @Bind(value="validity") Date var3, @Bind(value="email") String var4, @Bind(value="fullName") String var5, @Bind(value="firstName") String var6, @Bind(value="lastName") String var7, @Bind(value="billingAddress") String var8, @Bind(value="customerReference") String var9);

    @Query(value="update tickets_reservation set status = :status, confirmation_ts = :timestamp where id = :reservationId")
    public int confirmOfflinePayment(@Bind(value="reservationId") String var1, @Bind(value="status") String var2, @Bind(value="timestamp") ZonedDateTime var3);

    @Query(value="update tickets_reservation set full_name = :fullName where id = :reservationId")
    public int updateAssignee(@Bind(value="reservationId") String var1, @Bind(value="fullName") String var2);

    @Query(value="select count(id) from tickets_reservation where status in('OFFLINE_PAYMENT', 'DEFERRED_OFFLINE_PAYMENT') and event_id_fk = :eventId")
    public Integer findAllReservationsWaitingForPaymentCountInEventId(@Bind(value="eventId") int var1);

    @Query(value="select * from tickets_reservation where status = 'OFFLINE_PAYMENT' and date_trunc('day', validity) <= :expiration and offline_payment_reminder_sent = false for update skip locked")
    public List<TicketReservation> findAllOfflinePaymentReservationForNotificationForUpdate(@Bind(value="expiration") Date var1);

    @Query(value="select id, full_name, first_name, last_name, email_address, final_price_cts, currency_code, event_id_fk, validity from tickets_reservation where status = 'OFFLINE_PAYMENT' and date_trunc('day', validity) <= :expiration and event_id_fk = :eventId for update skip locked")
    public List<TicketReservationInfo> findAllOfflinePaymentReservationWithExpirationBeforeForUpdate(@Bind(value="expiration") ZonedDateTime var1, @Bind(value="eventId") int var2);

    @Query(value="update tickets_reservation set offline_payment_reminder_sent = true where id = :reservationId")
    public int flagAsOfflinePaymentReminderSent(@Bind(value="reservationId") String var1);

    @Query(value="update tickets_reservation set latest_reminder_ts = :latestReminderTimestamp where id = :reservationId")
    public int updateLatestReminderTimestamp(@Bind(value="reservationId") String var1, @Bind(value="latestReminderTimestamp") ZonedDateTime var2);

    @Query(value="update tickets_reservation set validity = :validity where id = :reservationId")
    public int updateValidity(@Bind(value="reservationId") String var1, @Bind(value="validity") Date var2);

    @Query(value="select id from tickets_reservation where id = :reservationId for update")
    public String lockReservationForUpdate(@Bind(value="reservationId") String var1);

    @Query(value="update tickets_reservation set status = :status where id = :reservationId")
    public int updateReservationStatus(@Bind(value="reservationId") String var1, @Bind(value="status") String var2);

    @Query(value="update tickets_reservation set status = :status where id in (:reservationIds)")
    public int updateReservationsStatus(@Bind(value="reservationIds") Collection<String> var1, @Bind(value="status") String var2);

    @Query(value="update tickets_reservation set registration_ts = :registrationTimestamp where id = :reservationId")
    public int updateRegistrationTimestamp(@Bind(value="reservationId") String var1, @Bind(value="registrationTimestamp") ZonedDateTime var2);

    @Query(value="select * from tickets_reservation where id = :id")
    public TicketReservation findReservationById(@Bind(value="id") String var1);

    @Query(value="select * from tickets_reservation where id = :id for update")
    public TicketReservation findReservationByIdForUpdate(@Bind(value="id") String var1);

    @Query(value="select * from tickets_reservation where id = :id and event_id_fk = :eventId")
    public Optional<TicketReservation> findOptionalReservationByIdAndEventId(@Bind(value="id") String var1, @Bind(value="eventId") int var2);

    @Query(value="select * from tickets_reservation where id = :id")
    public Optional<TicketReservation> findOptionalReservationById(@Bind(value="id") String var1);

    @Query(value="select status, validated_for_overview from tickets_reservation where id = :id")
    public Optional<TicketReservationStatusAndValidation> findOptionalStatusAndValidationById(@Bind(value="id") String var1);

    @Query(value="select id from tickets_reservation where validity < :date and status = 'PENDING' for update skip locked")
    public List<String> findExpiredReservationForUpdate(@Bind(value="date") Date var1);

    @Query(value="select distinct tr.* from tickets_reservation tr join b_transaction tx on tx.reservation_id = tr.id where tr.id in (:reservationIds) and tr.status = 'PENDING'")
    public List<TicketReservation> findReservationsWithPendingTransaction(@Bind(value="reservationIds") Collection<String> var1);

    @Query(value="select id from tickets_reservation where validity < :date and status = 'OFFLINE_PAYMENT' for update skip locked")
    public List<String> findExpiredOfflineReservationsForUpdate(@Bind(value="date") Date var1);

    @Query(value="select id, event_id_fk from tickets_reservation where validity < :date and status in ('IN_PAYMENT', 'EXTERNAL_PROCESSING_PAYMENT') and event_id_fk is not null for update skip locked")
    public List<ReservationIdAndEventId> findStuckReservationsForUpdate(@Bind(value="date") Date var1);

    @Query(value="delete from tickets_reservation where id in (:ids)")
    public int remove(@Bind(value="ids") List<String> var1);

    @Query(value="select * from tickets_reservation where id like :partialID")
    public List<TicketReservation> findByPartialID(@Bind(value="partialID") String var1);

    @Query(value="update tickets_reservation set invoice_model = :invoiceModel where id = :reservationId")
    public int addReservationInvoiceOrReceiptModel(@Bind(value="reservationId") String var1, @Bind(value="invoiceModel") String var2);

    @Query(value="update tickets_reservation set invoice_number = :invoiceNumber where id = :reservationId and invoice_number is null")
    public int setInvoiceNumber(@Bind(value="reservationId") String var1, @Bind(value="invoiceNumber") String var2);

    @Query(value="update tickets_reservation set vat_status = :vatStatus, src_price_cts = :srcPriceCts,  final_price_cts = :finalPriceCts, vat_cts = :vatCts, discount_cts = :discountCts, currency_code = :currencyCode,  vat_nr = :vatNr, vat_country = :vatCountry, invoice_requested = :invoiceRequested where id = :reservationId")
    public int updateBillingData(@Bind(value="vatStatus") PriceContainer.VatStatus var1, @Bind(value="srcPriceCts") int var2, @Bind(value="finalPriceCts") int var3, @Bind(value="vatCts") int var4, @Bind(value="discountCts") int var5, @Bind(value="currencyCode") String var6, @Bind(value="vatNr") String var7, @Bind(value="vatCountry") String var8, @Bind(value="invoiceRequested") boolean var9, @Bind(value="reservationId") String var10);

    @Query(value="select min(confirmation_ts) from tickets_reservation where event_id_fk = :eventId and confirmation_ts is not null")
    public Optional<ZonedDateTime> getFirstConfirmationTimestampForEvent(@Bind(value="eventId") int var1);

    @Query(value="select min(creation_ts) from tickets_reservation where event_id_fk = :eventId")
    public Optional<ZonedDateTime> getFirstReservationCreatedTimestampForEvent(@Bind(value="eventId") int var1);

    @Query(value="select to_char(date_trunc(:granularity, d.day), 'YYYY-MM-DD') as day, count(ticket.id) ticket_count  from (select generate_series(lower(r), upper(r), '1 day')::date as day, generate_series(lower(r), upper(r), '1 day')::timestamp as ts from tsrange(:fromDate::timestamp, :toDate::timestamp) r) as d  left join (select id, confirmation_ts from tickets_reservation where confirmation_ts is not null and event_id_fk = :eventId) res on date_trunc('day', res.confirmation_ts) = d.day left join ticket on event_id = :eventId and tickets_reservation_id = res.id group by 1 order by 1")
    public List<TicketsByDateStatistic> getSoldStatistic(@Bind(value="eventId") int var1, @Bind(value="fromDate") ZonedDateTime var2, @Bind(value="toDate") ZonedDateTime var3, @Bind(value="granularity") String var4);

    @Query(value="select to_char(date_trunc(:granularity, d.day), 'YYYY-MM-DD') as day, count(ticket.id) ticket_count  from (select generate_series(lower(r), upper(r), '1 day')::date as day, generate_series(lower(r), upper(r), '1 day')::timestamp as ts from tsrange(:fromDate::timestamp, :toDate::timestamp) r) as d  left join (select id, creation_ts from tickets_reservation where event_id_fk = :eventId and status in ('IN_PAYMENT', 'EXTERNAL_PROCESSING_PAYMENT', 'OFFLINE_PAYMENT', 'DEFERRED_OFFLINE_PAYMENT', 'COMPLETE', 'STUCK')) res on date_trunc('day', res.creation_ts) = d.day  left join ticket on event_id = :eventId and tickets_reservation_id = res.id group by 1 order by 1")
    public List<TicketsByDateStatistic> getReservedStatistic(@Bind(value="eventId") int var1, @Bind(value="fromDate") ZonedDateTime var2, @Bind(value="toDate") ZonedDateTime var3, @Bind(value="granularity") String var4);

    @Query(value="select id, event_id_fk from tickets_reservation where id in (:ids) and event_id_fk is not null")
    public List<ReservationIdAndEventId> getReservationIdAndEventId(@Bind(value="ids") Collection<String> var1);

    @Query(value="select * from tickets_reservation where id in (:ids)")
    public List<TicketReservation> findByIds(@Bind(value="ids") Collection<String> var1);

    @Query(value="update tickets_reservation set full_name = :fullName, first_name = :firstName, last_name = :lastName, email_address = :email,  billing_address = :completeBillingAddress, vat_country = :vatCountry, vat_nr = :vatNr,  invoice_requested = :invoiceRequested,  billing_address_company = :billingAddressCompany,  billing_address_line1 = :billingAddressLine1,  billing_address_line2 = :billingAddressLine2,  billing_address_zip = :billingAddressZip,  billing_address_city = :billingAddressCity,  billing_address_state = :billingAddressState,  add_company_billing_details = :addCompanyBillingDetails,  skip_vat_nr = :skipVatNr,  customer_reference = :customerReference,  validated_for_overview = :validated  where id = :reservationId")
    public int updateTicketReservationWithValidation(@Bind(value="reservationId") String var1, @Bind(value="fullName") String var2, @Bind(value="firstName") String var3, @Bind(value="lastName") String var4, @Bind(value="email") String var5, @Bind(value="billingAddressCompany") String var6, @Bind(value="billingAddressLine1") String var7, @Bind(value="billingAddressLine2") String var8, @Bind(value="billingAddressZip") String var9, @Bind(value="billingAddressCity") String var10, @Bind(value="billingAddressState") String var11, @Bind(value="completeBillingAddress") String var12, @Bind(value="vatCountry") String var13, @Bind(value="vatNr") String var14, @Bind(value="invoiceRequested") boolean var15, @Bind(value="addCompanyBillingDetails") boolean var16, @Bind(value="skipVatNr") boolean var17, @Bind(value="customerReference") String var18, @Bind(value="validated") boolean var19);

    @Query(value="select billing_address_company, billing_address_line1, billing_address_line2,  billing_address_zip, billing_address_city, billing_address_state, validated_for_overview, skip_vat_nr,  add_company_billing_details, invoicing_additional_information, vat_country, vat_nr  from tickets_reservation where id = :id")
    public TicketReservationAdditionalInfo getAdditionalInfo(@Bind(value="id") String var1);

    @Query(value="select metadata from tickets_reservation where id = :id")
    @JSONData
    public ReservationMetadata getMetadata(@Bind(value="id") String var1);

    @Query(value="select metadata->'finalized' = 'true' as finalized from tickets_reservation where id = :id")
    public Boolean checkIfFinalized(@Bind(value="id") String var1);

    @Query(value="update tickets_reservation set metadata = :metadata::jsonb where id = :id")
    public int setMetadata(@Bind(value="id") String var1, @Bind(value="metadata") @JSONData ReservationMetadata var2);

    @Query(value="update tickets_reservation set validated_for_overview = :validated where id = :reservationId")
    public int updateValidationStatus(@Bind(value="reservationId") String var1, @Bind(value="validated") boolean var2);

    @Query(value="update tickets_reservation set invoice_requested = :invoiceRequested, vat_status = :vatStatus, src_price_cts = :srcPriceCts,  final_price_cts = :finalPriceCts, vat_cts = :vatCts, discount_cts = :discountCts, currency_code = :currencyCode where id = :reservationId")
    public int resetVat(@Bind(value="reservationId") String var1, @Bind(value="invoiceRequested") boolean var2, @Bind(value="vatStatus") PriceContainer.VatStatus var3, @Bind(value="srcPriceCts") int var4, @Bind(value="finalPriceCts") int var5, @Bind(value="vatCts") int var6, @Bind(value="discountCts") int var7, @Bind(value="currencyCode") String var8);

    default public Integer countTicketsInReservationForCategories(String reservationId, Collection<Integer> categories) {
        if (categories == null || categories.isEmpty()) {
            return this.countTicketsInReservationNoCategories(reservationId);
        }
        return this.countTicketsInReservationForExistingCategories(reservationId, categories);
    }

    @Query(value="select count(b.id) from tickets_reservation a, ticket b where a.id = :reservationId and b.tickets_reservation_id = a.id and (b.category_id in (:categories))")
    public Integer countTicketsInReservationForExistingCategories(@Bind(value="reservationId") String var1, @Bind(value="categories") Collection<Integer> var2);

    @Query(value="select count(b.id) from tickets_reservation a, ticket b where a.id = :reservationId and b.tickets_reservation_id = a.id")
    public Integer countTicketsInReservationNoCategories(@Bind(value="reservationId") String var1);

    @Query(value="select billing_address_company, billing_address_line1, billing_address_line2, billing_address_zip, billing_address_city, billing_address_state, vat_nr, vat_country, invoicing_additional_information from tickets_reservation where id = :reservationId")
    public BillingDetails getBillingDetailsForReservation(@Bind(value="reservationId") String var1);

    @Query(value="update tickets_reservation set invoicing_additional_information = :info::json where id = :id")
    public int updateInvoicingAdditionalInformation(@Bind(value="id") String var1, @Bind(value="info") String var2);

    @Query(value="select event_id_fk from tickets_reservation where id = :id")
    public Optional<Integer> findEventIdFor(@Bind(value="id") String var1);

    @Query(value="select exists (select * from tickets_reservation where id = :id and subscription_id_fk is not null)")
    public boolean hasSubscriptionApplied(@Bind(value="id") String var1);

    @Query(value="update tickets_reservation set subscription_id_fk = :subscriptionId where id = :reservationId")
    public int applySubscription(@Bind(value="reservationId") String var1, @Bind(value="subscriptionId") UUID var2);

    @Query(value="select tr.*, e.short_name from tickets_reservation tr join event e on e.id = tr.event_id_fk where tr.subscription_id_fk = :subscriptionId and tr.status = 'COMPLETE'")
    public List<TicketReservationWithEventIdentifier> findConfirmedReservationsBySubscriptionId(@Bind(value="subscriptionId") UUID var1);

    @Query(value="select * from reservation_with_purchase_context where tr_user_id_fk = :userId order by tr_creation_ts desc")
    public List<ReservationWithPurchaseContext> findAllReservationsForUser(@Bind(value="userId") int var1);

    @Query(value="update tickets_reservation set vat_status = :vatStatus where id = :reservationId")
    public int updateVatStatus(@Bind(value="reservationId") String var1, @Bind(value="vatStatus") PriceContainer.VatStatus var2);

    @Query(value="select count(id) from tickets_reservation where id in (:ids) and event_id_fk = :eventId")
    public int countReservationsWithEventId(@Bind(value="ids") Set<String> var1, @Bind(value="eventId") int var2);

    @Query(value="SELECT count(id) from tickets_reservation where id like ANY(\n            select s || '%' from unnest(:ids::text[]) s(s)\n        ) and event_id_fk = :eventId\n")
    public int countReservationWithShortIdsForEvent(@Bind(value="ids") @Array List<String> var1, @Bind(value="eventId") int var2);

    @Query(value="select exists(select id from b_transaction where id = :transactionId and reservation_id = reservationId)")
    public boolean hasReservationWithTransactionId(@Bind(value="reservationId") String var1, @Bind(value="transactionId") int var2);
}

