/*
 * Decompiled with CFR 0.152.
 */
package alfio.repository;

import alfio.model.support.JSONData;
import alfio.model.transaction.PaymentProxy;
import alfio.model.transaction.Transaction;
import ch.digitalfondue.npjt.Bind;
import ch.digitalfondue.npjt.Query;
import ch.digitalfondue.npjt.QueryRepository;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@QueryRepository
public interface TransactionRepository {
    public static final String SELECT_BY_RESERVATION_ID = "select * from b_transaction where reservation_id = :reservationId";
    public static final String SELECT_VALID_BY_RESERVATION_ID = "select * from b_transaction where reservation_id = :reservationId and status not in ('INVALID', 'OFFLINE_DISABLE_MATCH')";
    public static final String UPDATE_TRANSACTION_BY_ID = "update b_transaction set gtw_tx_id = :gatewayTransactionId, gtw_payment_id = :paymentId, t_timestamp = :timestamp, plat_fee = :platformFee, gtw_fee = :gatewayFee, status = :status, metadata = to_json(:metadata::json) where id = :transactionId";

    @Query(value="insert into b_transaction(gtw_tx_id, gtw_payment_id, reservation_id, t_timestamp, price_cts, currency, description, payment_proxy, plat_fee, gtw_fee, status, metadata) values(:transactionId, :paymentId, :reservationId, :timestamp, :priceInCents, :currency, :description, :paymentProxy, :platformFee, :gatewayFee, :status, to_json(:metadata::json))")
    public int insert(@Bind(value="transactionId") String var1, @Bind(value="paymentId") String var2, @Bind(value="reservationId") String var3, @Bind(value="timestamp") ZonedDateTime var4, @Bind(value="priceInCents") int var5, @Bind(value="currency") String var6, @Bind(value="description") String var7, @Bind(value="paymentProxy") String var8, @Bind(value="platformFee") long var9, @Bind(value="gatewayFee") long var11, @Bind(value="status") Transaction.Status var13, @Bind(value="metadata") @JSONData Map<String, String> var14);

    @Query(value="update b_transaction set gtw_tx_id = :gatewayTransactionId, gtw_payment_id = :paymentId, t_timestamp = :timestamp, plat_fee = :platformFee, gtw_fee = :gatewayFee, status = :status, metadata = to_json(:metadata::json) where id = :transactionId")
    public int update(@Bind(value="transactionId") int var1, @Bind(value="gatewayTransactionId") String var2, @Bind(value="paymentId") String var3, @Bind(value="timestamp") ZonedDateTime var4, @Bind(value="platformFee") long var5, @Bind(value="gatewayFee") long var7, @Bind(value="status") Transaction.Status var9, @Bind(value="metadata") @JSONData Map<String, String> var10);

    @Query(value="update b_transaction set gtw_tx_id = :gatewayTransactionId, gtw_payment_id = :paymentId, t_timestamp = :timestamp, plat_fee = :platformFee, gtw_fee = :gatewayFee, status = :status, metadata = to_json(:metadata::json) where id = :transactionId and status = :expectedStatus")
    public int updateIfStatus(@Bind(value="transactionId") int var1, @Bind(value="gatewayTransactionId") String var2, @Bind(value="paymentId") String var3, @Bind(value="timestamp") ZonedDateTime var4, @Bind(value="platformFee") long var5, @Bind(value="gatewayFee") long var7, @Bind(value="status") Transaction.Status var9, @Bind(value="metadata") @JSONData Map<String, String> var10, @Bind(value="expectedStatus") Transaction.Status var11);

    @Query(value="select * from b_transaction where reservation_id = :reservationId and status not in ('INVALID', 'OFFLINE_DISABLE_MATCH') order by t_timestamp desc limit 1 for update")
    public Optional<Transaction> lockLatestForUpdate(@Bind(value="reservationId") String var1);

    @Query(value="select id from b_transaction where id = :id for update")
    public Integer lockByIdForUpdate(@Bind(value="id") Integer var1);

    @Query(value="update b_transaction set status = :status where reservation_id = :reservationId")
    public int updateStatusForReservation(@Bind(value="reservationId") String var1, @Bind(value="status") Transaction.Status var2);

    @Query(value="update b_transaction set status = 'OFFLINE_DISABLE_MATCH' where id = :id and status = 'OFFLINE_PENDING_REVIEW'")
    public int discardMatchingPayment(@Bind(value="id") int var1);

    @Query(value="select * from b_transaction where reservation_id = :reservationId and status not in ('INVALID', 'OFFLINE_DISABLE_MATCH')")
    public Transaction loadByReservationId(@Bind(value="reservationId") String var1);

    @Query(value="delete from b_transaction where reservation_id in (:reservationIds)")
    public int deleteForReservations(@Bind(value="reservationIds") List<String> var1);

    @Query(value="update b_transaction set status = 'INVALID' where reservation_id = :reservationId and status <> 'COMPLETE' and  (:paymentProxy is null or (:paymentProxy is not null and payment_proxy = :paymentProxy)) ")
    public int invalidateForReservation(@Bind(value="reservationId") String var1, @Bind(value="paymentProxy") String var2);

    @Query(value="delete from b_transaction where reservation_id in (:reservationIds) and status = :status")
    public int deleteForReservationsWithStatus(@Bind(value="reservationIds") List<String> var1, @Bind(value="status") Transaction.Status var2);

    @Query(value="select * from b_transaction where reservation_id = :reservationId and status not in ('INVALID', 'OFFLINE_DISABLE_MATCH')")
    public Optional<Transaction> loadOptionalByReservationId(@Bind(value="reservationId") String var1);

    @Query(value="select exists (select * from b_transaction where reservation_id = :reservationId and status not in ('INVALID', 'OFFLINE_DISABLE_MATCH'))")
    public boolean transactionExists(@Bind(value="reservationId") String var1);

    @Query(value="select * from b_transaction where reservation_id = :reservationId and status not in ('INVALID', 'OFFLINE_DISABLE_MATCH') and status = :status")
    public Optional<Transaction> loadOptionalByReservationIdAndStatus(@Bind(value="reservationId") String var1, @Bind(value="status") Transaction.Status var2);

    @Query(value="select * from b_transaction where reservation_id = :reservationId and status not in ('INVALID', 'OFFLINE_DISABLE_MATCH') and status = :status for update")
    public Optional<Transaction> loadOptionalByReservationIdAndStatusForUpdate(@Bind(value="reservationId") String var1, @Bind(value="status") Transaction.Status var2);

    @Query(value="select * from b_transaction where reservation_id = :reservationId and status not in ('INVALID', 'OFFLINE_DISABLE_MATCH') and status = :status and payment_proxy = :paymentProxy")
    public Optional<Transaction> loadOptionalByStatusAndPaymentProxyForUpdate(@Bind(value="reservationId") String var1, @Bind(value="status") Transaction.Status var2, @Bind(value="paymentProxy") PaymentProxy var3);

    @Query(value="select * from b_transaction where id = :id and status = :status")
    public Optional<Transaction> loadOptionalByIdAndStatus(@Bind(value="id") int var1, @Bind(value="status") Transaction.Status var2);

    @Query(value="update b_transaction set plat_fee = :platformFee, gtw_fee = :gatewayFee where gtw_tx_id = :transactionId and reservation_id = :reservationId")
    public int updateFees(@Bind(value="transactionId") String var1, @Bind(value="reservationId") String var2, @Bind(value="platformFee") long var3, @Bind(value="gatewayFee") long var5);

    @Query(value="update b_transaction set status = 'INVALID' where id = :id")
    public int invalidateById(@Bind(value="id") int var1);

    @Query(value="update b_transaction set metadata = :metadata::jsonb, t_timestamp = :timestamp where id = :id")
    public int updateDetailsById(@Bind(value="id") int var1, @Bind(value="metadata") @JSONData Map<String, String> var2, @Bind(value="timestamp") ZonedDateTime var3);
}

