/*
 * Decompiled with CFR 0.152.
 */
package alfio.repository;

import alfio.model.UploadedResource;
import alfio.model.modification.UploadBase64FileModification;
import ch.digitalfondue.npjt.Bind;
import ch.digitalfondue.npjt.Query;
import ch.digitalfondue.npjt.QueryRepository;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.support.lob.DefaultLobHandler;

@QueryRepository
public interface UploadedResourceRepository {
    public static final Function<OutputStream, RowCallbackHandler> OUTPUT_CONTENT = out -> rs -> {
        try (InputStream is = rs.getBinaryStream("content");){
            is.transferTo((OutputStream)out);
        }
        catch (IOException e) {
            throw new IllegalStateException("Error while copying data", e);
        }
    };

    @Query(value="select exists(select name from resource_global where name = :name) as res")
    public boolean hasResource(@Bind(value="name") String var1);

    @Query(value="select exists(select name from resource_organizer where name = :name and organization_id_fk = :organizationId) as res")
    public boolean hasResource(@Bind(value="organizationId") int var1, @Bind(value="name") String var2);

    @Query(value="select exists(select name from resource_event where name = :name and organization_id_fk = :organizationId  and event_id_fk = :eventId) as res")
    public boolean hasResource(@Bind(value="organizationId") int var1, @Bind(value="eventId") int var2, @Bind(value="name") String var3);

    @Query(value="select name, content_size, content_type, creation_time, attributes, null as organization_id_fk, null as event_id_fk  from resource_global where name = :name")
    public UploadedResource get(@Bind(value="name") String var1);

    @Query(value="select name, content_size, content_type, creation_time, attributes, organization_id_fk, null as event_id_fk from resource_organizer where organization_id_fk = :organizationId  and name = :name")
    public UploadedResource get(@Bind(value="organizationId") int var1, @Bind(value="name") String var2);

    @Query(value="select name, content_size, content_type, creation_time, attributes, organization_id_fk, event_id_fk from resource_event where organization_id_fk = :organizationId  and event_id_fk = :eventId and name = :name")
    public UploadedResource get(@Bind(value="organizationId") int var1, @Bind(value="eventId") int var2, @Bind(value="name") String var3);

    @Query(value="select name, content_size, content_type, creation_time, attributes, null as organization_id_fk, null as event_id_fk  from resource_global order by name asc")
    public List<UploadedResource> findAll();

    @Query(value="select name, content_size, content_type, creation_time, attributes, organization_id_fk, null as event_id_fk from resource_organizer where organization_id_fk = :organizationId order by name asc")
    public List<UploadedResource> findAll(@Bind(value="organizationId") int var1);

    @Query(value="select name, content_size, content_type, creation_time, attributes, organization_id_fk, event_id_fk from resource_event where organization_id_fk = :organizationId  and event_id_fk = :eventId order by name asc")
    public List<UploadedResource> findAll(@Bind(value="organizationId") int var1, @Bind(value="eventId") int var2);

    @Query(value="delete from resource_global where name = :name")
    public int delete(@Bind(value="name") String var1);

    @Query(value="delete from resource_organizer where name = :name and organization_id_fk = :organizationId")
    public int delete(@Bind(value="organizationId") int var1, @Bind(value="name") String var2);

    @Query(value="delete from resource_event where name = :name and organization_id_fk = :organizationId and event_id_fk = :eventId")
    public int delete(@Bind(value="organizationId") int var1, @Bind(value="eventId") int var2, @Bind(value="name") String var3);

    default public void fileContent(String name, OutputStream out) {
        MapSqlParameterSource param = new MapSqlParameterSource("name", (Object)name);
        this.getNamedParameterJdbcTemplate().query("select content from resource_global where name = :name", (SqlParameterSource)param, (RowCallbackHandler)OUTPUT_CONTENT.apply(out));
    }

    default public void fileContent(int organizationId, String name, OutputStream out) {
        MapSqlParameterSource param = new MapSqlParameterSource("name", (Object)name).addValue("organizationId", (Object)organizationId);
        this.getNamedParameterJdbcTemplate().query("select content from resource_organizer where name = :name and organization_id_fk = :organizationId", (SqlParameterSource)param, (RowCallbackHandler)OUTPUT_CONTENT.apply(out));
    }

    default public void fileContent(int organizationId, int eventId, String name, OutputStream out) {
        MapSqlParameterSource param = new MapSqlParameterSource("name", (Object)name).addValue("organizationId", (Object)organizationId).addValue("eventId", (Object)eventId);
        this.getNamedParameterJdbcTemplate().query("select content from resource_event where name = :name and organization_id_fk = :organizationId and event_id_fk = :eventId", (SqlParameterSource)param, (RowCallbackHandler)OUTPUT_CONTENT.apply(out));
    }

    public NamedParameterJdbcTemplate getNamedParameterJdbcTemplate();

    default public int upload(Integer organizationId, Integer eventId, UploadBase64FileModification file, Map<String, String> attributes) {
        DefaultLobHandler lobHandler = new DefaultLobHandler();
        String query = "insert into resource_global (name, content_size, content, content_type, attributes) values(?, ?, ?, ?, ?)";
        if (organizationId != null && eventId != null) {
            query = "insert into resource_event (name, content_size, content, content_type, attributes, organization_id_fk, event_id_fk) values(?, ?, ?, ?, ?, ?, ?)";
        } else if (organizationId != null) {
            query = "insert into resource_organizer (name, content_size, content, content_type, attributes, organization_id_fk) values(?, ?, ?, ?, ?, ?)";
        }
        return Objects.requireNonNullElse((Integer)this.getNamedParameterJdbcTemplate().getJdbcOperations().execute(query, (PreparedStatementCallback)new /* Unavailable Anonymous Inner Class!! */), 0);
    }
}

