/*
 * Decompiled with CFR 0.152.
 */
package alfio.repository;

import alfio.model.WaitingQueueSubscription;
import ch.digitalfondue.npjt.AffectedRowCountAndKey;
import ch.digitalfondue.npjt.AutoGeneratedKey;
import ch.digitalfondue.npjt.Bind;
import ch.digitalfondue.npjt.Query;
import ch.digitalfondue.npjt.QueryRepository;
import java.time.ZonedDateTime;
import java.util.List;

@QueryRepository
public interface WaitingQueueRepository {
    @Query(value="select * from waiting_queue where event_id = :eventId and status = 'WAITING' order by creation")
    public List<WaitingQueueSubscription> loadAllWaiting(@Bind(value="eventId") int var1);

    @Query(value="select * from waiting_queue where event_id = :eventId and status = 'WAITING' order by creation for update")
    public List<WaitingQueueSubscription> loadAllWaitingForUpdate(@Bind(value="eventId") int var1);

    @Query(value="select * from waiting_queue where event_id = :eventId order by creation")
    public List<WaitingQueueSubscription> loadAll(@Bind(value="eventId") int var1);

    @Query(value="select * from waiting_queue where id = :id")
    public WaitingQueueSubscription loadById(@Bind(value="id") int var1);

    @Query(value="select exists (select * from waiting_queue where id = :id and event_id = :eventId)")
    public boolean exists(@Bind(value="id") int var1, @Bind(value="eventId") int var2);

    @Query(value="select * from waiting_queue where event_id = :eventId and status = 'WAITING' order by creation, id limit :max for update")
    public List<WaitingQueueSubscription> loadWaiting(@Bind(value="eventId") int var1, @Bind(value="max") int var2);

    @Query(value="insert into waiting_queue (event_id, full_name, first_name, last_name, email_address, creation, status, user_language, subscription_type, selected_category_id) values(:eventId, :fullName, :firstName, :lastName, :emailAddress, :creation, 'WAITING', :userLanguage, :subscriptionType, :selectedCategoryId)")
    @AutoGeneratedKey(value="id")
    public AffectedRowCountAndKey<Integer> insert(@Bind(value="eventId") int var1, @Bind(value="fullName") String var2, @Bind(value="firstName") String var3, @Bind(value="lastName") String var4, @Bind(value="emailAddress") String var5, @Bind(value="creation") ZonedDateTime var6, @Bind(value="userLanguage") String var7, @Bind(value="subscriptionType") WaitingQueueSubscription.Type var8, @Bind(value="selectedCategoryId") Integer var9);

    @Query(value="update waiting_queue set status = :status where ticket_reservation_id = :reservationId")
    public int updateStatusByReservationId(@Bind(value="reservationId") String var1, @Bind(value="status") String var2);

    @Query(value="update waiting_queue set status = 'EXPIRED', ticket_reservation_id = null where ticket_reservation_id in (:ticketReservationIds)")
    public int bulkUpdateExpiredReservations(@Bind(value="ticketReservationIds") List<String> var1);

    @Query(value="select count(*) from waiting_queue where event_id = :eventId and status = 'WAITING'")
    public Integer countWaitingPeople(@Bind(value="eventId") int var1);

    @Query(value="update waiting_queue set ticket_reservation_id = :ticketReservationId, status = 'PENDING' where id = :id")
    public int flagAsPending(@Bind(value="ticketReservationId") String var1, @Bind(value="id") int var2);

    @Query(value="update waiting_queue set status = :newStatus where id = :id and status = :expectedStatus")
    public int updateStatus(@Bind(value="id") int var1, @Bind(value="newStatus") WaitingQueueSubscription.Status var2, @Bind(value="expectedStatus") WaitingQueueSubscription.Status var3);
}

