/*
 * Decompiled with CFR 0.152.
 */
package alfio.repository.audit;

import alfio.manager.support.CheckInStatus;
import alfio.model.api.v1.admin.CheckInLogEntry;
import alfio.model.audit.ScanAudit;
import ch.digitalfondue.npjt.Bind;
import ch.digitalfondue.npjt.Query;
import ch.digitalfondue.npjt.QueryRepository;
import java.time.ZonedDateTime;
import java.util.List;

@QueryRepository
public interface ScanAuditRepository {
    @Query(value="insert into scan_audit(ticket_uuid, event_id_fk, scan_ts, username, check_in_status, operation) values(:ticketUuid, :eventId, :scanTs, :username, :status, :operation)")
    public Integer insert(@Bind(value="ticketUuid") String var1, @Bind(value="eventId") int var2, @Bind(value="scanTs") ZonedDateTime var3, @Bind(value="username") String var4, @Bind(value="status") CheckInStatus var5, @Bind(value="operation") ScanAudit.Operation var6);

    @Query(value="select * from scan_audit where event_id_fk = :eventId")
    public List<ScanAudit> findAllForEvent(@Bind(value="eventId") int var1);

    @Query(value="select t.uuid t_uuid, jsonb_build_object('firstName', t.first_name, 'lastName', t.last_name, 'email', t.email_address, 'metadata', coalesce(t.metadata::jsonb#>'{metadataMap, general, attributes}', '{}')) attendee_data, jsonb_agg(jsonb_build_object('ticketUuid', sa.ticket_uuid, 'scanTimestamp', sa.scan_ts, 'username', sa.username, 'checkInStatus', sa.check_in_status, 'operation', sa.operation)) scans from ticket t\n    join event e on t.event_id = e.id    join scan_audit sa on e.id = sa.event_id_fk and t.uuid = sa.ticket_uuid    where e.id = :eventId    and t.status = 'CHECKED_IN'    group by 1,2")
    public List<CheckInLogEntry> loadEntries(@Bind(value="eventId") int var1);
}

