/*
 * Decompiled with CFR 0.152.
 */
package alfio.repository.system;

import alfio.manager.system.AdminJobExecutor;
import alfio.model.support.JSONData;
import alfio.model.system.AdminJobSchedule;
import ch.digitalfondue.npjt.Bind;
import ch.digitalfondue.npjt.Query;
import ch.digitalfondue.npjt.QueryRepository;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

@QueryRepository
public interface AdminJobQueueRepository {
    @Query(value="select * from admin_job_queue where status = 'SCHEDULED' and job_name in (:jobNames) and request_ts < :now::timestamp for update skip locked")
    public List<AdminJobSchedule> loadPendingSchedules(@Bind(value="jobNames") Collection<String> var1, @Bind(value="now") ZonedDateTime var2);

    @Query(value="select * from admin_job_queue")
    public List<AdminJobSchedule> loadAll();

    @Query(value="update admin_job_queue set status = :status, execution_ts = :executionDate, metadata = to_json(:metadata::json) where id = :id")
    public int updateSchedule(@Bind(value="id") long var1, @Bind(value="status") AdminJobSchedule.Status var3, @Bind(value="executionDate") ZonedDateTime var4, @Bind(value="metadata") @JSONData Map<String, Object> var5);

    @Query(value="update admin_job_queue set request_ts = :requestTs, attempts = attempts + 1 where id = :id")
    public int scheduleRetry(@Bind(value="id") long var1, @Bind(value="requestTs") ZonedDateTime var3);

    @Query(value="insert into admin_job_queue(job_name, request_ts, metadata, status, attempts, allow_duplicates) values(:jobName, :requestTs, to_json(:metadata::json), 'SCHEDULED', 1, :allowDuplicates) on conflict do nothing")
    public int schedule(@Bind(value="jobName") AdminJobExecutor.JobName var1, @Bind(value="requestTs") ZonedDateTime var2, @Bind(value="metadata") @JSONData Map<String, Object> var3, @Bind(value="allowDuplicates") String var4);

    @Query(value="delete from admin_job_queue where status in (:status) and request_ts <= :requestTs")
    public int removePastSchedules(@Bind(value="requestTs") ZonedDateTime var1, @Bind(value="status") Set<String> var2);
}

