/*
 * Decompiled with CFR 0.152.
 */
package alfio.repository.system;

import alfio.model.support.JSONData;
import alfio.model.system.Configuration;
import alfio.model.system.ConfigurationKeyValuePathLevel;
import alfio.model.system.ConfigurationKeys;
import alfio.repository.system.ConfigurationRepository;
import ch.digitalfondue.npjt.Bind;
import ch.digitalfondue.npjt.Query;
import ch.digitalfondue.npjt.QueryRepository;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;

@QueryRepository
public interface ConfigurationRepository {
    public static final String INSERT_STATEMENT = "INSERT into configuration(c_key, c_value, description) values(:key, :value, :description)";
    public static final String SELECT_FROM_SYSTEM = "SELECT id, c_key, c_value, 'SYSTEM' as configuration_path_level FROM configuration ";
    public static final String SELECT_FROM_ORGANIZATION = "SELECT id, c_key, c_value, 'ORGANIZATION' as configuration_path_level FROM configuration_organization where organization_id_fk = :organizationId ";
    public static final String SELECT_FROM_PURCHASE_CONTEXT = "SELECT id, c_key, c_value, 'PURCHASE_CONTEXT' as configuration_path_level FROM configuration_purchase_context where organization_id_fk = :organizationId ";
    public static final String SELECT_FROM_EVENT = "SELECT id, c_key, c_value, 'PURCHASE_CONTEXT' as configuration_path_level FROM configuration_purchase_context where organization_id_fk = :organizationId  and event_id_fk = :eventId ";
    public static final String SELECT_FROM_SUBSCRIPTION_DESCRIPTOR = "SELECT id, c_key, c_value, 'PURCHASE_CONTEXT' as configuration_path_level FROM configuration_purchase_context where organization_id_fk = :organizationId  and subscription_descriptor_id_fk = :subscriptionDescriptorId ";
    public static final String SELECT_FROM_TICKET_CATEGORY = "SELECT id, c_key, c_value, 'TICKET_CATEGORY' as configuration_path_level FROM configuration_ticket_category where organization_id_fk = :organizationId and event_id_fk = :eventId and ticket_category_id_fk = :ticketCategoryId";
    public static final String SYSTEM_FIND_BY_KEY = "SELECT id, c_key, c_value, 'SYSTEM' as configuration_path_level FROM configuration  where c_key = :key";
    public static final String ORGANIZATION_FIND_BY_KEY = "SELECT id, c_key, c_value, 'ORGANIZATION' as configuration_path_level FROM configuration_organization where organization_id_fk = :organizationId  and c_key = :key ";
    public static final String EVENT_FIND_BY_KEY = "SELECT id, c_key, c_value, 'PURCHASE_CONTEXT' as configuration_path_level FROM configuration_purchase_context where organization_id_fk = :organizationId  and event_id_fk = :eventId  and c_key = :key ";
    public static final String SUBSCRIPTION_DESCRIPTOR_FIND_BY_KEY = "SELECT id, c_key, c_value, 'PURCHASE_CONTEXT' as configuration_path_level FROM configuration_purchase_context where organization_id_fk = :organizationId  and subscription_descriptor_id_fk = :subscriptionDescriptorId  and c_key = :key ";
    public static final String TICKET_CATEGORY_FIND_BY_KEY = "SELECT id, c_key, c_value, 'TICKET_CATEGORY' as configuration_path_level FROM configuration_ticket_category where organization_id_fk = :organizationId and event_id_fk = :eventId and ticket_category_id_fk = :ticketCategoryId and c_key = :key";

    @Query(value="SELECT id, c_key, c_value, 'SYSTEM' as configuration_path_level FROM configuration ")
    public List<Configuration> findSystemConfiguration();

    @Query(value="SELECT id, c_key, c_value, 'ORGANIZATION' as configuration_path_level FROM configuration_organization where organization_id_fk = :organizationId ")
    public List<Configuration> findOrganizationConfiguration(@Bind(value="organizationId") int var1);

    @Query(value="SELECT id, c_key, c_value, 'PURCHASE_CONTEXT' as configuration_path_level FROM configuration_purchase_context where organization_id_fk = :organizationId  and event_id_fk = :eventId ")
    public List<Configuration> findEventConfiguration(@Bind(value="organizationId") int var1, @Bind(value="eventId") int var2);

    @Query(value="SELECT id, c_key, c_value, 'PURCHASE_CONTEXT' as configuration_path_level FROM configuration_purchase_context where organization_id_fk = :organizationId  and subscription_descriptor_id_fk = :subscriptionDescriptorId ")
    public List<Configuration> findSubscriptionDescriptorConfiguration(@Bind(value="organizationId") int var1, @Bind(value="subscriptionDescriptorId") UUID var2);

    @Query(value="SELECT id, c_key, c_value, 'TICKET_CATEGORY' as configuration_path_level FROM configuration_ticket_category where organization_id_fk = :organizationId and event_id_fk = :eventId and ticket_category_id_fk = :ticketCategoryId")
    public List<Configuration> findCategoryConfiguration(@Bind(value="organizationId") int var1, @Bind(value="eventId") int var2, @Bind(value="ticketCategoryId") int var3);

    @Query(value="SELECT ticket_category_id_fk, c_value FROM configuration_ticket_category where organization_id_fk = :organizationId and event_id_fk = :eventId and c_key = :key")
    public List<CategoryAndValue> findAllCategoriesAndValueWith(@Bind(value="organizationId") int var1, @Bind(value="eventId") int var2, @Bind(value="key") String var3);

    @Query(value="select ticket_category_id_fk from configuration_ticket_category where ticket_category_id_fk in (:categories) and c_key = :flagName and c_value = :flagValue")
    public List<Integer> getCategoriesWithFlag(@Bind(value="categories") List<Integer> var1, @Bind(value="flagName") String var2, @Bind(value="flagValue") String var3);

    @Query(value="insert into configuration_purchase_context (c_key, c_value, description, event_id_fk, organization_id_fk) select c_key, c_value, description, :targetEventId, :targetOrgId from configuration_purchase_context where event_id_fk = :srcEventId and organization_id_fk = :srcOrgId")
    public int copyEventConfiguration(@Bind(value="targetEventId") int var1, @Bind(value="targetOrgId") int var2, @Bind(value="srcEventId") int var3, @Bind(value="srcOrgId") int var4);

    @Query(value="insert into configuration_ticket_category (c_key, c_value, description, event_id_fk, organization_id_fk, ticket_category_id_fk) select c_key, c_value, description, :targetEventId, :targetOrgId, :targetCategoryId from configuration_ticket_category where event_id_fk = :srcEventId and organization_id_fk = :srcOrgId and ticket_category_id_fk = :srcCategoryId")
    public int copyCategoryConfiguration(@Bind(value="targetEventId") int var1, @Bind(value="targetOrgId") int var2, @Bind(value="targetCategoryId") int var3, @Bind(value="srcEventId") int var4, @Bind(value="srcOrgId") int var5, @Bind(value="srcCategoryId") int var6);

    default public Map<Integer, String> getAllCategoriesAndValueWith(int organizationId, int eventId, ConfigurationKeys key) {
        return this.findAllCategoriesAndValueWith(organizationId, eventId, key.name()).stream().collect(Collectors.toMap(CategoryAndValue::getTicketCategoryId, CategoryAndValue::getValue));
    }

    @Query(value="SELECT id, c_key, c_value, 'SYSTEM' as configuration_path_level FROM configuration  where c_key = :key")
    public Configuration findByKey(@Bind(value="key") String var1);

    @Query(value="SELECT id, c_key, c_value, 'SYSTEM' as configuration_path_level FROM configuration  where c_key = :key")
    public Optional<Configuration> findOptionalByKey(@Bind(value="key") String var1);

    @Query(value="SELECT id, c_key, c_value, 'SYSTEM' as configuration_path_level FROM configuration  where c_key = :key")
    public List<Configuration> findByKeyAtSystemLevel(@Bind(value="key") String var1);

    @Query(value="SELECT id, c_key, c_value, 'SYSTEM' as configuration_path_level FROM configuration  where c_key = :key UNION ALL SELECT id, c_key, c_value, 'ORGANIZATION' as configuration_path_level FROM configuration_organization where organization_id_fk = :organizationId  and c_key = :key ")
    public List<Configuration> findByOrganizationAndKey(@Bind(value="organizationId") int var1, @Bind(value="key") String var2);

    @Query(value="SELECT id, c_key, c_value, 'ORGANIZATION' as configuration_path_level FROM configuration_organization where organization_id_fk = :organizationId  and c_key = :key ")
    public Optional<Configuration> findByKeyAtOrganizationLevel(@Bind(value="organizationId") int var1, @Bind(value="key") String var2);

    @Query(value="SELECT id, c_key, c_value, 'PURCHASE_CONTEXT' as configuration_path_level FROM configuration_purchase_context where organization_id_fk = :organizationId  and event_id_fk = :eventId  and c_key = :key ")
    public Optional<Configuration> findByKeyAtEventLevel(@Bind(value="eventId") int var1, @Bind(value="organizationId") int var2, @Bind(value="key") String var3);

    @Query(value="SELECT id, c_key, c_value, 'PURCHASE_CONTEXT' as configuration_path_level FROM configuration_purchase_context where organization_id_fk = :organizationId  and subscription_descriptor_id_fk = :subscriptionDescriptorId  and c_key = :key ")
    public Optional<Configuration> findByKeyAtSubscriptionDescriptorLevel(@Bind(value="subscriptionDescriptorId") UUID var1, @Bind(value="organizationId") int var2, @Bind(value="key") String var3);

    @Query(value="SELECT id, c_key, c_value, 'TICKET_CATEGORY' as configuration_path_level FROM configuration_ticket_category where organization_id_fk = :organizationId and event_id_fk = :eventId and ticket_category_id_fk = :ticketCategoryId and c_key = :key")
    public Optional<Configuration> findByKeyAtCategoryLevel(@Bind(value="eventId") int var1, @Bind(value="organizationId") int var2, @Bind(value="ticketCategoryId") int var3, @Bind(value="key") String var4);

    @Query(value="SELECT id, c_key, c_value, 'SYSTEM' as configuration_path_level FROM configuration  where c_key = :key UNION ALL SELECT id, c_key, c_value, 'ORGANIZATION' as configuration_path_level FROM configuration_organization where organization_id_fk = :organizationId  and c_key = :key  UNION ALL SELECT id, c_key, c_value, 'PURCHASE_CONTEXT' as configuration_path_level FROM configuration_purchase_context where organization_id_fk = :organizationId  and event_id_fk = :eventId  and c_key = :key ")
    public List<Configuration> findByEventAndKey(@Bind(value="organizationId") int var1, @Bind(value="eventId") int var2, @Bind(value="key") String var3);

    @Query(value="SELECT id, c_key, c_value, 'SYSTEM' as configuration_path_level FROM configuration  where c_key = :key UNION ALL SELECT id, c_key, c_value, 'ORGANIZATION' as configuration_path_level FROM configuration_organization where organization_id_fk = :organizationId  and c_key = :key  UNION ALL SELECT id, c_key, c_value, 'PURCHASE_CONTEXT' as configuration_path_level FROM configuration_purchase_context where organization_id_fk = :organizationId  and subscription_descriptor_id_fk = :subscriptionDescriptorId  and c_key = :key ")
    public List<Configuration> findBySubscriptionDescriptorAndKey(@Bind(value="organizationId") int var1, @Bind(value="subscriptionDescriptorId") UUID var2, @Bind(value="key") String var3);

    @Query(value="SELECT id, c_key, c_value, 'SYSTEM' as configuration_path_level FROM configuration  where c_key = :key UNION ALL SELECT id, c_key, c_value, 'ORGANIZATION' as configuration_path_level FROM configuration_organization where organization_id_fk = :organizationId  and c_key = :key  UNION ALL SELECT id, c_key, c_value, 'PURCHASE_CONTEXT' as configuration_path_level FROM configuration_purchase_context where organization_id_fk = :organizationId  and event_id_fk = :eventId  and c_key = :key  UNION ALL SELECT id, c_key, c_value, 'TICKET_CATEGORY' as configuration_path_level FROM configuration_ticket_category where organization_id_fk = :organizationId and event_id_fk = :eventId and ticket_category_id_fk = :ticketCategoryId and c_key = :key")
    public List<Configuration> findByTicketCategoryAndKey(@Bind(value="organizationId") int var1, @Bind(value="eventId") int var2, @Bind(value="ticketCategoryId") int var3, @Bind(value="key") String var4);

    @Query(value="(SELECT id, c_key, c_value, 'SYSTEM' as configuration_path_level FROM configuration  where c_key in (:keys)) UNION ALL (SELECT id, c_key, c_value, 'ORGANIZATION' as configuration_path_level FROM configuration_organization where organization_id_fk = :organizationId  and c_key in (:keys))")
    public List<ConfigurationKeyValuePathLevel> findByOrganizationAndKeys(@Bind(value="organizationId") int var1, @Bind(value="keys") Collection<String> var2);

    @Query(value="(SELECT id, c_key, c_value, 'SYSTEM' as configuration_path_level FROM configuration  where c_key in (:keys)) UNION ALL (SELECT id, c_key, c_value, 'ORGANIZATION' as configuration_path_level FROM configuration_organization where organization_id_fk = :organizationId  and c_key in (:keys)) UNION ALL (SELECT id, c_key, c_value, 'PURCHASE_CONTEXT' as configuration_path_level FROM configuration_purchase_context where organization_id_fk = :organizationId  and event_id_fk = :eventId  and c_key in (:keys))")
    public List<ConfigurationKeyValuePathLevel> findByEventAndKeys(@Bind(value="organizationId") int var1, @Bind(value="eventId") int var2, @Bind(value="keys") Collection<String> var3);

    @Query(value="(SELECT id, c_key, c_value, 'SYSTEM' as configuration_path_level FROM configuration  where c_key in (:keys)) UNION ALL (SELECT id, c_key, c_value, 'ORGANIZATION' as configuration_path_level FROM configuration_organization where organization_id_fk = :organizationId  and c_key in (:keys)) UNION ALL (SELECT id, c_key, c_value, 'PURCHASE_CONTEXT' as configuration_path_level FROM configuration_purchase_context where organization_id_fk = :organizationId  and subscription_descriptor_id_fk = :subscriptionDescriptorId  and c_key in (:keys))")
    public List<ConfigurationKeyValuePathLevel> findBySubscriptionDescriptorAndKeys(@Bind(value="organizationId") int var1, @Bind(value="subscriptionDescriptorId") UUID var2, @Bind(value="keys") Collection<String> var3);

    @Query(value="(SELECT id, c_key, c_value, 'SYSTEM' as configuration_path_level FROM configuration  where c_key in (:keys)) UNION ALL (SELECT id, c_key, c_value, 'ORGANIZATION' as configuration_path_level FROM configuration_organization where organization_id_fk = :organizationId  and c_key in (:keys)) UNION ALL (SELECT id, c_key, c_value, 'PURCHASE_CONTEXT' as configuration_path_level FROM configuration_purchase_context where organization_id_fk = :organizationId  and event_id_fk = :eventId  and c_key in (:keys)) UNION ALL(SELECT id, c_key, c_value, 'TICKET_CATEGORY' as configuration_path_level FROM configuration_ticket_category where organization_id_fk = :organizationId and event_id_fk = :eventId and ticket_category_id_fk = :ticketCategoryId and c_key in (:keys))")
    public List<ConfigurationKeyValuePathLevel> findByTicketCategoryAndKeys(@Bind(value="organizationId") int var1, @Bind(value="eventId") int var2, @Bind(value="ticketCategoryId") int var3, @Bind(value="keys") Collection<String> var4);

    @Query(value="SELECT id, c_key, c_value, 'SYSTEM' as configuration_path_level FROM configuration  where c_key in (:keys)")
    public List<ConfigurationKeyValuePathLevel> findByKeysAtSystemLevel(@Bind(value="keys") Collection<String> var1);

    @Query(value="DELETE FROM configuration where c_key = :key")
    public void deleteByKey(@Bind(value="key") String var1);

    @Query(value="DELETE FROM configuration_organization where c_key = :key and organization_id_fk = :organizationId")
    public void deleteOrganizationLevelByKey(@Bind(value="key") String var1, @Bind(value="organizationId") int var2);

    @Query(value="DELETE FROM configuration_purchase_context where c_key = :key and event_id_fk = :eventId")
    public void deleteEventLevelByKey(@Bind(value="key") String var1, @Bind(value="eventId") int var2);

    @Query(value="DELETE FROM configuration_purchase_context where c_key = :key and subscription_descriptor_id_fk = :subscriptionDescriptorId")
    public void deleteSubscriptionDescriptorLevelByKey(@Bind(value="key") String var1, @Bind(value="subscriptionDescriptorId") UUID var2);

    @Query(value="DELETE FROM configuration_ticket_category where c_key = :key and event_id_fk = :eventId and ticket_category_id_fk = :categoryId")
    public void deleteCategoryLevelByKey(@Bind(value="key") String var1, @Bind(value="eventId") int var2, @Bind(value="categoryId") int var3);

    @Query(value="INSERT into configuration(c_key, c_value, description) values(:key, :value, :description)")
    public int insert(@Bind(value="key") String var1, @Bind(value="value") String var2, @Bind(value="description") String var3);

    @Query(value="INSERT into configuration_organization(organization_id_fk, c_key, c_value, description) values(:orgId, :key, :value, :description)")
    public int insertOrganizationLevel(@Bind(value="orgId") int var1, @Bind(value="key") String var2, @Bind(value="value") String var3, @Bind(value="description") String var4);

    @Query(value="update configuration_organization set c_value = :value where organization_id_fk = :orgId and c_key = :key")
    public int updateOrganizationLevel(@Bind(value="orgId") int var1, @Bind(value="key") String var2, @Bind(value="value") String var3);

    @Query(value="update configuration_purchase_context set c_value = :value where event_id_fk = :eventId and organization_id_fk = :organizationId and c_key = :key")
    public int updateEventLevel(@Bind(value="eventId") int var1, @Bind(value="organizationId") int var2, @Bind(value="key") String var3, @Bind(value="value") String var4);

    @Query(value="update configuration_purchase_context set c_value = :value where subscription_descriptor_id_fk = :subscriptionDescriptorId and organization_id_fk = :organizationId and c_key = :key")
    public int updateSubscriptionDescriptorLevel(@Bind(value="subscriptionDescriptorId") UUID var1, @Bind(value="organizationId") int var2, @Bind(value="key") String var3, @Bind(value="value") String var4);

    @Query(value="update configuration_ticket_category set c_value = :value where event_id_fk = :eventId and organization_id_fk = :organizationId and ticket_category_id_fk = :ticketCategoryId and c_key = :key")
    public int updateCategoryLevel(@Bind(value="eventId") int var1, @Bind(value="organizationId") int var2, @Bind(value="ticketCategoryId") int var3, @Bind(value="key") String var4, @Bind(value="value") String var5);

    @Query(value="INSERT into configuration_purchase_context(organization_id_fk, event_id_fk, c_key, c_value, description) values(:orgId, :eventId, :key, :value, :description)")
    public int insertEventLevel(@Bind(value="orgId") int var1, @Bind(value="eventId") int var2, @Bind(value="key") String var3, @Bind(value="value") String var4, @Bind(value="description") String var5);

    @Query(value="INSERT into configuration_purchase_context(organization_id_fk, subscription_descriptor_id_fk, c_key, c_value, description) values(:orgId, :subscriptionDescriptorId, :key, :value, :description)")
    public int insertSubscriptionDescriptorLevel(@Bind(value="orgId") int var1, @Bind(value="subscriptionDescriptorId") UUID var2, @Bind(value="key") String var3, @Bind(value="value") String var4, @Bind(value="description") String var5);

    @Query(value="INSERT into configuration_ticket_category(organization_id_fk, event_id_fk, ticket_category_id_fk, c_key, c_value, description) values(:orgId, :eventId, :ticketCategoryId, :key, :value, :description)")
    public int insertTicketCategoryLevel(@Bind(value="orgId") int var1, @Bind(value="eventId") int var2, @Bind(value="ticketCategoryId") int var3, @Bind(value="key") String var4, @Bind(value="value") String var5, @Bind(value="description") String var6);

    @Query(value="UPDATE configuration set c_value = :value where c_key = :key")
    public int update(@Bind(value="key") String var1, @Bind(value="value") String var2);

    @Query(value="SELECT organization_id_fk FROM configuration_organization where c_key = :key and c_value = :value")
    public Optional<Integer> findOrganizationIdByKeyAndValue(@Bind(value="key") String var1, @Bind(value="value") String var2);

    @Query(value="select c_value::jsonb from configuration where c_key = 'TRANSLATION_OVERRIDE' union all select '{}'::jsonb limit 1")
    @JSONData
    public Map<String, Map<String, String>> getSystemOverrideMessages();

    @Query(value="select coalesce(jsonb_recursive_merge(a.c_value, b.c_value), '{}'::jsonb) from (select c_value::jsonb from configuration where c_key = 'TRANSLATION_OVERRIDE' union all select '{}'::jsonb limit 1) a, (select c_value::jsonb from configuration_organization where organization_id_fk = :orgId and c_key = 'TRANSLATION_OVERRIDE' union all select '{}'::jsonb limit 1) b")
    @JSONData
    public Map<String, Map<String, String>> getOrganizationOverrideMessages(@Bind(value="orgId") int var1);

    @Query(value="select coalesce(jsonb_recursive_merge(jsonb_recursive_merge(a.c_value, b.c_value), c.c_value), '{}'::jsonb) from (select c_value::jsonb from configuration where c_key = 'TRANSLATION_OVERRIDE' union all select '{}'::jsonb limit 1) a, (select c_value::jsonb from configuration_organization where organization_id_fk = :orgId and c_key = 'TRANSLATION_OVERRIDE' union all select '{}'::jsonb limit 1) b,(select c_value::jsonb from configuration_purchase_context where organization_id_fk = :orgId and event_id_fk = :eventId and c_key = 'TRANSLATION_OVERRIDE' union all select '{}'::jsonb limit 1) c")
    @JSONData
    public Map<String, Map<String, String>> getEventOverrideMessages(@Bind(value="orgId") int var1, @Bind(value="eventId") int var2);
}

