/*
 * Decompiled with CFR 0.152.
 */
package alfio.repository.user;

import alfio.model.user.Organization;
import ch.digitalfondue.npjt.AffectedRowCountAndKey;
import ch.digitalfondue.npjt.AutoGeneratedKey;
import ch.digitalfondue.npjt.Bind;
import ch.digitalfondue.npjt.Query;
import ch.digitalfondue.npjt.QueryRepository;
import java.util.Collection;
import java.util.List;
import java.util.Optional;

@QueryRepository
public interface OrganizationRepository {
    @Query(value="SELECT * FROM organization where id = :id")
    public Organization getById(@Bind(value="id") int var1);

    @Query(value="select name, email from organization where id = :id")
    public Organization.OrganizationContact getContactById(@Bind(value="id") int var1);

    @Query(value="SELECT * FROM organization where name = :name")
    public Optional<Organization> findByName(@Bind(value="name") String var1);

    @Query(value="SELECT distinct id FROM organization where name_openid in (:externalIds)")
    public List<Integer> findOrganizationIdsByExternalId(@Bind(value="externalIds") Collection<String> var1);

    @Query(value="select count(*) from organization where slug = :slug and (:currentId is null or id <> :currentId)")
    public Integer countBySlug(@Bind(value="slug") String var1, @Bind(value="currentId") Integer var2);

    @Query(value="SELECT id FROM organization where name = :name")
    public int getIdByName(@Bind(value="name") String var1);

    @Query(value="INSERT INTO organization(name, description, email, name_openid, slug) VALUES (:name, :description, :email, :externalId, :slug)")
    @AutoGeneratedKey(value="id")
    public AffectedRowCountAndKey<Integer> create(@Bind(value="name") String var1, @Bind(value="description") String var2, @Bind(value="email") String var3, @Bind(value="externalId") String var4, @Bind(value="slug") String var5);

    @Query(value="update organization set name = :name, description = :description, email = :email, name_openid = :externalId, slug = :slug where id = :id")
    public int update(@Bind(value="id") int var1, @Bind(value="name") String var2, @Bind(value="description") String var3, @Bind(value="email") String var4, @Bind(value="externalId") String var5, @Bind(value="slug") String var6);

    @Query(value="select * from ((select organization.* from organization inner join j_user_organization on org_id = organization.id where j_user_organization.user_id = (select ba_user.id from ba_user where ba_user.username = :username))  union (select * from organization where 'ROLE_ADMIN' in (select role from ba_user inner join authority on ba_user.username = authority.username where ba_user.username = :username))) as found_users order by found_users.name, id")
    public List<Organization> findAllForUser(@Bind(value="username") String var1);

    @Query(value="(select organization.* from organization inner join j_user_organization on org_id = organization.id where j_user_organization.user_id = (select ba_user.id from ba_user where ba_user.username = :username) and organization.id = :orgId)  union (select * from organization where 'ROLE_ADMIN' in (select role from ba_user inner join authority on ba_user.username = authority.username where ba_user.username = :username) and id = :orgId)")
    public Optional<Organization> findOrganizationForUser(@Bind(value="username") String var1, @Bind(value="orgId") int var2);
}

