/*
 * Decompiled with CFR 0.152.
 */
package alfio.repository.user;

import alfio.model.TicketReservationInvoicingAdditionalInfo;
import alfio.model.support.JSONData;
import alfio.model.user.AdditionalInfoWithLabel;
import alfio.model.user.PublicUserProfile;
import alfio.model.user.User;
import ch.digitalfondue.npjt.AffectedRowCountAndKey;
import ch.digitalfondue.npjt.AutoGeneratedKey;
import ch.digitalfondue.npjt.Bind;
import ch.digitalfondue.npjt.Query;
import ch.digitalfondue.npjt.QueryRepository;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

@QueryRepository
public interface UserRepository {
    @Query(value="SELECT * FROM ba_user WHERE id = :userId")
    public User findById(@Bind(value="userId") int var1);

    @Query(value="SELECT * FROM ba_user WHERE id = :userId")
    public Optional<User> findOptionalById(@Bind(value="userId") int var1);

    @Query(value="select * from ba_user where id in (:userIds)")
    public List<User> findByIds(@Bind(value="userIds") Collection<Integer> var1);

    @Query(value="select * from ba_user left join j_user_organization on ba_user.id = j_user_organization.user_id where j_user_organization.org_id = :orgId and ba_user.user_type = 'API_KEY'")
    public List<User> findAllApiKeysForOrganization(@Bind(value="orgId") int var1);

    @Query(value="select id from ba_user join j_user_organization on ba_user.id = j_user_organization.user_id where j_user_organization.org_id = :orgId and ba_user.username = :apiKey and ba_user.user_type = 'API_KEY'")
    public Optional<Integer> findUserIdForApiKey(@Bind(value="orgId") int var1, @Bind(value="apiKey") String var2);

    @Query(value="select * from ba_user where username = :username")
    public User getByUsername(@Bind(value="username") String var1);

    @Query(value="select * from ba_user where username = :username")
    public Optional<User> findByUsername(@Bind(value="username") String var1);

    @Query(value="select id from ba_user where username = :username")
    public Optional<Integer> findIdByUserName(@Bind(value="username") String var1);

    default public Optional<Integer> nullSafeFindIdByUserName(String username) {
        if (StringUtils.isNotBlank((CharSequence)username)) {
            return this.findIdByUserName(username);
        }
        return Optional.empty();
    }

    @Query(value="select * from ba_user where username = :username and enabled = true")
    public Optional<User> findEnabledByUsername(@Bind(value="username") String var1);

    @Query(value="select id from ba_user where username = :username and user_type = 'PUBLIC' and enabled = true")
    public Optional<Integer> findPublicUserIdByUsername(@Bind(value="username") String var1);

    @Query(value="select password from ba_user where username = :username and enabled = true")
    public Optional<String> findPasswordByUsername(@Bind(value="username") String var1);

    @Query(value="INSERT INTO ba_user(username, password, first_name, last_name, email_address, enabled, user_type, valid_to, description) VALUES (:username, :password, :first_name, :last_name, :email_address, :enabled, :userType, :validTo, :description)")
    @AutoGeneratedKey(value="id")
    public AffectedRowCountAndKey<Integer> create(@Bind(value="username") String var1, @Bind(value="password") String var2, @Bind(value="first_name") String var3, @Bind(value="last_name") String var4, @Bind(value="email_address") String var5, @Bind(value="enabled") boolean var6, @Bind(value="userType") User.Type var7, @Bind(value="validTo") ZonedDateTime var8, @Bind(value="description") String var9);

    @Query(value="INSERT INTO ba_user(username, password, first_name, last_name, email_address, enabled, user_type) VALUES (:username, :password, :first_name, :last_name, :email_address, :enabled, 'PUBLIC') on conflict(username) do nothing")
    public int createPublicUserIfNotExists(@Bind(value="username") String var1, @Bind(value="password") String var2, @Bind(value="first_name") String var3, @Bind(value="last_name") String var4, @Bind(value="email_address") String var5, @Bind(value="enabled") boolean var6);

    @Query(value="update ba_user set username = :username, first_name = :firstName, last_name = :lastName, email_address = :emailAddress, description = :description where id = :id")
    public int update(@Bind(value="id") int var1, @Bind(value="username") String var2, @Bind(value="firstName") String var3, @Bind(value="lastName") String var4, @Bind(value="emailAddress") String var5, @Bind(value="description") String var6);

    @Query(value="update ba_user set first_name = :firstName, last_name = :lastName, email_address = :emailAddress where id = :id")
    public int updateContactInfo(@Bind(value="id") int var1, @Bind(value="firstName") String var2, @Bind(value="lastName") String var3, @Bind(value="emailAddress") String var4);

    @Query(value="update ba_user set enabled = :enabled where id = :id")
    public int toggleEnabled(@Bind(value="id") int var1, @Bind(value="enabled") boolean var2);

    @Query(value="update ba_user set password = :password where id = :id")
    public int resetPassword(@Bind(value="id") int var1, @Bind(value="password") String var2);

    @Query(value="delete from sponsor_scan where user_id = :id")
    public int deleteUserFromSponsorScan(@Bind(value="id") int var1);

    @Query(value="delete from j_user_organization where user_id = :id")
    public int deleteUserFromOrganization(@Bind(value="id") int var1);

    @Query(value="delete from ba_user where id = :id")
    public int deleteUser(@Bind(value="id") int var1);

    @Query(value="select id from ba_user where user_type in (:types) and enabled = true and user_creation_time < :date")
    public List<Integer> findUsersToDeleteOlderThan(@Bind(value="date") Date var1, @Bind(value="types") Collection<String> var2);

    @Query(value="delete from authority where username = (select username from ba_user where id = :id)")
    public int deleteUserFromAuthority(@Bind(value="id") int var1);

    @Query(value="insert into user_profile (user_id_fk, billing_address_company, billing_address_line1, billing_address_line2, billing_address_zip,billing_address_city, billing_address_state, vat_country, vat_nr, invoicing_additional_information, additional_fields) values (:userId, :company, :line1, :line2, :zip, :city, :state, :country, :taxId, :invoiceInfo::jsonb, :addFields::jsonb) on conflict (user_id_fk) do update set  billing_address_company = EXCLUDED.billing_address_company, billing_address_line1 = EXCLUDED.billing_address_line1, billing_address_line2 = EXCLUDED.billing_address_line2, billing_address_zip = EXCLUDED.billing_address_zip, billing_address_city = EXCLUDED.billing_address_city, billing_address_state = EXCLUDED.billing_address_state, vat_country = EXCLUDED.vat_country, vat_nr = EXCLUDED.vat_nr, invoicing_additional_information = EXCLUDED.invoicing_additional_information::jsonb, additional_fields = EXCLUDED.additional_fields::jsonb")
    public int persistUserProfile(@Bind(value="userId") int var1, @Bind(value="company") String var2, @Bind(value="line1") String var3, @Bind(value="line2") String var4, @Bind(value="zip") String var5, @Bind(value="city") String var6, @Bind(value="state") String var7, @Bind(value="country") String var8, @Bind(value="taxId") String var9, @Bind(value="invoiceInfo") @JSONData TicketReservationInvoicingAdditionalInfo var10, @Bind(value="addFields") @JSONData Map<String, AdditionalInfoWithLabel> var11);

    @Query(value="select * from user_profile where user_id_fk = :userId")
    public Optional<PublicUserProfile> loadUserProfile(@Bind(value="userId") int var1);

    @Query(value="delete from user_profile where user_id_fk = :userId")
    public int deleteUserProfile(@Bind(value="userId") int var1);

    default public void deleteUserAndReferences(int userId) {
        this.deleteUserFromSponsorScan(userId);
        this.deleteUserFromOrganization(userId);
        this.deleteUserFromAuthority(userId);
        this.deleteUserProfile(userId);
        this.deleteUser(userId);
    }

    @Query(value="update ba_user set enabled = false, email_address = :newEmail, username = :newEmail, first_name = 'Deleted', last_name = 'Deleted' where id = :userId")
    public int invalidatePublicUser(@Bind(value="userId") int var1, @Bind(value="newEmail") String var2);
}

