/*
 * Decompiled with CFR 0.152.
 */
package alfio.repository.user.join;

import alfio.model.user.join.UserOrganization;
import ch.digitalfondue.npjt.Bind;
import ch.digitalfondue.npjt.Query;
import ch.digitalfondue.npjt.QueryRepository;
import ch.digitalfondue.npjt.QueryType;
import java.util.Collection;
import java.util.List;

@QueryRepository
public interface UserOrganizationRepository {
    @Query(value="select exists(select 1 from j_user_organization where user_id = :userId and org_id = :organizationId)")
    public boolean userIsInOrganization(@Bind(value="userId") int var1, @Bind(value="organizationId") int var2);

    @Query(value="select * from j_user_organization where user_id = :userId")
    public List<UserOrganization> findByUserId(@Bind(value="userId") int var1);

    @Query(value="select * from j_user_organization where org_id = :organizationId")
    public List<UserOrganization> findByOrganizationId(@Bind(value="organizationId") int var1);

    @Query(value="select * from j_user_organization where org_id in (:organizationIds) order by user_id")
    public List<UserOrganization> findByOrganizationIdsOrderByUserId(@Bind(value="organizationIds") List<Integer> var1);

    @Query(value="insert into j_user_organization (user_id, org_id) values(:userId, :organizationId)")
    public int create(@Bind(value="userId") int var1, @Bind(value="organizationId") int var2);

    @Query(type=QueryType.TEMPLATE, value="insert into j_user_organization (user_id, org_id) values(:userId, :organizationId)")
    public String bulkCreate();

    @Query(value="update j_user_organization set org_id = :organizationId where user_id = :userId")
    public int updateUserOrganization(@Bind(value="userId") int var1, @Bind(value="organizationId") int var2);

    @Query(value="select distinct(org_id) from j_user_organization where user_id in(:users)")
    public List<Integer> findOrganizationsForUsers(@Bind(value="users") List<Integer> var1);

    @Query(value="delete from j_user_organization where user_id = :userId and org_id in (:organizationIds)")
    public int removeOrganizationUserLinks(@Bind(value="userId") int var1, @Bind(value="organizationIds") Collection<Integer> var2);

    @Query(value="delete from j_user_organization where org_id = :organizationId")
    public int cleanupOrganization(@Bind(value="organizationId") int var1);
}

