/*
 * Decompiled with CFR 0.152.
 */
package alfio.util;

import alfio.util.ClockProvider;
import java.time.Clock;
import java.time.ZoneId;
import java.util.Objects;
import org.apache.commons.lang3.Validate;

public class ClockProvider {
    private static ClockHolder HOLDER;

    private ClockProvider(Clock clock) {
        HOLDER = new ClockHolder(clock);
    }

    public static ClockProvider init(Clock clock) {
        Validate.isTrue((HOLDER == null ? 1 : 0) != 0, (String)"Clock has already been set", (Object[])new Object[0]);
        return new ClockProvider(clock);
    }

    public static Clock clock() {
        return Objects.requireNonNull(ClockProvider.HOLDER).clock;
    }

    public Clock getClock() {
        return ClockProvider.HOLDER.clock;
    }

    public Clock withZone(ZoneId zoneId) {
        return ClockProvider.HOLDER.clock.withZone(zoneId);
    }
}

