/*
 * Decompiled with CFR 0.152.
 */
package alfio.util;

import alfio.controller.decorator.SaleableTicketCategory;
import alfio.manager.PurchaseContextFieldManager;
import alfio.manager.system.ConfigurationManager;
import alfio.model.BookedAdditionalService;
import alfio.model.Event;
import alfio.model.EventAndOrganizationId;
import alfio.model.EventCheckInInfo;
import alfio.model.EventStatisticView;
import alfio.model.FieldConfigurationDescriptionAndValue;
import alfio.model.LocalizedContent;
import alfio.model.PurchaseContext;
import alfio.model.Ticket;
import alfio.model.TicketCategory;
import alfio.model.TicketCategoryStatisticView;
import alfio.model.metadata.JoinLink;
import alfio.model.metadata.OnlineConfiguration;
import alfio.model.system.ConfigurationKeys;
import alfio.model.user.Organization;
import alfio.repository.AdditionalServiceItemRepository;
import alfio.repository.TicketRepository;
import alfio.util.ClockProvider;
import alfio.util.MonetaryUtil;
import alfio.util.MustacheCustomTag;
import biweekly.ICalVersion;
import biweekly.ICalendar;
import biweekly.component.VEvent;
import biweekly.io.text.ICalWriter;
import biweekly.property.Organizer;
import biweekly.property.Status;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringUtils;
import org.flywaydb.core.api.MigrationVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.util.Assert;
import org.springframework.web.util.UriComponentsBuilder;

/*
 * Exception performing whole class analysis ignored.
 */
public final class EventUtil {
    private static final Logger log = LoggerFactory.getLogger(EventUtil.class);
    private static final DateTimeFormatter JSON_TIME_FORMATTER = new DateTimeFormatterBuilder().appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).toFormatter(Locale.ROOT);
    public static final DateTimeFormatter JSON_DATETIME_FORMATTER = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral('T').append(JSON_TIME_FORMATTER).appendLiteral('Z').toFormatter(Locale.ROOT);

    private EventUtil() {
    }

    public static boolean displayWaitingQueueForm(Event event, List<SaleableTicketCategory> categories, Map<ConfigurationKeys, ConfigurationManager.MaybeConfiguration> confVal, Predicate<EventAndOrganizationId> noTicketsAvailable) {
        Assert.isTrue((boolean)confVal.keySet().containsAll(Set.of(ConfigurationKeys.STOP_WAITING_QUEUE_SUBSCRIPTIONS, ConfigurationKeys.ENABLE_PRE_REGISTRATION, ConfigurationKeys.ENABLE_WAITING_QUEUE)), (String)"Configuration must contains the specified key STOP_WAITING_QUEUE_SUBSCRIPTIONS, ENABLE_PRE_REGISTRATION, ENABLE_WAITING_QUEUE");
        return !confVal.get(ConfigurationKeys.STOP_WAITING_QUEUE_SUBSCRIPTIONS).getValueAsBooleanOrDefault() && EventUtil.checkWaitingQueuePreconditions((Event)event, categories, noTicketsAvailable, confVal);
    }

    private static boolean checkWaitingQueuePreconditions(Event event, List<SaleableTicketCategory> categories, Predicate<EventAndOrganizationId> noTicketsAvailable, Map<ConfigurationKeys, ConfigurationManager.MaybeConfiguration> confVal) {
        return EventUtil.findLastCategory(categories).map(lastCategory -> {
            ZonedDateTime now = event.now(ClockProvider.clock());
            if (EventUtil.isPreSales((Event)event, (List)categories)) {
                return ((ConfigurationManager.MaybeConfiguration)confVal.get(ConfigurationKeys.ENABLE_PRE_REGISTRATION)).getValueAsBooleanOrDefault();
            }
            if (((ConfigurationManager.MaybeConfiguration)confVal.get(ConfigurationKeys.ENABLE_WAITING_QUEUE)).getValueAsBooleanOrDefault()) {
                return now.isBefore(lastCategory.getZonedExpiration()) && noTicketsAvailable.test((EventAndOrganizationId)event);
            }
            return false;
        }).orElse(false);
    }

    public static boolean checkWaitingQueuePreconditions(Event event, List<SaleableTicketCategory> categories, ConfigurationManager configurationManager, Predicate<EventAndOrganizationId> noTicketsAvailable) {
        Map confVal = configurationManager.getFor(List.of(ConfigurationKeys.ENABLE_PRE_REGISTRATION, ConfigurationKeys.ENABLE_WAITING_QUEUE), event.getConfigurationLevel());
        return EventUtil.checkWaitingQueuePreconditions((Event)event, categories, noTicketsAvailable, (Map)confVal);
    }

    private static Optional<SaleableTicketCategory> findLastCategory(List<SaleableTicketCategory> categories) {
        return EventUtil.sortCategories(categories, (c1, c2) -> c2.getUtcExpiration().compareTo(c1.getUtcExpiration())).findFirst();
    }

    private static Optional<SaleableTicketCategory> findFirstCategory(List<SaleableTicketCategory> categories) {
        return EventUtil.sortCategories(categories, Comparator.comparing(SaleableTicketCategory::getUtcExpiration)).findFirst();
    }

    private static Stream<SaleableTicketCategory> sortCategories(List<SaleableTicketCategory> categories, Comparator<SaleableTicketCategory> comparator) {
        return Optional.ofNullable(categories).orElse(Collections.emptyList()).stream().sorted(comparator);
    }

    public static boolean isPreSales(Event event, List<SaleableTicketCategory> categories) {
        ZonedDateTime now = event.now(ClockProvider.clock());
        return EventUtil.findFirstCategory(categories).map(c -> now.isBefore(c.getZonedInception())).orElse(false);
    }

    public static Stream<MapSqlParameterSource> generateEmptyTickets(EventAndOrganizationId event, Date creationDate, int limit, Ticket.TicketStatus ticketStatus) {
        return EventUtil.generateStreamForTicketCreation((int)limit).map(ps -> EventUtil.buildTicketParams((int)event.getId(), (Date)creationDate, Optional.empty(), (int)0, (MapSqlParameterSource)ps, (Ticket.TicketStatus)ticketStatus));
    }

    public static Stream<MapSqlParameterSource> generateStreamForTicketCreation(int limit) {
        return Stream.generate(MapSqlParameterSource::new).limit(limit);
    }

    public static MapSqlParameterSource buildTicketParams(int eventId, Date creation, Optional<TicketCategory> tc, int srcPriceCts, MapSqlParameterSource ps) {
        return EventUtil.buildTicketParams((int)eventId, (Date)creation, tc, (int)srcPriceCts, (MapSqlParameterSource)ps, (Ticket.TicketStatus)Ticket.TicketStatus.FREE);
    }

    private static MapSqlParameterSource buildTicketParams(int eventId, Date creation, Optional<TicketCategory> tc, int srcPriceCts, MapSqlParameterSource ps, Ticket.TicketStatus ticketStatus) {
        return ps.addValue("uuid", (Object)UUID.randomUUID().toString()).addValue("publicUuid", (Object)UUID.randomUUID()).addValue("creation", (Object)creation).addValue("categoryId", tc.map(TicketCategory::getId).orElse(null)).addValue("eventId", (Object)eventId).addValue("status", (Object)ticketStatus.name()).addValue("srcPriceCts", (Object)srcPriceCts);
    }

    public static int evaluatePrice(BigDecimal price, boolean freeOfCharge, String currencyCode) {
        return freeOfCharge ? 0 : MonetaryUtil.unitToCents((BigDecimal)Objects.requireNonNull(price), (String)Objects.requireNonNull(currencyCode));
    }

    public static int determineAvailableSeats(TicketCategoryStatisticView tc, EventStatisticView e) {
        return tc.isBounded() ? tc.getNotSoldTicketsCount() : e.getDynamicAllocation();
    }

    public static Optional<byte[]> getIcalForEvent(Event event, TicketCategory ticketCategory, String description, Organization organization) {
        Optional<byte[]> optional;
        ICalendar ical = new ICalendar();
        ical.setProductId("-//Alf.io//Alf.io v2.0//EN");
        ical.setMethod("PUBLISH");
        VEvent vEvent = new VEvent();
        vEvent.setSummary(event.getDisplayName());
        vEvent.setDescription(MustacheCustomTag.renderToTextCommonmark((String)description));
        if (!EventUtil.isAccessOnline((TicketCategory)ticketCategory, (EventCheckInInfo)event)) {
            vEvent.setLocation(RegExUtils.replacePattern((String)event.getLocation(), (String)"[\n\r\t]+", (String)" "));
        }
        ZonedDateTime begin = Optional.ofNullable(ticketCategory).map(tc -> tc.getTicketValidityStart(event.getZoneId())).orElse(event.getBegin());
        ZonedDateTime end = Optional.ofNullable(ticketCategory).map(tc -> tc.getTicketValidityEnd(event.getZoneId())).orElse(event.getEnd());
        vEvent.setDateStart(Date.from(begin.toInstant()));
        vEvent.setDateEnd(Date.from(end.toInstant()));
        vEvent.setUrl(event.getWebsiteUrl());
        vEvent.setStatus(Status.confirmed());
        if (organization != null) {
            vEvent.setOrganizer(new Organizer(organization.getName(), organization.getEmail()));
        }
        ical.addEvent(vEvent);
        StringWriter strWriter = new StringWriter();
        ICalWriter writer = new ICalWriter((Writer)strWriter, ICalVersion.V2_0);
        try {
            writer.write(ical);
            optional = Optional.of(strWriter.toString().getBytes(StandardCharsets.UTF_8));
        }
        catch (Throwable throwable) {
            try {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                log.warn("was not able to generate iCal for event " + event.getShortName(), (Throwable)e);
                return Optional.empty();
            }
        }
        writer.close();
        return optional;
    }

    public static Optional<byte[]> getIcalForEvent(Event event, TicketCategory ticketCategory, String description) {
        return EventUtil.getIcalForEvent((Event)event, (TicketCategory)ticketCategory, (String)description, null);
    }

    public static String getGoogleCalendarURL(Event event, TicketCategory category, String description) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyMMdd'T'HHmmss");
        ZonedDateTime validityStart = Optional.ofNullable(category).map(TicketCategory::getTicketValidityStart).map(d -> d.withZoneSameInstant(event.getZoneId())).orElse(event.getBegin());
        ZonedDateTime validityEnd = Optional.ofNullable(category).map(TicketCategory::getTicketValidityEnd).map(d -> d.withZoneSameInstant(event.getZoneId())).orElse(event.getEnd());
        return UriComponentsBuilder.fromUriString((String)"https://www.google.com/calendar/event").queryParam("action", new Object[]{"TEMPLATE"}).queryParam("dates", new Object[]{validityStart.format(formatter) + "/" + validityEnd.format(formatter)}).queryParam("ctz", new Object[]{event.getTimeZone()}).queryParam("text", new Object[]{event.getDisplayName()}).queryParam("location", new Object[]{event.getLocation()}).queryParam("details", new Object[]{StringUtils.abbreviate((String)description, (int)1024)}).toUriString();
    }

    public static BiFunction<Ticket, Event, List<FieldConfigurationDescriptionAndValue>> retrieveFieldValues(TicketRepository ticketRepository, PurchaseContextFieldManager purchaseContextFieldManager, AdditionalServiceItemRepository additionalServiceItemRepository, boolean formatValues) {
        return (ticket, event) -> {
            String reservationId = ticket.getTicketsReservationId();
            List additionalServiceItems = EventUtil.getBookedAdditionalServices((TicketRepository)ticketRepository, (AdditionalServiceItemRepository)additionalServiceItemRepository, (Ticket)ticket, (Event)event, (String)reservationId);
            return purchaseContextFieldManager.getFieldDescriptionAndValues((PurchaseContext)event, ticket, null, additionalServiceItems, ticket.getUserLanguage(), formatValues);
        };
    }

    private static List<BookedAdditionalService> getBookedAdditionalServices(TicketRepository ticketRepository, AdditionalServiceItemRepository additionalServiceItemRepository, Ticket ticket, Event event, String reservationId) {
        if (event.supportsLinkedAdditionalServices()) {
            return additionalServiceItemRepository.getAdditionalServicesBookedForTicket(reservationId, ticket.getId(), ticket.getUserLanguage(), event.getId());
        }
        Optional ticketsInReservation = ticketRepository.findFirstTicketIdInReservation(reservationId);
        if (ticketsInReservation.filter(id -> id.intValue() == ticket.getId()).isPresent()) {
            return additionalServiceItemRepository.getAdditionalServicesBookedForReservation(reservationId, ticket.getUserLanguage(), event.getId());
        }
        return List.of();
    }

    public static Optional<String> findMatchingLink(ZoneId eventZoneId, OnlineConfiguration categoryConfiguration, OnlineConfiguration eventConfiguration) {
        return EventUtil.firstMatchingCallLink((ZoneId)eventZoneId, (OnlineConfiguration)categoryConfiguration, (OnlineConfiguration)eventConfiguration).map(JoinLink::getLink);
    }

    public static Optional<JoinLink> firstMatchingCallLink(ZoneId eventZoneId, OnlineConfiguration categoryConfiguration, OnlineConfiguration eventConfiguration) {
        ZonedDateTime now = ZonedDateTime.now(ClockProvider.clock().withZone(eventZoneId));
        return EventUtil.firstMatchingCallLink((OnlineConfiguration)categoryConfiguration, (ZoneId)eventZoneId, (ZonedDateTime)now).or(() -> EventUtil.firstMatchingCallLink((OnlineConfiguration)eventConfiguration, (ZoneId)eventZoneId, (ZonedDateTime)now));
    }

    private static Optional<JoinLink> firstMatchingCallLink(OnlineConfiguration onlineConfiguration, ZoneId zoneId, ZonedDateTime now) {
        return Optional.ofNullable(onlineConfiguration).stream().flatMap(configuration -> configuration.getCallLinks().stream()).sorted(Comparator.comparing(JoinLink::getValidFrom).reversed()).filter(joinLink -> now.isBefore(joinLink.getValidTo().atZone(zoneId)) && now.plusSeconds(1L).isAfter(joinLink.getValidFrom().atZone(zoneId))).findFirst();
    }

    public static boolean isAccessOnline(TicketCategory category, EventCheckInInfo event) {
        return event.getFormat() == Event.EventFormat.ONLINE || event.getFormat() == Event.EventFormat.HYBRID && category != null && category.getTicketAccessType() == TicketCategory.TicketAccessType.ONLINE;
    }

    public static String getLocalizedMessage(Map<String, String> messagesByLang, String lang, LocalizedContent fallback) {
        if (messagesByLang.isEmpty()) {
            return null;
        }
        if (messagesByLang.containsKey(lang)) {
            return messagesByLang.get(lang);
        }
        String defaultLanguage = fallback.getFirstContentLanguage().getLanguage();
        if (messagesByLang.containsKey(defaultLanguage)) {
            return messagesByLang.get(defaultLanguage);
        }
        return messagesByLang.values().stream().findFirst().orElseThrow();
    }

    public static boolean supportsCaseInsensitiveQRCode(String version) {
        return version != null && MigrationVersion.fromVersion((String)version).compareTo(MigrationVersion.fromVersion((String)"205.2.0.0.50")) >= 0;
    }

    public static boolean supportsLinkedAdditionalServices(String version) {
        return version != null && MigrationVersion.fromVersion((String)version).compareTo(MigrationVersion.fromVersion((String)"205.2.0.0.52")) >= 0;
    }

    public static boolean supportsAdditionalItemsOrdinal(String version) {
        return version != null && MigrationVersion.fromVersion((String)version).compareTo(MigrationVersion.fromVersion((String)"205.2.0.0.58")) >= 0;
    }
}

