/*
 * Decompiled with CFR 0.152.
 */
package alfio.util;

import ch.digitalfondue.basicxlsx.Cell;
import ch.digitalfondue.basicxlsx.StreamingWorkbook;
import ch.digitalfondue.basicxlsx.Style;
import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.databind.SequenceWriter;
import com.fasterxml.jackson.dataformat.csv.CsvMapper;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class ExportUtils {
    private static final int[] BOM_MARKERS = new int[]{239, 187, 191};
    public static final String X_ROBOTS_TAG = "X-Robots-Tag";

    private ExportUtils() {
    }

    public static void exportExcel(String fileName, String sheetName, String[] header, Stream<String[]> data, HttpServletResponse response) throws IOException {
        ExportUtils.exportExcel((String)fileName, (HttpServletResponse)response, (T workbook) -> ExportUtils.addSheetToWorkbook((String)sheetName, (String[])header, (Stream)data, (StreamingWorkbook)workbook, (Style)workbook.defineStyle().font().bold(true).build()));
    }

    public static void exportExcel(String fileName, HttpServletResponse response, Consumer<StreamingWorkbook> workbookConsumer) throws IOException {
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        response.setHeader("Content-Disposition", "attachment; filename=" + fileName);
        ExportUtils.markAsNoIndex((HttpServletResponse)response);
        try (ServletOutputStream out = response.getOutputStream();
             StreamingWorkbook workbook = new StreamingWorkbook((OutputStream)out);){
            workbookConsumer.accept(workbook);
        }
    }

    public static void addSheetToWorkbook(String sheetName, String[] header, Stream<String[]> data, StreamingWorkbook workbook, Style headerStyle) {
        try {
            StreamingWorkbook.Row headerRow = StreamingWorkbook.row((Collection)Arrays.stream(header).map(v -> Cell.cell((String)v).withStyle(headerStyle)).collect(Collectors.toList()));
            Stream<StreamingWorkbook.Row> dataStream = data.map(rowData -> Arrays.stream(rowData).map(Cell::cell).collect(Collectors.toList())).map(StreamingWorkbook::row);
            workbook.withSheet(sheetName, Stream.concat(Stream.of(headerRow), dataStream));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private static String escapeFormulaChar(String s) {
        String trimmed = StringUtils.trimToEmpty((String)s);
        Object res = trimmed;
        if (StringUtils.startsWithAny((CharSequence)trimmed, (CharSequence[])new CharSequence[]{"=", "+", "-", "@"})) {
            res = "\t" + trimmed;
        }
        return res;
    }

    public static void exportCsv(String fileName, String[] header, Stream<String[]> data, HttpServletResponse response) throws IOException {
        response.setContentType("text/csv;charset=UTF-8");
        response.setHeader("Content-Disposition", "attachment; filename=" + fileName);
        ExportUtils.markAsNoIndex((HttpServletResponse)response);
        CsvSchema.Builder headerBuilder = CsvSchema.builder().setUseHeader(true).setQuoteChar('\"');
        Arrays.stream(header).forEach(arg_0 -> ((CsvSchema.Builder)headerBuilder).addColumn(arg_0));
        try (ServletOutputStream out = response.getOutputStream();){
            for (int marker : BOM_MARKERS) {
                out.write(marker);
            }
            SequenceWriter writer = new CsvMapper().writer().with((FormatSchema)headerBuilder.build()).writeValues((OutputStream)out);
            data.forEachOrdered(d -> {
                String[] copy = Arrays.copyOf(d, ((String[])d).length);
                for (int i = 0; i < copy.length; ++i) {
                    String res = copy[i];
                    copy[i] = ExportUtils.escapeFormulaChar((String)res);
                }
                try {
                    writer.write((Object)copy);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
            writer.flush();
            out.flush();
        }
    }

    public static void markAsNoIndex(HttpServletResponse response) {
        response.setHeader("X-Robots-Tag", "noindex");
    }
}

