/*
 * Decompiled with CFR 0.152.
 */
package alfio.util;

import alfio.model.BillingDocument;
import alfio.util.ExportUtils;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.Optional;

/*
 * Exception performing whole class analysis ignored.
 */
public class FileUtil {
    public static boolean sendPdf(byte[] res, HttpServletResponse response, String eventName, String reservationId, BillingDocument billingDocument) {
        return Optional.ofNullable(res).map(pdf -> {
            try {
                FileUtil.sendHeaders((HttpServletResponse)response, (String)eventName, (String)reservationId, (BillingDocument)billingDocument);
                response.getOutputStream().write(pdf);
                return true;
            }
            catch (IOException e) {
                return false;
            }
        }).orElse(false);
    }

    public static void sendHeaders(HttpServletResponse response, String eventName, String reservationId, BillingDocument billingDocument) {
        response.setHeader("Content-Disposition", "attachment; filename=\"" + FileUtil.getBillingDocumentFileName((String)eventName, (String)reservationId, (BillingDocument)billingDocument) + "\"");
        response.setContentType("application/pdf");
        ExportUtils.markAsNoIndex((HttpServletResponse)response);
    }

    public static String getBillingDocumentFileName(String eventShortName, String reservationId, BillingDocument document) {
        if (document.getType() != BillingDocument.Type.RECEIPT) {
            Map reservationModel = document.getModel();
            ZonedDateTime invoiceDate = ZonedDateTime.parse((String)reservationModel.get("confirmationDate"));
            String formattedDate = invoiceDate.format(DateTimeFormatter.ofPattern("yyyy-MM-dd-HHmmss"));
            return eventShortName + "-" + formattedDate + "-" + document.getNumber() + "-" + document.getId() + ".pdf";
        }
        return "receipt-" + eventShortName + "-" + reservationId + ".pdf";
    }
}

